/*
 * @(#)ClusterGoodbyeInfo.java	1.4 06/07/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import java.io.*;
import java.util.*;
import java.nio.*;
import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;

/**
 * An instance of this class is intended to be used one direction only
 */

public class ClusterGoodbyeInfo 
{
    private boolean requestTakeover = false;
    private Cluster c = null;

    private GPacket pkt = null;
    private BrokerAddress sender = null;

    private ClusterGoodbyeInfo(boolean requestTakeover, Cluster c) {
        this.requestTakeover = requestTakeover;
        this.c = c;
    }

    private ClusterGoodbyeInfo(GPacket pkt, Cluster c) throws Exception {
        assert (pkt.getType() == ProtocolGlobals.G_GOODBYE );

        this.pkt = pkt;
        this.c = c;

        sender = c.unmarshalBrokerAddress(pkt);
        if (sender.getHAEnabled()) {
            requestTakeover = ((Boolean)pkt.getProp("requestTakeover")).booleanValue();
        }
    }

    /**
     */
    public static ClusterGoodbyeInfo newInstance(boolean requestTakeover, Cluster c) {
        return new ClusterGoodbyeInfo(requestTakeover, c);
    }

    /**
     */
    public static ClusterGoodbyeInfo newInstance(Cluster c) {
        return new ClusterGoodbyeInfo(false, c);
    }

    /**
     *
     * @param pkt The GPacket to be unmarsheled
     */
    public static ClusterGoodbyeInfo newInstance(GPacket pkt, Cluster c) throws Exception {
        return new ClusterGoodbyeInfo(pkt, c);
    }

    public GPacket getGPacket() { 

        GPacket gp = GPacket.getInstance();
        gp.setType(ProtocolGlobals.G_GOODBYE);
        gp.setBit(gp.A_BIT, true);
        c.marshalBrokerAddress(c.getSelfAddress(), gp);
        if (c.getSelfAddress().getHAEnabled()) {
            gp.putProp("requestTakeover", new Boolean(requestTakeover));
        }

        return gp;
    }

    public boolean needReply() {
        assert ( pkt != null );
        return pkt.getBit(pkt.A_BIT);
    }

    public String toString() {
        if (pkt == null) {
            if (Globals.getHAEnabled()) {
                return "requestTakeover="+requestTakeover+" "+c.getSelfAddress().toString();
            }
            return  c.getSelfAddress().toString();
        }

        if (sender.getHAEnabled()) {
            return "requestTakeover="+requestTakeover+" "+sender.toString();
        }
        return sender.toString();
    }

    public static GPacket getReplyGPacket(int status) {
        GPacket gp = GPacket.getInstance();
        gp.setType(ProtocolGlobals.G_GOODBYE_REPLY);
        gp.putProp("S", new Integer(status));
        return gp;
    }
}
