/*
 * @(#)TakeoverAbortHandler.java	1.1 07/25/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import java.io.*;
import java.util.Hashtable;
import com.sun.messaging.jmq.util.*;
import com.sun.messaging.jmq.jmsserver.util.*;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.core.*;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.*;

public class TakeoverAbortHandler extends GPacketHandler {
    public static boolean DEBUG = false;

    public TakeoverAbortHandler(RaptorProtocol p) {
        super(p);
    }

    public void handle(BrokerAddress sender, GPacket pkt) {
        if (pkt.getType() == ProtocolGlobals.G_TAKEOVER_ABORT) {
            if (!Globals.getHAEnabled()) {
            logger.log(logger.ERROR, BrokerResources.E_INTERNAL_BROKER_ERROR, 
                       "Received Unexpected TAKEOVER_ABORT from "+sender);
            return;
            }

            handleTakeoverAbort(sender, pkt);
        }
    }

    public void handleTakeoverAbort(BrokerAddress sender, GPacket pkt) {
        ClusterTakeoverInfo cti = ClusterTakeoverInfo.newInstance(pkt);
         
        p.receivedTakeoverAbort(sender, cti);
    }

}
