/*
 * @(#)TakeoverLockException.java	1.4 04/20/05
 *
 * Copyright 2004 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.persist;

import com.sun.messaging.jmq.jmsserver.util.BrokerException;

/**
 * This class provides information about problems encountered when acquiring
 * takeover lock for a failed broker. The exception is thrown to signify a
 * takeover lock could not be obtained.
 *
 * @version	1.4
 */

public class TakeoverLockException extends BrokerException {

    private HABrokerInfo bkrInfo = null; // Broker info before takeover started

    /**
     * Constructs a TakeoverLockException
     */
    public TakeoverLockException(String msg) {
        super(msg);
    }

    public TakeoverLockException(String msg, Throwable t) {
        super(msg, t);
    }

    /**
     * Set the broker info before takeover started.
     * @param bkrInfo the broker info before takeover started
     */ 
    public void setBrokerInfo(HABrokerInfo bkrInfo) {
        this.bkrInfo = bkrInfo;
    }

    /**
     * Get the broker info before takeover started.
     * @return HABrokerInfo broker info before takeover started
     */
    public HABrokerInfo getBrokerInfo() {
	return bkrInfo;
    }
}
