/*
 * @(#)BaseDAO.java	1.3 07/27/05
 *
 * Copyright 2004 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.util.BrokerException;

import java.sql.SQLException;
import java.sql.Connection;
import java.util.HashMap;

/**
 * This class is an interface for the base DAO.
 *
 * @version	1.3
 */
public interface BaseDAO {

    /**
     * Get the prefix name of the table.
     * @return table name
     */
    public String getTableNamePrefix();

    /**
     * Get the name of the table.
     * @return table name
     */
    public String getTableName();

    /**
     * Create the table.
     * @param conn database connection
     * @throws BrokerException
     */
    public void createTable( Connection conn ) throws BrokerException;

    /**
     * Drop the table.
     * @param conn database connection
     * @throws BrokerException
     */
    public void dropTable( Connection conn ) throws BrokerException;

    /**
     * Delete all entries.
     * @param conn database connection
     * @throws BrokerException
     */
    public void deleteAll( Connection conn ) throws BrokerException;    

    /**
     * Get debug information about the store.
     * @param conn database connection
     * @return a HashMap of name value pair of information
     */
    public HashMap getDebugInfo( Connection conn );
}
