/*
 *@(#)ConflictException.java	1.1 03/18/03
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */
package com.sun.messaging.jmq.jmsserver.util;


import com.sun.messaging.jmq.io.Status;
/**
 * this is the sub-class for exceptions thrown by the broker
 */

public class ConflictException extends BrokerException
{
    /**
     * create an exception with a message but no root cause
     *
     * @param msg the detail message
     */
    public ConflictException(String msg) {
        super(msg, null, null, Status.CONFLICT);
    }
    /**
     * create an exception with a message but no root cause
     *
     * @param msg the detail message
     */
    public ConflictException(String msg, Throwable thr) {
        super(msg, null, thr, Status.CONFLICT);
    }
}
