/*
 * @(#)SelectorFilter.java	1.7 05/18/05
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.util;

import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.util.lists.Filter;
import com.sun.messaging.jmq.util.log.*;
import com.sun.messaging.jmq.io.Packet;
import java.lang.ref.*;
import com.sun.messaging.jmq.util.selector.*;
import java.util.Hashtable;
import java.util.Map;
import java.io.IOException;

public class SelectorFilter implements Filter
{
    public static boolean DEBUG = false;
    Selector selector = null;
    String selectorstr = null;

    public SelectorFilter(String selectorstr) 
         throws SelectorFormatException
    {
        this.selectorstr = selectorstr;
        selector =  Selector.compile(selectorstr);
     
    }
    public SelectorFilter(String selectorstr, Selector sel) 
    {
        this.selectorstr = selectorstr;
        this.selector = sel;
    }

    public synchronized boolean matches(Object o) 
    {
        if (selector == null) {
            return false;
        }
        if (o instanceof PacketReference) {
            PacketReference ref = (PacketReference) o;
            Map props = null;
            Map headers = null;
            try {
                // As an optimization, only extract these if the
                // selector needs them.
                if (selector.usesProperties()) {
                   props = ref.getProperties();
                }
                if (selector.usesFields()) {
                    headers = ref.getHeaders();
                }
            } catch (ClassNotFoundException ex) {
                // this is not a valid error
                assert false : ref;
                throw new RuntimeException("error with properties",
                     ex);
            }
            try {
                boolean match =  selector.match(props, headers);
                if (DEBUG && match)
                    Globals.getLogger().log(Logger.DEBUG,"Match " 
                            + o + "against " + selector + " got " + match);
                return match;
            } catch (SelectorFormatException ex) {
                Globals.getLogger().log(Logger.INFO,"Bad selector format, can not match against  " 
                     + selector, ex);
                return false;
            }
        }
        assert false : " weird ";
        return false;
    }

    public String toString() {
        return "SelectorFilter["+selector+"]"+hashCode();
    }


}
