/*
 * @(#)ClusterDeliveryPolicy.java	1.3 03/09/03
 *
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.util;


/**
 * Defines how messages are distributed on destinations.
 * <P>
 * <B>XXX</B> How should serialization be handled.
 *
 * @since 3.5
 */

public class ClusterDeliveryPolicy 
{
    public static final int UNKNOWN = -1;
    public static final int NA = 0;
    public static final int LOCAL_PREFERRED = 1;
    public static final int DISTRIBUTED = 2;

    public static int getStateFromString(String str) {
        if (str.equals("NA") || str.equals("N/A")) 
            return NA;
        if (str.equals("LOCAL_PREFERRED")) 
            return LOCAL_PREFERRED;
        if (str.equals("DISTRIBUTED") )
            return DISTRIBUTED;
        return UNKNOWN;
    }


    public static String getString(int state)
    {
        switch (state) {
            case NA:
                return "N/A";

            case LOCAL_PREFERRED:
                return "LOCAL_PREFERRED";

            case DISTRIBUTED:
                return "DISTRIBUTED";

        }
        return "UNKNOWN";

    }
}
