/*
 * @(#)DiagDictionaryEntry.java	1.1 02/02/06
 *
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package com.sun.messaging.jmq.util;


/**
 * Diagnostic dictionary entry. 
 *
 * DiagManager requires a data dictionary listing all fields to be
 * inspected and displayed for a particular data class. A dictionary
 * is a List of DiagDictionaryEntry's. The fields will be displayed in
 * the order that they appear in the dictionary.
 */
public class DiagDictionaryEntry {

    protected String name = null;
    protected int type = 0;

    /**
     * Create a diag dictionary entry. And entry consists of the 
     * name of the field, and it's type. type should be one of
     * DiagManager.CONSTANT, DiagManager.VARIABLE, DiagManager.COUNTER
     */
    public DiagDictionaryEntry(String name, int type) {
        this.name = name;
        this.type = type;
    }
}
