/*
 * @(#)PHashMapLoadException.java	1.1 06/08/04
 *
 * Copyright 2004 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.util;

/**
 * This class provides information about problems and/or data corruptions
 * encountered when loading the a VRecord from the backing file.
 * If the key and/or the value of the hash map entry is loaded successfully,
 * it can be retrieved by calling <code>getKey()</code> and/or
 * <code>getValue</code> respectively. The throwable caught while
 * deserializing the key can be retrieved by calling
 * <code>getKeyCause()</code>. Similarly, the throwable caught while
 * deserializing the value can be retrieved by calling
 * <code>getValueCause()</code>. Other exception caught while parsing
 * the record, if any, can be retrieved by <code>getCause</code>.
 * <code>getNextException()</code> returns
 * the next chained exception for other loading problems or
 * <code>null</code> if there's no more chained exception.
 *
 * @version     1.1
 */

public class PHashMapLoadException extends Exception {

    private Object key = null;
    private Object value = null;
    private PHashMapLoadException next = null;
    private Throwable keyCause = null;
    private Throwable valueCause = null;

    /**
     * Constructs a PHashMapLoadException
     */ 
    public PHashMapLoadException(String msg) {
        super(msg);
    }

    public void setKey(Object k) {
	this.key = k;
    }

    /**
     * Return the key of the HashMap entry loaded from file.
     */
    public Object getKey() {
	return key;
    }

    public void setValue(Object v) {
	this.value = v;
    }

    /**
     * Return the value of the HashMap entry loaded from file.
     */
    public Object getValue() {
	return value;
    }

    public void setKeyCause(Throwable t) {
	this.keyCause = t;
    }

    /**
     * Return the Throwable caught while deserializing the key.
     */
    public Throwable getKeyCause() {
	return this.keyCause;
    }

    public void setValueCause(Throwable t) {
	this.valueCause = t;
    }

    /**
     * Return the Throwable caught while deserializing the value.
     */
    public Throwable getValueCause() {
	return this.valueCause;
    }

    public void setNextException(PHashMapLoadException e) {
	this.next = e;
    }

    /**
     * Return the exception chained to this object.
     */
    public PHashMapLoadException getNextException() {
	return next;
    }

    public String toString() {
	return getMessage() + "\nkey="+key+";cause="+keyCause+";value="+value
			+";cause="+valueCause;
    }
}
