/*
 * @(#)ServiceState.java	1.4 04/08/05
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.util;



public class ServiceState
{
    public static final int UNKNOWN = -1;
    public static final int UNINITIALIZED = 0;
    public static final int INITIALIZED = 1;
    public static final int STARTED = 2;
    public static final int RUNNING = 3;
    public static final int PAUSED = 4;
    public static final int SHUTTINGDOWN = 5;
    public static final int STOPPED = 6;
    public static final int DESTROYED = 7;
    public static final int QUIESCED = 8;

    public static int getStateFromString(String str) {
        if (str.equals("UNINITIALIZED"))
            return UNINITIALIZED;
        if (str.equals("INITIALIZED")) 
            return INITIALIZED;
        if (str.equals("STARTED")) 
            return STARTED;
        if (str.equals("RUNNING") )
            return RUNNING;
        if (str.equals("PAUSED")) 
            return PAUSED;
        if (str.equals("SHUTTINGDOWN") )
            return SHUTTINGDOWN;
        if (str.equals("STOPPED") )
            return STOPPED;
        if (str.equals("DESTROYED") )
            return DESTROYED;
        if (str.equals("QUIESCED") )
            return QUIESCED;
        return UNKNOWN;
    }


    public static String getString(int state)
    {
        switch (state) {
            case UNINITIALIZED:
                return "UNINITIALIZED";

            case INITIALIZED:
                return "INITIALIZED";

            case STARTED:
                return "STARTED";

            case RUNNING:
                return "RUNNING";

            case PAUSED:
                return "PAUSED";

            case SHUTTINGDOWN:
                return "SHUTTINGDOWN";

            case STOPPED:
                return "STOPPED";

            case DESTROYED:
                return "DESTROYED";

            case QUIESCED:
                return "QUIESCED";

        }
        return "UNKNOWN";

    }
}
