/*
 * @(#)AdminInfo.java	1.2 04/07/20
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package com.sun.messaging.jmq.util.admin;

/**
 * Abstract base class for all the admin *Info classes. Basically
 * just provides the implementation for maintaining updateMask.
 *
 * @version	1.2
 *
 */
public class AdminInfo implements java.io.Serializable {

    static final long serialVersionUID = 6731577042303829252L;

    /**
     * A bit mask that subclasses use to indicate if a particular field
     * in the object has been updated or not.
     */
    private int updateMask = 0;

    /*
     * Constructor
     */
    public AdminInfo() {
	reset();
    }

    /*
     * Reset all fields to null values
     */
    public void reset() {
        resetMask();
    }

    /**
     * Clear updateMask so object thinks no fields have been modified
     */
    public void resetMask() {
        updateMask = 0;
    }

    /**
     * Check if a field has been modified
     */
    public boolean isModified(int fieldBit) {
        return ((updateMask & fieldBit) == fieldBit);
    }

    /**
     * Indicate that a field has been modified
     */
    public void setModified(int fieldBit) {
        updateMask = updateMask | fieldBit;
    }

    /**
     * Indicate that a field has NOT been modified
     */
    public void clearModified(int fieldBit) {
        updateMask = updateMask & ~fieldBit;
    }
}
