
/*
 * @(#)ConnectionAttributes.java	1.5 06/01/25
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jms.management.server;

/**
 * Class containing information on connection attributes.
 *
 * @version     1.5 06/01/25
 * @author      Isa Hashim
 */
public class ConnectionAttributes {
    /** 
     * Connection ID
     */
    public static final String		CONNECTION_ID = "ConnectionID";

    /** 
     * Client ID
     */
    public static final String		CLIENT_ID = "ClientID";

    /** 
     * Client Platform
     */
    public static final String		CLIENT_PLATFORM = "ClientPlatform";

    /** 
     * Connection Host
     */
    public static final String		HOST = "Host";

    /** 
     * Number of connections
     */
    public static final String		NUM_CONNECTIONS = "NumConnections";

    /** 
     * Number of connections created
     */
    public static final String		NUM_CONNECTIONS_OPENED = "NumConnectionsOpened";

    /** 
     * Number of connections rejected
     */
    public static final String		NUM_CONNECTIONS_REJECTED = "NumConnectionsRejected";

    /** 
     * Number of consumers
     */
    public static final String		NUM_CONSUMERS = "NumConsumers";

    /** 
     * Number of producers
     */
    public static final String		NUM_PRODUCERS = "NumProducers";

    /** 
     * Connection Port
     */
    public static final String		PORT = "Port";

    /** 
     * Service name
     */
    public static final String		SERVICE_NAME = "ServiceName";

    /** 
     * User name.
     */
    public static final String		USER = "User";

    /*
     * Class cannot be instantiated
     */
    private ConnectionAttributes() {
    }
    
}
