
/*
 * @(#)DestinationState.java	1.2 05/08/08
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jms.management.server;

/**
 * Class containing information on destination states.
 *
 * @version     1.2 05/08/08
 * @author      Isa Hashim
 */
public class DestinationState {
    /** 
     * Unknown destination state.
     */
    public static final int UNKNOWN = -1;

    /** 
     * Destination is active.
     */
    public static final int RUNNING = 0;

    /** 
     * Message delivery to consumers is paused.
     */
    public static final int CONSUMERS_PAUSED = 1;

    /** 
     * Message delivery from producers is paused.
     */
    public static final int PRODUCERS_PAUSED = 2;

    /** 
     * Message delivery from producers and to consumers
     * is paused.
     */
    public static final int PAUSED = 3;

    /*
     * Class cannot be instantiated
     */
    private DestinationState() {
    }
    
    /**
     * Returns a string representation of the specified destination state.
     *
     * @param state Destination state.
     * @return String representation of the specified destination state.
     */
    public static String toString(int state)  {

	switch (state)  {
	case RUNNING:
	    return("Running");

	case CONSUMERS_PAUSED:
	    return("Consumers Paused");

	case PRODUCERS_PAUSED:
	    return("Producers Paused");

	case PAUSED:
	    return("Paused");

	default:
	    return("unknown");
	}
    }
}
