#!/bin/sh
#
# @(#)icmd.sh	1.14 01/17/05
#
# Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
# SUN PROPRIETARY/CONFIDENTIAL
# Use is subject to license terms. 
#
# JMS Broker Administration startup script: Developer Edition
#
# This is a a version of the JMS Broker Administration startup 
# script that works when run in the "binary" directory (as opposed
# to "dist"). It uses the loose class files and not the jars.
#
# Parse Arguments 
#
#  -imqhome -> sets imq home
#  -imqvarhome -> sets imq home
#  -javahome -> sets javahome
#  -imqext -> sets imq external
#
# Note: This script fails if you specify any of the options above
# without any arguments e.g.
#	objmgr -imqhome
# (i.e. did not specify a imqhome value)
#

jvm_args="-Djava.compiler=NONE";

bin_home=`dirname $0`

imq_home=$bin_home/..
imq_external=${JMQ_EXTERNAL:-/net/jpgserv/export/jmq/external}

javacmd=java
# #####hpux-dev#####
PLATFORM=`uname`
if [ "$PLATFORM" = HP-UX ] ; then
javahome=${_JAVA_HOME:-/usr/jdk/entsys-j2se}
else
javahome=${_JAVA_HOME:-/net/jpgserv/usr/java1.5}
fi


#
# Save -javahome, -imqhome, -imqvarhome, -imqext
# arg values without recreating the $args string
# so that args with spaces work correctly.
#
javahomenext=false
imqhomenext=false
imqvarhomenext=false
imqextnext=false
vmargsnext=false

for opt in $*
do
  if [ $javahomenext = true ]
  then
    javahome=$opt
    javahomenext=false
  elif [ $imqhomenext = true ]
  then
    imq_home=$opt
    imqhomenext=false
  elif [ $imqvarhomenext = true ]
  then
    imq_varhome=$opt
    imqvarhomenext=false
  elif [ $imqextnext = true ]
  then
    imq_external=$opt
    imqextnext=false
  elif [ $vmargsnext = true ]
  then
    jvm_args="$jvm_args $opt"
    vmargsnext=false
  elif [ $opt = -javahome ]
  then
    javahomenext=true;
  elif [ $opt = -imqhome ]
  then
    imqhomenext=true;
  elif [ $opt = -imqvarhome ]
  then
    imqvarhomenext=true;
  elif [ $opt = -imqext ]
  then
    imqextnext=true;
  elif [ $opt = -vmargs ]
  then
    vmargsnext=true;
  fi
done

javacmd=$javahome/bin/$javacmd

jvm_args="$jvm_args -Dimq.home=$imq_home"

_ext_classes=$imq_external/jndifs/lib/fscontext.jar
_classes=$imq_home/../../share/opt/classes:$_ext_classes
_mainclass=com.sun.messaging.jmq.admin.apps.broker.BrokerCmd

# Needed to locate libimq
#####hpux-dev#####
if [ "$PLATFORM" = HP-UX ] ; then
SHLIB_PATH=$SHLIB_PATH:imq_home/lib; export SHLIB_PATH
else
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$imq_home/lib; export LD_LIBRARY_PATH
fi


$javacmd -cp $_classes $jvm_args $_mainclass "$@"
