/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.admin.apps.console.AController;
import com.sun.messaging.jmq.admin.apps.console.AExplorer;
import com.sun.messaging.jmq.admin.apps.console.AGraphics;
import com.sun.messaging.jmq.admin.apps.console.AInspector;
import com.sun.messaging.jmq.admin.apps.console.AMenuBar;
import com.sun.messaging.jmq.admin.apps.console.AStatusArea;
import com.sun.messaging.jmq.admin.apps.console.AToolBar;
import com.sun.messaging.jmq.admin.apps.console.ActionManager;
import com.sun.messaging.jmq.admin.apps.console.AdminApp;
import com.sun.messaging.jmq.admin.apps.console.BrokerListCObj;
import com.sun.messaging.jmq.admin.apps.console.ConsoleBrokerAdminManager;
import com.sun.messaging.jmq.admin.apps.console.ConsoleHelp;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObjStoreManager;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreListCObj;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdmin;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;

public class AdminConsole
extends JFrame
implements AdminApp {
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private static AdminResources ar = Globals.getAdminResources();
    private AMenuBar menuBar = null;
    private AToolBar toolBar = null;
    private AExplorer explorer = null;
    private AInspector inspector = null;
    private AStatusArea statusArea = null;
    private ActionManager actionMgr = null;
    private AController controller = null;
    private ObjStoreListCObj oslCObj = null;
    private BrokerListCObj blCObj = null;
    private ConsoleObj selObj = null;
    public static final String CONSOLE_VERSION1 = "-v";
    public static final String CONSOLE_VERSION2 = "-version";
    public static final String OPTION_HELP1 = "-h";
    public static final String OPTION_HELP2 = "-help";
    public static final String OPTION_DEBUG = "-debug";
    public static final String OPTION_VERBOSE = "-verbose";
    public static final String OPTION_VARHOME = "-varhome";
    public static final String OPTION_RECV_TIMEOUT = "-rtm";
    public static final String OPTION_NUM_RETRIES = "-rtr";
    public static final String OPTION_JAVAHOME = "-javahome";
    private static String[] close;

    public AdminConsole() {
        super("");
        this.setTitle(acr.getString("A1200", Globals.getVersion().getProductName()));
        this.initMgrs();
        this.initGui();
        this.controller.init();
    }

    public Frame getFrame() {
        return this;
    }

    public AMenuBar getMenubar() {
        return this.menuBar;
    }

    public AToolBar getToolbar() {
        return this.toolBar;
    }

    public AExplorer getExplorer() {
        return this.explorer;
    }

    public AInspector getInspector() {
        return this.inspector;
    }

    public AStatusArea getStatusArea() {
        return this.statusArea;
    }

    public ActionManager getActionManager() {
        return this.actionMgr;
    }

    public ObjStoreListCObj getObjStoreListCObj() {
        return this.oslCObj;
    }

    public BrokerListCObj getBrokerListCObj() {
        return this.blCObj;
    }

    public void setSelectedObj(ConsoleObj consoleObj) {
        this.selObj = consoleObj;
    }

    public ConsoleObj getSelectedObj() {
        return this.selObj;
    }

    public void setSelectedObjs(ConsoleObj[] consoleObjArray) {
    }

    public ConsoleObj[] getSelectedObjs() {
        return null;
    }

    private void initMgrs() {
        ConsoleObjStoreManager consoleObjStoreManager = ConsoleObjStoreManager.getConsoleObjStoreManager();
        this.oslCObj = new ObjStoreListCObj(consoleObjStoreManager);
        ConsoleBrokerAdminManager consoleBrokerAdminManager = new ConsoleBrokerAdminManager();
        this.blCObj = new BrokerListCObj(consoleBrokerAdminManager);
    }

    private void initGui() {
        this.getContentPane().setLayout(new BorderLayout());
        this.actionMgr = new ActionManager();
        this.menuBar = new AMenuBar(this.actionMgr);
        this.toolBar = new AToolBar(this.actionMgr);
        this.explorer = new AExplorer(this.actionMgr, this.oslCObj, this.blCObj);
        this.inspector = new AInspector();
        this.statusArea = new AStatusArea();
        this.controller = new AController(this);
        this.explorer.addAdminEventListener(this.controller);
        this.inspector.addAdminEventListener(this.controller);
        this.actionMgr.addAdminEventListener(this.controller);
        this.actionMgr.setActiveActions(0);
        this.setJMenuBar(this.menuBar);
        this.getContentPane().add((Component)this.toolBar, "North");
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setDividerLocation(200);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setPreferredSize(new Dimension(750, 450));
        jSplitPane.setTopComponent(this.explorer);
        jSplitPane.setBottomComponent(this.inspector);
        JSplitPane jSplitPane2 = new JSplitPane(0);
        jSplitPane2.setOneTouchExpandable(true);
        jSplitPane2.setTopComponent(jSplitPane);
        jSplitPane2.setBottomComponent(this.statusArea);
        this.getContentPane().add((Component)jSplitPane2, "Center");
        this.statusArea.appendText(acr.getString("A1200", Globals.getVersion().getProductName()) + "\n");
        this.setIconImage(AGraphics.adminImages[0].getImage());
    }

    private static void processCmdlineArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (stringArray[i].equals(CONSOLE_VERSION1) || stringArray[i].equals(CONSOLE_VERSION2)) {
                AdminConsole.printBanner();
                AdminConsole.printVersion();
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals(OPTION_HELP1) || stringArray[i].equals(OPTION_HELP2)) {
                AdminConsole.printHelp();
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals(OPTION_DEBUG)) {
                BrokerAdmin.setDebug(true);
                continue;
            }
            if (stringArray[i].equals(OPTION_RECV_TIMEOUT)) {
                if (i == stringArray.length - 1) {
                    Globals.stdErrPrintln(ar.getString("A1001"), acr.getKString("A1509", stringArray[i]), false);
                    System.exit(1);
                }
                string = stringArray[++i];
                long l = 0L;
                try {
                    l = Long.parseLong(string);
                }
                catch (Exception exception) {
                    Globals.stdErrPrintln(ar.getString("A1001"), acr.getKString("A3062", string), false);
                    System.exit(1);
                }
                BrokerAdmin.setDefaultTimeout(l * 1000L);
                continue;
            }
            if (stringArray[i].equals(OPTION_NUM_RETRIES)) {
                if (i == stringArray.length - 1) {
                    Globals.stdErrPrintln(ar.getString("A1001"), acr.getKString("A1509", stringArray[i]), false);
                    System.exit(1);
                }
                string = stringArray[++i];
                int n = 0;
                try {
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    Globals.stdErrPrintln(ar.getString("A1001"), acr.getKString("A3075", string), false);
                    System.exit(1);
                }
                BrokerAdmin.setDefaultNumRetries(n);
                continue;
            }
            if (stringArray[i].equals(OPTION_JAVAHOME)) {
                if (i == stringArray.length - 1) {
                    Globals.stdErrPrintln(ar.getString("A1001"), acr.getKString("A1509", stringArray[i]), false);
                    System.exit(1);
                }
                ++i;
                continue;
            }
            if (stringArray[i].equals(OPTION_VERBOSE)) continue;
            if (stringArray[i].equals(OPTION_VARHOME)) {
                ++i;
                continue;
            }
            Globals.stdErrPrintln(ar.getString("A1001"), acr.getKString("A1510", stringArray[i]), false);
            System.exit(1);
        }
    }

    private static void printVersion() {
        Version version = Globals.getVersion();
        Globals.stdOutPrintln(version.getVersion());
        Globals.stdOutPrintln(ar.getString("A1065") + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.home"));
        Globals.stdOutPrintln(ar.getString("A1066") + System.getProperty("java.class.path"));
    }

    private static void printHelp() {
        Globals.stdOutPrintln(acr.getString("A1508"));
    }

    private static void printBanner() {
        Version version = new Version();
        Globals.stdOutPrintln(version.getBanner(false));
    }

    public static void main(String[] stringArray) {
        AdminConsole.processCmdlineArgs(stringArray);
        AGraphics.loadImages();
        ConsoleHelp.loadHelp();
        AdminConsole adminConsole = new AdminConsole();
        adminConsole.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        adminConsole.pack();
        adminConsole.setVisible(true);
        if (!ConsoleHelp.helpLoaded()) {
            String string = acr.getString("A3084");
            String string2 = acr.getString("A1522") + ": " + acr.getString("A1218", "A3084");
            Exception exception = ConsoleHelp.getHelpLoadException();
            if (exception != null) {
                string = string + "\n" + exception.toString();
            }
            JOptionPane.showOptionDialog(adminConsole, string, string2, 0, 0, null, close, close[0]);
        }
    }

    static {
        String[] stringArray = new String[1];
        stringArray[0] = acr.getString("A1081");
        close = stringArray;
    }
}

