/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.io.PortMapperEntry;
import com.sun.messaging.jmq.io.PortMapperTable;
import com.sun.messaging.jmq.jmsclient.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Iterator;
import java.util.Map;

public class GenericPortMapperClient {
    protected PortMapperTable portMapperTable = null;
    protected String host;
    protected int port;
    private boolean debug = Debug.debug;

    public GenericPortMapperClient(String string, int n) {
        this.host = string;
        this.port = n;
        this.init();
    }

    public int getPortForProtocol(String string, String string2) {
        return this.getPort(string, string2, null);
    }

    public int getPortForService(String string, String string2, String string3) {
        return this.getPort(string, string3, string2);
    }

    public String getProperty(String string, String string2, String string3, String string4) {
        int n = 25374;
        String string5 = null;
        Map map = this.portMapperTable.getServices();
        PortMapperEntry portMapperEntry = null;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            portMapperEntry = (PortMapperEntry)iterator.next();
            if (string2 != null && !portMapperEntry.getProtocol().equals(string2) || string3 != null && !portMapperEntry.getType().equals(string3) || string4 != null && !portMapperEntry.getName().equals(string4) || (string5 = portMapperEntry.getProperty(string)) == null) continue;
            break;
        }
        return string5;
    }

    private int getPort(String string, String string2, String string3) {
        int n = 25374;
        Map map = this.portMapperTable.getServices();
        PortMapperEntry portMapperEntry = null;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            portMapperEntry = (PortMapperEntry)iterator.next();
            if (!portMapperEntry.getProtocol().equals(string) || !portMapperEntry.getType().equals(string2)) continue;
            if (string3 == null) {
                n = portMapperEntry.getPort();
                break;
            }
            if (!portMapperEntry.getName().equals(string3)) continue;
            n = portMapperEntry.getPort();
            break;
        }
        return n;
    }

    protected void init() {
        this.readBrokerPorts();
    }

    public String getBrokerVersion() {
        String string = this.portMapperTable.getBrokerVersion();
        return string;
    }

    protected void readBrokerPorts() {
        if (this.debug) {
            Debug.println("PortMapper connecting to host: " + this.host + "  port: " + this.port);
        }
        try {
            String string = String.valueOf(101) + "\n";
            Socket socket = new Socket(this.host, this.port);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            try {
                outputStream.write(string.getBytes());
                outputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.portMapperTable = new PortMapperTable();
            this.portMapperTable.read(inputStream);
            inputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception caught when reading portmapper.", exception);
        }
    }

    public static void main(String[] stringArray) {
        try {
            GenericPortMapperClient genericPortMapperClient = new GenericPortMapperClient("localhost", 7676);
            String string = genericPortMapperClient.getProperty("url", "rmi", "JMX", null);
            System.out.println("url = " + string);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
    }
}

