/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.config;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.ConfigStore;
import com.sun.messaging.jmq.jmsserver.config.UpdateProperties;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class BrokerConfig
extends UpdateProperties {
    private static final String IMQ = "imq";
    public static final String CONFIG_VERSION_PROP = "imq.config.version";
    public static final String INSTANCECONFIG_VERSION_PROP = "imq.instanceconfig.version";
    public static final String CONFIG_VERSION = "300";
    private static final String JMQ_FallbackProperties = "imq.service.activelist=jms,admin\nimq.jms.protocoltype=tcp\nimq.jms.servicetype=NORMAL\nimq.jms.tcp.port=0\nimq.jms.tcp.backlog=100\nimq.jms.tcp.blocking=true\nimq.jms.tcp.useChannels=false\nimq.jms.min_threads=10\nimq.jms.max_threads=1000\nimq.jms.threadpool_model=dedicated\nimq.ssljms.protocoltype=tls\nimq.ssljms.servicetype=NORMAL\nimq.ssljms.tls.port=0\nimq.ssljms.tls.backlog=100\nimq.ssljms.tcp.blocking=true\nimq.ssljms.tcp.useChannels=false\nimq.ssljms.min_threads=10\nimq.ssljms.max_threads=500\nimq.ssljms.threadpool_model=dedicated\nimq.keystore.file.dirpath=${imq.etchome}\nimq.keystore.file.name=keystore\nimq.keystore.password=\nimq.passfile.enabled=false\nimq.passfile.dirpath=${imq.etchome}\nimq.passfile.name=keypassfile\nimq.admin.protocoltype=tcp\nimq.admin.servicetype=ADMIN\nimq.admin.tcp.port=0\nimq.admin.tcp.backlog=5\nimq.admin.tcp.blocking=true\nimq.admin.tcp.useChannels=false\nimq.admin.min_threads=4\nimq.admin.max_threads=10\nimq.admin.threadpool_model=dedicated\nimq.httpjms.protocoltype=http\nimq.httpjms.servicetype=NORMAL\nimq.httpjms.http.servletHost=localhost\nimq.httpjms.http.servletPort=7675\nimq.httpjms.http.pullPeriod=-1\nimq.httpjms.http.connectionTimeout=300\nimq.httpjms.tcp.blocking=true\nimq.httpjms.tcp.useChannels=false\nimq.httpjms.threadpool_model=dedicated\nimq.httpjms.min_threads=10\nimq.httpjms.max_threads=500\nimq.httpsjms.protocoltype=https\nimq.httpsjms.servicetype=NORMAL\nimq.httpsjms.https.servletHost=localhost\nimq.httpsjms.https.servletPort=7674\nimq.httpsjms.https.pullPeriod=-1\nimq.httpjms.http.connectionTimeout=300\nimq.httpsjms.https.isHostTrusted=true\nimq.httpsjms.min_threads=10\nimq.httpsjms.max_threads=500\nimq.httpsjms.threadpool_model=dedicated\nimq.ssladmin.protocoltype=tls\nimq.ssladmin.servicetype=ADMIN\nimq.ssladmin.tls.port=0\nimq.ssladmin.tls.backlog=5\nimq.ssladmin.tcp.blocking=true\nimq.ssladmin.tcp.useChannels=false\nimq.ssladmin.min_threads=4\nimq.ssladmin.max_threads=10\nimq.ssladmin.threadpool_model=dedicated\nimq.protocol.tcp.inbufsz=2048\nimq.protocol.tcp.outbufsz=2048\nimq.protocol.tls.inbufsz=2048\nimq.protocol.tls.outbufsz=2048\nimq.protocol.http.inbufsz=2048\nimq.protocol.http.outbufsz=2048\nimq.protocol.https.inbufsz=2048\nimq.protocol.https.outbufsz=2048\nimq.protocol.tcp.nodelay=true\nimq.protocol.tls.nodelay=true\nimq.protocol.http.nodelay=true\nimq.protocol.https.nodelay=true\nimq.jmx.usePlatformMBeanServer=true\nimq.jmx.rmiregistry.start=false\nimq.jmx.rmiregistry.use=false\nimq.jmx.connector.list=jmxrmi,ssljmxrmi\nimq.jmx.connector.activelist=jmxrmi\nimq.jmx.connector.ssljmxrmi.useSSL=true\nimq.portmapper.port=7676\nimq.portmapper.backlog=50\nimq.portmapper.sotimeout=500\nimq.portmapper.solinger=5\nimq.message.expiration.interval=60\nimq.system.max_count=-1\nimq.system.max_size=-1\nimq.message.max_size=-1\nimq.persist.store=file\nimq.persist.file.message.vrfile.initial_size=1m\nimq.persist.file.message.vrfile.block_size=256\nimq.persist.file.message.max_record_size=1m\nimq.persist.file.message.filepool.cleanratio=60\nimq.persist.file.destination.message.filepool.limit=100\nimq.persist.file.message.cleanup=false\nimq.persist.file.destination.file.size=1m\nimq.authentication.basic.user_repository=file\nimq.authentication.digest.user_repository=file\nimq.authentication.type=digest\nimq.authentication.client.response.timeout=180\nimq.user_repository.file.filename=passwd\nimq.user_repository.file.dirpath=${imq.instanceshome}${/}${imq.instancename}${/}etc\nimq.user_repository.ldap.grpsearch=false\nimq.user_repository.ldap.ssl_enabled=false\nimq.user_repository.ldap.ssl.socketfactory=com.sun.messaging.jmq.jmsserver.auth.ldap.TrustSSLSocketFactory\nimq.user_repository.ldap.timeout=180\nimq.accesscontrol.enabled=true\nimq.accesscontrol.type=file\nimq.accesscontrol.file.dirpath=${imq.instanceshome}${/}${imq.instancename}${/}etc\nimq.accesscontrol.file.filename=accesscontrol.properties\nimq.audit.enabled=false\nimq.audit.bsm.class=com.sun.messaging.jmq.jmsserver.audit.BSMAuditSession\nimq.audit.log.class=com.sun.messaging.jmq.jmsserver.audit.LogAuditSession\nimq.log.level=INFO\nimq.log.handlers=file,console,jmx\nimq.log.file.rolloverbytes=0\nimq.log.file.rolloversecs=604800\nimq.log.file.dirpath=${imq.instanceshome}${/}${imq.instancename}${/}log\nimq.log.file.filename=log.txt\nimq.log.file.output=ALL\nimq.log.console.stream=ERR\nimq.log.console.output=ERROR|WARNING\nimq.log.jmx.output=ALL\nimq.metrics.enabled=true\nimq.metrics.interval=0\nimq.metrics.topic.enabled=true\nimq.metrics.topic.interval=60\nimq.metrics.topic.persist=false\nimq.metrics.topic.timetolive=300\nimq.autocreate.topic=true\nimq.autocreate.queue=true\nimq.autocreate.queue.maxNumActiveConsumers=1\nimq.autocreate.queue.maxNumBackupConsumers=0\nimq.queue.deliverypolicy=single\nimq.queue.rr.messageblock=5\nimq.restart.code=255\nimq.protocol.list=tcp\nimq.service.list=jms,admin,ssljms,httpjms,httpsjms,ssladmin\nimq.authentication.basic.properties=class,user_repository\nimq.authentication.basic.class=com.sun.messaging.jmq.jmsserver.auth.JMQBasicAuthenticationHandler\nimq.authentication.digest.properties=class,user_repository\nimq.authentication.digest.class=com.sun.messaging.jmq.jmsserver.auth.JMQDigestAuthenticationHandler\nimq.user_repository.file.properties=class,filename,userPrincipalClass,groupPrincipalClass\nimq.user_repository.file.class=com.sun.messaging.jmq.jmsserver.auth.file.JMQFileUserRepository\nimq.user_repository.file.userPrincipalClass=com.sun.messaging.jmq.auth.jaas.MQUser\nimq.user_repository.file.groupPrincipalClass=com.sun.messaging.jmq.auth.jaas.MQGroup\nimq.user_repository.ldap.properties=class,server,principal,password,base,uidattr,usrfilter,grpsearch,grpbase,gidattr,memattr,grpfilter,timeout,ssl.enabled,ssl.socketfactory,userPrincipalClass,groupPrincipalClass\nimq.user_repository.ldap.class=com.sun.messaging.jmq.jmsserver.auth.ldap.LdapUserRepository\nimq.user_repository.ldap.userPrincipalClass=com.sun.messaging.jmq.auth.jaas.MQUser\nimq.user_repository.ldap.groupPrincipalClass=com.sun.messaging.jmq.auth.jaas.MQGroup\nimq.user_repository.jaas.properties=class,name,userPrincipalClass,groupPrincipalClass\nimq.user_repository.jaas.class=com.sun.messaging.jmq.jmsserver.auth.jaas.UserRepositoryImpl\nimq.accesscontrol.file.properties=class,filename,url\nimq.accesscontrol.file.class=com.sun.messaging.jmq.jmsserver.auth.acl.JMQFileAccessControlModel\nimq.accesscontrol.jaas.properties=class,permissionFactory,permissionFactoryProvide,policyProvider\nimq.accesscontrol.jaas.class=com.sun.messaging.jmq.jmsserver.auth.acl.JAASAccessControlModel\nimq.log.file.class=com.sun.messaging.jmq.util.log.FileLogHandler\nimq.log.console.class=com.sun.messaging.jmq.util.log.StreamLogHandler\nimq.log.syslog.class=com.sun.messaging.jmq.util.log.SysLogHandler\nimq.log.destination.class=com.sun.messaging.jmq.jmsserver.util.DestinationLogHandler\nimq.log.destination.topic=mq.log.broker\nimq.log.jmx.class=com.sun.messaging.jmq.jmsserver.management.agent.JMXLogHandler\nimq.protocol.tcp.propertylist=port,backlog,useChannels,blocking,hostname\nimq.protocol.tcp.class=com.sun.messaging.jmq.jmsserver.net.tcp.TcpProtocol\nimq.protocol.tls.propertylist=port,backlog,keystore,useChannels,blocking,hostname\nimq.protocol.tls.class=com.sun.messaging.jmq.jmsserver.net.tls.TLSProtocol\nimq.protocol.http.propertylist=servletHost,servletPort,pullPeriod,connectionTimeout,useChannels,blocking\nimq.protocol.http.class=com.sun.messaging.jmq.jmsserver.net.http.HTTPProtocol\nimq.protocol.https.propertylist=servletHost,servletPort,pullPeriod,connectionTimeout,isHostTrusted\nimq.protocol.https.class=com.sun.messaging.jmq.jmsserver.net.https.HttpsProtocol\nimq.service_handler.dedicated.class=com.sun.messaging.jmq.jmsserver.service.imq.dedicated.DedicatedServiceFactory\nimq.service_handler.shared.class=com.sun.messaging.jmq.jmsserver.service.imq.group.GroupServiceFactory\nimq.service_handler.group.class=com.sun.messaging.jmq.jmsserver.service.imq.group.GroupServiceFactory\nimq.selectors.limit=16\nimq.cluster.port=0\nimq.cluster.masterbroker.enforce=true\nimq.cluster.locktimeout=60\nimq.memory.levels=green,yellow,orange,red\nimq.memory.hysteresis=1024\nimq.memory.overhead=10240\nimq.memory.gcdelta=1024\nimq.green.threshold=0\nimq.green.count=50000\nimq.green.gccount=0\nimq.green.gcitr=0\nimq.green.classname=com.sun.messaging.jmq.jmsserver.util.memory.levels.Green\nimq.yellow.threshold=60\nimq.yellow.classname=com.sun.messaging.jmq.jmsserver.util.memory.levels.Yellow\nimq.yellow.count=50\nimq.yellow.gccount=1\nimq.yellow.gcitr=1000\nimq.yellow.seconds=2\nimq.orange.threshold=80\nimq.orange.classname=com.sun.messaging.jmq.jmsserver.util.memory.levels.Orange\nimq.orange.count=1\nimq.orange.gccount=5\nimq.orange.gcitr=100\nimq.orange.seconds=1\nimq.red.threshold=90\nimq.red.classname=com.sun.messaging.jmq.jmsserver.util.memory.levels.Red\nimq.red.count=0\nimq.red.gccount=10\nimq.red.gcitr=5\nimq.red.seconds=10\nimq.cluster.manager.class=com.sun.messaging.jmq.jmsserver.cluster.ClusterManagerImpl\nimq.hacluster.manager.class=com.sun.messaging.jmq.jmsserver.cluster.ha.HAClusterManagerImpl\nimq.cluster.heartbeat.class=com.sun.messaging.jmq.jmsserver.multibroker.heartbeat.HeartbeatImpl\n";
    private static final String JMQ_prop_loc = Globals.JMQ_LIB_HOME + File.separator + Globals.JMQ_BROKER_PROP_LOC;
    private static final String default_loc = JMQ_prop_loc + "default.properties";
    private static final String install_loc = JMQ_prop_loc + "install.properties";
    private static final String ConfigStoreProperty = "imq.config.class";
    private static final String Default_Config_Store = "com.sun.messaging.jmq.jmsserver.config.FileConfigStore";
    Properties params = null;
    ConfigStore localconfig = null;
    Logger logger = null;

    public BrokerConfig(String string, Properties properties, boolean bl) throws BrokerException {
        if (properties == null) {
            properties = new Properties();
        }
        this.params = properties;
        this.logger = Globals.getLogger();
        this.logger.log(4, "B1001", Globals.JMQ_HOME);
        Object var4_4 = null;
        try {
            this.load(new ByteArrayInputStream(JMQ_FallbackProperties.getBytes()));
        }
        catch (IOException iOException) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "unable to load fallback properties"), iOException);
        }
        try {
            this.loadDefaultProperties(default_loc);
        }
        catch (IOException iOException) {
            this.logger.log(16, "B2001", "default", default_loc, iOException);
            this.logger.log(32, "B3001");
            return;
        }
        try {
            this.loadDefaultProperties(install_loc);
        }
        catch (Exception exception) {
            this.logger.log(16, "B2001", "install", install_loc, exception);
        }
        String string2 = super.getProperty(ConfigStoreProperty, Default_Config_Store);
        try {
            this.localconfig = (ConfigStore)Class.forName(string2).newInstance();
        }
        catch (Exception exception) {
            this.logger.logStack(32, "B3002", string2, (Throwable)exception);
        }
        if (this.localconfig != null) {
            Properties properties2;
            Properties properties3;
            if (bl) {
                this.localconfig.clearProps(string);
            }
            if ((properties3 = this.localconfig.loadClusterProps(this, properties, properties2 = this.localconfig.loadStoredProps(this, string))) != null) {
                this.putAll((Map)properties3);
            }
            this.setStoredProperties(properties2);
        }
        this.putAll((Map)System.getProperties());
        this.putAll((Map)properties);
        this.checkProperties();
    }

    protected void checkProperties() {
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            char c;
            String string;
            String string2 = (String)enumeration.nextElement();
            if (string2 == null || (string = this.getProperty(string2)) == null || string.length() <= 0 || !Character.isSpaceChar(c = string.charAt(string.length() - 1))) continue;
            Exception exception = null;
            string = string.trim();
            try {
                this.updateProperty(string2, string);
            }
            catch (Exception exception2) {
                exception = exception2;
                this.put(string2, string);
            }
            if (exception == null) {
                this.logger.log(16, "B2072", (Object)string2, string);
                continue;
            }
            this.logger.log(16, "B2072", string2, string, exception);
        }
    }

    protected void saveUpdatedProperties(Properties properties) throws IOException {
        if (this.localconfig == null) {
            this.logger.log(16, "B2002");
            return;
        }
        this.localconfig.StoreProperties(this.storedprops);
    }

    public void reloadProps(String string, String[] stringArray) throws BrokerException {
        this.reloadProps(string, stringArray, true);
    }

    public void reloadProps(String string, String[] stringArray, boolean bl) throws BrokerException {
        Properties properties;
        if (this.localconfig == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (bl) {
                this.remove(stringArray[i]);
                continue;
            }
            if (this.params.get(stringArray[i]) != null) continue;
            this.remove(stringArray[i]);
            arrayList.add(stringArray[i]);
        }
        if (!bl) {
            stringArray = arrayList.toArray(new String[arrayList.size()]);
        }
        if ((properties = this.localconfig.reloadProps(string, stringArray)) == null) {
            properties = new Properties();
        }
        Properties properties2 = this.localconfig.loadClusterProps(this, new Properties(), properties);
        Properties properties3 = new Properties();
        if (properties2 != null) {
            String string2 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = properties2.getProperty(stringArray[i]);
                if (string2 == null) continue;
                properties3.setProperty(stringArray[i], string2);
            }
        }
        properties3.putAll((Map<?, ?>)properties);
        try {
            this.updateProperties(properties3, false);
        }
        catch (Exception exception) {
            this.putAll((Map)properties3);
        }
    }
}

