/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.config;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.config.WatchedProperty;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class UpdateProperties
extends Properties {
    private Logger logger = Globals.getLogger();
    protected Properties storedprops = new Properties();
    protected String storedloc = null;
    private static final String PROP_HEADER_STR = "#This file is automatically generated, DO NOT EDIT";

    public UpdateProperties() {
        super(System.getProperties());
    }

    public UpdateProperties(String string, String string2) throws IOException {
        this();
        this.loadDefaultProperties(string);
        this.loadStoredPropertiesFile(string2);
    }

    public void loadStoredPropertiesFile(String string) throws IOException, IllegalArgumentException {
        this.setStoredPropertiesLocation(string);
        Properties properties = this.readPropertiesFile(string);
        this.setStoredProperties(properties);
    }

    protected void setStoredProperties(Properties properties) throws IllegalArgumentException {
        this.putAll((Map)properties);
        this.storedprops.putAll((Map<?, ?>)properties);
    }

    protected void setStoredPropertiesLocation(String string) throws IllegalArgumentException {
        if (this.storedloc != null) {
            throw new IllegalArgumentException(Globals.getBrokerResources().getString("B4117", "Can not access more than one stored property location"));
        }
        if (string == null) {
            throw new IllegalArgumentException(Globals.getBrokerResources().getString("B4117", "Can not load property from null location"));
        }
        this.storedloc = string;
    }

    public Object put(Object object, Object object2) {
        Object object3 = super.get(object);
        Object object4 = null;
        if (object3 instanceof WatchedProperty) {
            WatchedProperty watchedProperty = (WatchedProperty)object3;
            object4 = watchedProperty.getValue();
            watchedProperty.setValue((String)object2);
        } else {
            object4 = super.put(object, object2);
        }
        return object4;
    }

    public Object remove(Object object) {
        Object object2 = super.get(object);
        Object object3 = null;
        if (object2 instanceof WatchedProperty) {
            WatchedProperty watchedProperty = (WatchedProperty)object2;
            object3 = watchedProperty.getValue();
            watchedProperty.setValue(null);
        } else {
            object3 = super.remove(object);
        }
        return object3;
    }

    public void loadDefaultProperties(String string) throws IOException {
        this.readPropertiesFile(string, this);
    }

    protected Properties readPropertiesFile(String string) throws IOException {
        Properties properties = new Properties();
        this.readPropertiesFile(string, properties);
        return properties;
    }

    protected void readPropertiesFile(String string, Properties properties) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        properties.load(bufferedInputStream);
        bufferedInputStream.close();
        fileInputStream.close();
    }

    public synchronized void saveUpdatedProperties() throws IOException {
        this.saveUpdatedProperties(this.storedprops);
    }

    protected void saveUpdatedProperties(Properties properties) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.storedloc);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        properties.store(bufferedOutputStream, PROP_HEADER_STR);
        bufferedOutputStream.close();
        fileOutputStream.close();
    }

    public Object setProperty(String string, String string2) {
        throw new RuntimeException(Globals.getBrokerResources().getString("B4117", "setProperty is not implemented, use updateProperty"));
    }

    public Object putOne(String string, String string2) {
        return super.setProperty(string, string2);
    }

    public void putAll(Map map) {
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            Object object = super.get(string);
            if (object == null || !(object instanceof WatchedProperty)) {
                super.setProperty(string, string2);
                continue;
            }
            ((WatchedProperty)object).setValue(string2);
        }
    }

    public void updateProperty(String string, String string2) throws PropertyUpdateException, IOException {
        this.updateProperty(string, string2, true);
    }

    public void updateBooleanProperty(String string, boolean bl, boolean bl2) throws PropertyUpdateException, IOException {
        this.updateProperty(string, new Boolean(bl).toString(), bl2);
    }

    public void updateIntProperty(String string, int n, boolean bl) throws PropertyUpdateException, IOException {
        this.updateProperty(string, Integer.toString(n), bl);
    }

    public void updateSizeProperty(String string, SizeString sizeString, boolean bl) throws PropertyUpdateException, IOException {
        this.updateProperty(string, sizeString.getString(), bl);
    }

    public void updateLongProperty(String string, long l, boolean bl) throws PropertyUpdateException, IOException {
        this.updateProperty(string, Long.toString(l), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperty(String string, String string2, boolean bl) throws PropertyUpdateException, IOException {
        Object object = super.get(string);
        if (object != null && object instanceof WatchedProperty) {
            Vector vector = ((WatchedProperty)object).getListeners();
            if (vector != null) {
                Vector vector2 = vector;
                synchronized (vector2) {
                    int n;
                    for (n = 0; n < vector.size(); ++n) {
                        ((ConfigListener)vector.elementAt(n)).validate(string, string2);
                    }
                    for (n = 0; n < vector.size(); ++n) {
                        ((ConfigListener)vector.elementAt(n)).update(string, string2);
                    }
                }
            }
            ((WatchedProperty)object).setValue(string2);
        } else {
            super.setProperty(string, string2);
        }
        this.storedprops.setProperty(string, string2);
        if (bl) {
            this.saveUpdatedProperties();
        }
    }

    public void updateRemoveProperty(String string, boolean bl) throws IOException {
        super.remove(string);
        this.storedprops.remove(string);
        if (bl) {
            this.saveUpdatedProperties();
        }
    }

    public void updateProperties(Hashtable hashtable) throws PropertyUpdateException, IOException {
        this.updateProperties(hashtable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperties(Hashtable hashtable, boolean bl) throws PropertyUpdateException, IOException {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object4 = (String)hashtable.get(string);
            object3 = super.get(string);
            if (object3 == null || !(object3 instanceof WatchedProperty) || (object2 = ((WatchedProperty)object3).getListeners()) == null) continue;
            object = object2;
            synchronized (object) {
                for (n = 0; n < ((Vector)object2).size(); ++n) {
                    ((ConfigListener)((Vector)object2).get(n)).validate(string, (String)object4);
                }
            }
        }
        this.putAll((Map)hashtable);
        this.storedprops.putAll((Map<?, ?>)hashtable);
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object4 = super.get(string);
            if (object4 == null || !(object4 instanceof WatchedProperty)) continue;
            object3 = ((WatchedProperty)object4).getListeners();
            object2 = (String)hashtable.get(string);
            if (object3 == null) continue;
            object = object3;
            synchronized (object) {
                for (n = 0; n < ((Vector)object3).size(); ++n) {
                    ((ConfigListener)((Vector)object3).elementAt(n)).update(string, (String)object2);
                }
            }
        }
        if (bl) {
            this.saveUpdatedProperties();
        }
    }

    public void clearAllStoredProps() throws PropertyUpdateException, IOException {
        this.storedprops = new Properties();
        this.saveUpdatedProperties();
    }

    public String getProperty(String string) {
        Object object = super.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof WatchedProperty) {
            return ((WatchedProperty)object).getValue();
        }
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public void list(PrintStream printStream) {
        printStream.println("-- listing properties --");
        Enumeration<Object> enumeration = super.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = super.get(string);
            String string2 = object.toString();
            if (string2.length() > 60) {
                string2 = string2.substring(0, 57) + "...";
            }
            printStream.println(string + "=" + string2);
        }
    }

    public void list(PrintWriter printWriter) {
        printWriter.println("-- listing properties --");
        Enumeration<Object> enumeration = super.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = super.get(string);
            String string2 = object.toString();
            if (string2.length() > 60) {
                string2 = string2.substring(0, 57) + "...";
            }
            printWriter.println(string + "=" + string2);
        }
    }

    public List getPropertyNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<Object> enumeration = super.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public void addListener(String string, ConfigListener configListener) {
        Object object = super.get(string);
        WatchedProperty watchedProperty = null;
        if (object == null || object instanceof String) {
            watchedProperty = new WatchedProperty((String)object);
            super.put(string, watchedProperty);
        } else {
            watchedProperty = (WatchedProperty)object;
        }
        watchedProperty.addListener(configListener);
    }

    public void removeListener(String string, ConfigListener configListener) {
        Object object = super.get(string);
        if (object instanceof WatchedProperty) {
            WatchedProperty watchedProperty = (WatchedProperty)object;
            watchedProperty.removeListener(configListener);
        }
    }

    public void removeAllListeners(ConfigListener configListener) {
        Enumeration<Object> enumeration = super.elements();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (!(object instanceof WatchedProperty)) continue;
            WatchedProperty watchedProperty = (WatchedProperty)object;
            watchedProperty.removeListener(configListener);
        }
    }

    public void removeAllListeners(String string) {
        Object object = super.get(string);
        if (object instanceof WatchedProperty) {
            WatchedProperty watchedProperty = (WatchedProperty)object;
            watchedProperty.clearListeners();
        }
    }

    public List getList(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",", false);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreElements()) {
            int n;
            String string3 = stringTokenizer.nextToken();
            string3 = string3.trim();
            for (n = 0; n < string3.length() && Character.isSpaceChar(string3.charAt(n)); ++n) {
            }
            if (n > 0) {
                string3 = string3.substring(n + 1);
            }
            if (string3.length() <= 0) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public String[] getArray(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",", false);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            String string3 = stringTokenizer.nextToken();
            string3 = string3.trim();
            for (n2 = 0; n2 < string3.length() && Character.isSpaceChar(string3.charAt(n2)); ++n2) {
            }
            if (n2 > 0) {
                string3 = string3.substring(n2 + 1);
            }
            stringArray[i] = string3;
        }
        return stringArray;
    }

    public long getLongProperty(String string) {
        return this.getLongProperty(string, 0L);
    }

    public long getLongProperty(String string, long l) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (Exception exception) {
            this.logger.log(8, "B3138", (Object)string, (Throwable)exception);
            return l;
        }
    }

    public int getIntProperty(String string) {
        return this.getIntProperty(string, 0);
    }

    public int getIntProperty(String string, int n) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            this.logger.log(8, "B3138", (Object)string, (Throwable)exception);
            return n;
        }
    }

    public SizeString getSizeProperty(String string) {
        return this.getSizeProperty(string, 0L);
    }

    public SizeString getSizeProperty(String string, long l) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return new SizeString(l);
        }
        try {
            return new SizeString(string2);
        }
        catch (Exception exception) {
            this.logger.log(8, "B3138", (Object)string, (Throwable)exception);
            return new SizeString(l);
        }
    }

    public boolean getBooleanProperty(String string) {
        return this.getBooleanProperty(string, false);
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        try {
            return Boolean.valueOf(string2);
        }
        catch (Exception exception) {
            this.logger.log(8, "B3138", (Object)string, (Throwable)exception);
            return bl;
        }
    }

    public float getFloatProperty(String string) {
        return this.getFloatProperty(string, 0.0f);
    }

    public float getFloatProperty(String string, float f) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return f;
        }
        try {
            return Float.valueOf(string2).floatValue();
        }
        catch (Exception exception) {
            this.logger.log(8, "B3138", (Object)string, (Throwable)exception);
            return f;
        }
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        Enumeration<Object> enumeration = super.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.getProperty(string);
            if (string2 == null) {
                string2 = "";
            }
            properties.setProperty(string, string2);
        }
        return properties;
    }
}

