/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.AutoRollbackType;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionInformation;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class TransactionList {
    List inuse_translist = null;
    Hashtable translist = null;
    Logger logger = Globals.getLogger();
    Hashtable xidTable = null;
    Store store = null;
    HashMap brokerToTxn = new HashMap();
    HashMap txnToBroker = new HashMap();

    public TransactionList(Store store) {
        this.store = store;
        this.translist = new Hashtable();
        this.xidTable = new Hashtable();
        this.inuse_translist = new ArrayList();
        try {
            this.loadTransactions();
        }
        catch (Exception exception) {
            this.logger.logStack(8, "B2096", exception);
        }
    }

    public synchronized void addWatchedRemoteTxn(BrokerAddress brokerAddress, TransactionUID transactionUID) {
        ArrayList<TransactionUID> arrayList = (ArrayList<TransactionUID>)this.brokerToTxn.get(brokerAddress);
        if (arrayList == null) {
            arrayList = new ArrayList<TransactionUID>();
            this.brokerToTxn.put(brokerAddress, arrayList);
        }
        arrayList.add(transactionUID);
        this.txnToBroker.put(transactionUID, brokerAddress);
    }

    public synchronized void removeWatchedRemoteTxn(TransactionUID transactionUID) {
        BrokerAddress brokerAddress = (BrokerAddress)this.txnToBroker.remove(transactionUID);
        if (brokerAddress == null) {
            this.logger.log(4, "Unknown broker for " + transactionUID);
            return;
        }
        List list = (List)this.brokerToTxn.get(brokerAddress);
        list.remove(transactionUID);
        if (list.size() == 0) {
            this.brokerToTxn.remove(brokerAddress);
        }
    }

    public synchronized List getRemoteBrokers(BrokerAddress brokerAddress) {
        return (List)this.brokerToTxn.get(brokerAddress);
    }

    public synchronized void clearRemoteBrokers(BrokerAddress brokerAddress) {
        List list = (List)this.brokerToTxn.remove(brokerAddress);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TransactionUID transactionUID = (TransactionUID)iterator.next();
            this.txnToBroker.remove(transactionUID);
        }
    }

    public synchronized Hashtable getDebugState(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation == null) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put(transactionUID.toString(), "UNKNOWN TID");
            return hashtable;
        }
        return transactionInformation.getDebugState();
    }

    public TransactionState addRemoteTxn(BrokerAddress brokerAddress, TransactionUID transactionUID) throws BrokerException {
        this.logger.log(4, "addRemoteTxn " + transactionUID);
        TransactionState transactionState = new TransactionState(AutoRollbackType.NOT_PREPARED, 0L, false);
        transactionState.setRemoteBroker(brokerAddress);
        transactionState.setState(1);
        this.addTransactionID(transactionUID, transactionState, !Globals.getHAEnabled());
        this.addWatchedRemoteTxn(brokerAddress, transactionUID);
        return transactionState;
    }

    public void rollbackRemoteTxn(TransactionUID transactionUID) throws BrokerException {
        this.logger.log(4, "rollbackRemoteTxn " + transactionUID);
        TransactionState transactionState = this.retrieveState(transactionUID);
        transactionState.setState(7);
        HashMap hashMap = this.retrieveConsumedMessages(transactionUID);
        Iterator iterator = new HashSet(hashMap.keySet()).iterator();
        while (iterator.hasNext()) {
            SysMessageID sysMessageID = (SysMessageID)iterator.next();
            ArrayList arrayList = (ArrayList)hashMap.get(sysMessageID);
            PacketReference packetReference = Destination.get(sysMessageID);
            if (sysMessageID == null) continue;
            HashSet<ArrayList> hashSet = new HashSet<ArrayList>();
            hashSet.add(arrayList);
            packetReference.getDestination().forwardMessage(hashSet, packetReference);
        }
        this.removeTransactionAck(transactionUID);
        this.removeTransactionID(transactionUID);
        this.removeWatchedRemoteTxn(transactionUID);
    }

    public void commitRemoteTxn(TransactionUID transactionUID) throws BrokerException {
        this.logger.log(4, "commitRemoteTxn " + transactionUID);
        TransactionState transactionState = this.retrieveState(transactionUID);
        if (transactionState == null) {
            this.logger.log(4, "XXX ACK - state is not there for " + transactionUID);
            throw new BrokerException("unknown txn " + transactionUID, 410);
        }
        if (transactionState.getState() != 5) {
            transactionState.setState(6);
        }
        HashMap hashMap = this.retrieveConsumedMessages(transactionUID);
        Iterator iterator = new HashSet(hashMap.keySet()).iterator();
        while (iterator.hasNext()) {
            SysMessageID sysMessageID = (SysMessageID)iterator.next();
            ArrayList arrayList = (ArrayList)hashMap.get(sysMessageID);
            PacketReference packetReference = Destination.get(sysMessageID);
            if (sysMessageID == null) continue;
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                ConsumerUID consumerUID = (ConsumerUID)iterator2.next();
                Consumer consumer = Consumer.getConsumer(consumerUID);
                try {
                    if (!packetReference.acknowledged(consumerUID, consumer.getStoredConsumerUID(), true, true, null)) continue;
                    Destination destination = packetReference.getDestination();
                    destination.removeMessage(sysMessageID, RemoveReason.ACKNOWLEDGED);
                }
                catch (IOException iOException) {
                    this.logger.logStack(4, "IO exception", iOException);
                }
            }
        }
        this.removeTransactionAck(transactionUID);
        this.removeTransactionID(transactionUID);
        this.removeWatchedRemoteTxn(transactionUID);
    }

    public Map loadTakeoverTxns(List list) throws BrokerException, IOException {
        this.logger.log(4, "Processing Transactions " + list.size() + " after takeover");
        Iterator iterator = list.iterator();
        HashMap<TransactionUID, List<TransactionAcknowledgement>> hashMap = new HashMap<TransactionUID, List<TransactionAcknowledgement>>();
        while (iterator.hasNext()) {
            TransactionUID transactionUID = (TransactionUID)iterator.next();
            TransactionState transactionState = null;
            try {
                transactionState = this.store.getTransactionState(transactionUID);
            }
            catch (BrokerException brokerException) {
                iterator.remove();
                continue;
            }
            try {
                this.logger.log(4, "Processing transaction " + transactionUID + " state=" + transactionState);
                if (transactionUID == null) continue;
                if (transactionState.getState() == 6) {
                    this.store.removeTransactionAck(transactionUID, false);
                    this.store.removeTransaction(transactionUID, false);
                    continue;
                }
                if (transactionState.getState() != 5) {
                    this.store.removeTransactionAck(transactionUID, false);
                }
                TransactionAcknowledgement[] transactionAcknowledgementArray = this.store.getTransactionAcks(transactionUID);
                this.logger.log(4, "Processing transaction acks " + transactionUID + " number=" + transactionAcknowledgementArray.length);
                List<TransactionAcknowledgement> list2 = Arrays.asList(transactionAcknowledgementArray);
                hashMap.put(transactionUID, list2);
                this.addTransactionID(transactionUID, transactionState, false);
                this.setTransactionIDStored(transactionUID);
            }
            catch (Exception exception) {
                this.logger.logStack(32, "B3100", "error taking over " + transactionUID, (Throwable)exception);
                hashMap.remove(transactionUID);
            }
        }
        return hashMap;
    }

    public Hashtable getDebugState() {
        Object object;
        Object object2;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("TransactionCount", new Integer(this.translist.size()));
        Iterator iterator = this.translist.entrySet().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            String string = object2.getKey().toString();
            object = (TransactionInformation)object2.getValue();
            if (object == null) continue;
            hashtable.put(string, ((TransactionInformation)object).getDebugState());
        }
        object2 = new Vector();
        for (int i = 0; i < this.inuse_translist.size(); ++i) {
            ((Vector)object2).add(this.inuse_translist.get(i).toString());
        }
        if (((Vector)object2).size() > 0) {
            hashtable.put("inUse", object2);
        } else {
            hashtable.put("inUse", "none");
        }
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        iterator = this.xidTable.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            hashtable2.put(object.getKey().toString(), object.getValue().toString());
        }
        if (hashtable2.size() > 0) {
            hashtable.put("XIDs", object2);
        } else {
            hashtable.put("XIDs", "none");
        }
        return hashtable;
    }

    public void addTransactionID(TransactionUID transactionUID, TransactionState transactionState) throws BrokerException {
        this.addTransactionID(transactionUID, transactionState, true);
    }

    public synchronized TransactionUID getTransaction(SysMessageID sysMessageID) {
        Iterator iterator = this.translist.values().iterator();
        while (iterator.hasNext()) {
            TransactionInformation transactionInformation = (TransactionInformation)iterator.next();
            TransactionState transactionState = transactionInformation.getState();
            SysMessageID sysMessageID2 = transactionState.getCreator();
            if (sysMessageID2 == null || !sysMessageID2.equals(sysMessageID)) continue;
            return transactionInformation.getTID();
        }
        return null;
    }

    public synchronized void setTransactionIDStored(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation == null) {
            return;
        }
        transactionInformation.setPersisted(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransactionID(TransactionUID transactionUID, TransactionState transactionState, boolean bl) throws BrokerException {
        TransactionList transactionList = this;
        synchronized (transactionList) {
            if (this.inuse_translist.contains(transactionUID)) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4061", transactionUID.toString()), "B4061", null, 409);
            }
            JMQXid jMQXid = transactionState.getXid();
            if (jMQXid != null) {
                if (this.xidTable.get(jMQXid) != null) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4061", transactionUID.toString() + "[Xid=" + jMQXid.toString() + "]"), "B4061", null, 409);
                }
                this.xidTable.put(jMQXid, transactionUID);
            }
        }
        try {
            if (bl) {
                this.store.storeTransaction(transactionUID, transactionState, false);
            }
        }
        catch (Exception exception) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4062", transactionUID.toString()), "B4062", exception, 500);
        }
        transactionList = this;
        synchronized (transactionList) {
            this.inuse_translist.add(transactionUID);
            this.translist.put(transactionUID, new TransactionInformation(transactionUID, transactionState, bl));
        }
    }

    public void removeTransactionID(TransactionUID transactionUID) throws BrokerException {
        TransactionInformation transactionInformation;
        TransactionState transactionState = this.retrieveState(transactionUID);
        if (transactionState != null && transactionState.getXid() != null) {
            this.xidTable.remove(transactionState.getXid());
        }
        if ((transactionInformation = (TransactionInformation)this.translist.remove(transactionUID)) == null) {
            return;
        }
        try {
            if (transactionInformation.getPersisted()) {
                this.store.removeTransaction(transactionUID, false);
            }
        }
        catch (IOException iOException) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "unable to remove the transaction id " + transactionUID), iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransactionAck(TransactionUID transactionUID) throws BrokerException {
        Object object;
        try {
            object = (TransactionInformation)this.translist.get(transactionUID);
            if (object != null && ((TransactionInformation)object).getPersisted()) {
                this.store.removeTransactionAck(transactionUID, false);
            }
        }
        catch (Exception exception) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", ": unable to remove the transaction ack for " + transactionUID), exception);
        }
        object = this;
        synchronized (object) {
            this.inuse_translist.remove(transactionUID);
        }
    }

    public void addMessage(TransactionUID transactionUID, SysMessageID sysMessageID) throws BrokerException {
        this.addMessage(transactionUID, sysMessageID, false);
    }

    public synchronized void addMessage(TransactionUID transactionUID, SysMessageID sysMessageID, boolean bl) throws BrokerException {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "received message with Unknown Transaction ID " + transactionUID + ": ignoring message"), 410);
        }
        if (transactionInformation.getState().getState() == 8) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Transaction " + transactionUID + ": is has timed out "), 408);
        }
        if (!bl && transactionInformation.getState().getState() != 1) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Transaction " + transactionUID + ": is not started, ignoring"), 412);
        }
        transactionInformation.addPublishedMessage(sysMessageID);
    }

    public Hashtable getTransactionMap(TransactionUID transactionUID, boolean bl) throws BrokerException {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "received acknowledgement with Unknown Transaction ID " + transactionUID), 410);
        }
        TransactionState transactionState = transactionInformation.getState();
        if (transactionState == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "received acknowledgement with Unknown Transaction state " + transactionUID), 500);
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("JMQAutoRollback", new Integer(transactionState.getType().intValue()));
        if (transactionState.getXid() != null) {
            hashtable.put("JMQXid", transactionState.getXid().toString());
        }
        hashtable.put("JMQSessionLess", new Boolean(transactionState.isSessionLess()));
        hashtable.put("JMQCreateTime", new Long(transactionState.getCreationTime()));
        hashtable.put("JMQLifetime", new Long(transactionState.getLifetime()));
        if (bl) {
            hashtable.put("State", new Integer(transactionState.getState() + 1));
        } else {
            hashtable.put("State", new Integer(transactionState.getState()));
        }
        return hashtable;
    }

    public synchronized boolean checkAcknowledgement(TransactionUID transactionUID, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "received acknowledgement with Unknown Transaction ID " + transactionUID + ": ignoring message"), 410);
        }
        if (transactionInformation.getState().getState() == 8) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Transaction " + consumerUID + ": is has timed out "), 408);
        }
        return transactionInformation.checkConsumedMessage(sysMessageID, consumerUID);
    }

    public synchronized void addAcknowledgement(TransactionUID transactionUID, SysMessageID sysMessageID, ConsumerUID consumerUID, ConsumerUID consumerUID2) throws BrokerException {
        PacketReference packetReference = Destination.get(sysMessageID);
        boolean bl = consumerUID2.shouldStore() && packetReference != null && packetReference.isPersistent() && packetReference.isLocal();
        this.addAcknowledgement(transactionUID, sysMessageID, consumerUID, consumerUID2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAcknowledgement(TransactionUID transactionUID, SysMessageID sysMessageID, ConsumerUID consumerUID, ConsumerUID consumerUID2, boolean bl) throws BrokerException {
        TransactionList transactionList = this;
        synchronized (transactionList) {
            TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            if (transactionInformation == null) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "received acknowledgement with Unknown Transaction ID " + transactionUID + ": ignoring message"), 410);
            }
            if (transactionInformation.getState().getState() == 8) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Transaction " + consumerUID + ": is has timed out "), 408);
            }
            if (transactionInformation.getState().getState() != 1) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Transaction " + consumerUID + ": is not started, ignoring"), 412);
            }
            transactionInformation.addConsumedMessage(sysMessageID, consumerUID, consumerUID2);
        }
        if (bl) {
            this.store.storeTransactionAck(transactionUID, new TransactionAcknowledgement(sysMessageID, consumerUID, consumerUID2), false);
        }
    }

    public synchronized List retrieveSentMessages(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation == null) {
            return null;
        }
        return transactionInformation.getPublishedMessages();
    }

    public synchronized int retrieveNSentMessages(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation == null) {
            return 0;
        }
        return transactionInformation.getNPublishedMessages();
    }

    public synchronized HashMap retrieveConsumedMessages(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation == null) {
            return null;
        }
        return transactionInformation.getConsumedMessages();
    }

    public synchronized HashMap retrieveStoredConsumerUIDs(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation == null) {
            return null;
        }
        return transactionInformation.getStoredConsumerUIDs();
    }

    public synchronized int retrieveNConsumedMessages(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation == null) {
            return 0;
        }
        return transactionInformation.getNConsumedMessages();
    }

    public synchronized TransactionState retrieveState(TransactionUID transactionUID) {
        if (transactionUID == null) {
            return null;
        }
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation == null) {
            return null;
        }
        return transactionInformation.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionState updateState(TransactionUID transactionUID, int n, boolean bl) throws BrokerException {
        TransactionState transactionState = null;
        TransactionList transactionList = this;
        synchronized (transactionList) {
            TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            if (transactionInformation == null) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "updateState(): Unknown transaction: " + transactionUID));
            }
            transactionState = transactionInformation.getState();
            if (transactionState == null) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "updateState(): No state for transaction: " + transactionUID), 410);
            }
            if (transactionState.getState() == 8) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Transaction " + transactionUID + ": is has timed out"), 408);
            }
            transactionState.setState(n);
        }
        if (bl) {
            try {
                this.store.updateTransactionState(transactionUID, transactionState, Destination.PERSIST_SYNC);
            }
            catch (IOException iOException) {
                throw new BrokerException(null, iOException);
            }
        }
        return transactionState;
    }

    public synchronized TransactionUID xidToUID(JMQXid jMQXid) {
        return (TransactionUID)this.xidTable.get(jMQXid);
    }

    public synchronized TransactionUID slowXidToUID(JMQXid jMQXid) {
        Set set = this.translist.entrySet();
        Iterator iterator = set.iterator();
        TransactionState transactionState = null;
        JMQXid jMQXid2 = null;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TransactionInformation transactionInformation = (TransactionInformation)entry.getValue();
            transactionState = transactionInformation.getState();
            jMQXid2 = transactionState.getXid();
            if (jMQXid2 == null || !jMQXid.equals(jMQXid2)) continue;
            return (TransactionUID)entry.getKey();
        }
        return null;
    }

    public synchronized JMQXid UIDToXid(TransactionUID transactionUID) {
        TransactionState transactionState = this.retrieveState(transactionUID);
        if (transactionState != null) {
            return transactionState.getXid();
        }
        return null;
    }

    public synchronized Vector getTransactions(int n) {
        Set set = this.translist.keySet();
        Iterator iterator = set.iterator();
        TransactionUID transactionUID = null;
        TransactionState transactionState = null;
        Vector<TransactionUID> vector = new Vector<TransactionUID>();
        while (iterator.hasNext()) {
            transactionUID = (TransactionUID)iterator.next();
            if (n < 0) {
                vector.add(transactionUID);
                continue;
            }
            transactionState = this.retrieveState(transactionUID);
            if (transactionState == null || transactionState.getState() != n) continue;
            vector.add(transactionUID);
        }
        return vector;
    }

    public void addOrphanAck(TransactionUID transactionUID, SysMessageID sysMessageID, ConsumerUID consumerUID) {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation != null) {
            transactionInformation.addOrphanAck(sysMessageID, consumerUID);
        }
    }

    public Map getOrphanAck(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation != null) {
            return transactionInformation.getOrphanAck();
        }
        return null;
    }

    public synchronized void loadTransactions() throws BrokerException, IOException {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        Object object4;
        Serializable serializable2;
        Serializable serializable3;
        boolean bl = Globals.getConfig().getBooleanProperty("imq.transaction.autorollback", false);
        LoadException loadException = Globals.getStore().getLoadTransactionException();
        if (loadException != null) {
            serializable3 = loadException;
            while (serializable3 != null) {
                serializable2 = (TransactionUID)((LoadException)serializable3).getKey();
                object4 = (TransactionAcknowledgement[])((LoadException)serializable3).getValue();
                if (serializable2 == null && object4 == null) {
                    this.logger.log(16, "B3044", "both key and value for a Transactions entry are corrupted");
                    continue;
                }
                if (serializable2 == null) {
                    this.logger.log(16, "B2098", ((TransactionState)object4).toString());
                } else {
                    this.logger.log(16, "B2097", serializable2);
                    serializable = new TransactionState(AutoRollbackType.NOT_PREPARED, 0L, true);
                    ((TransactionState)serializable).setState(5);
                    try {
                        this.store.storeTransaction((TransactionUID)serializable2, (TransactionState)serializable, false);
                    }
                    catch (Exception exception) {
                        this.logger.logStack(16, "B3044", "Error updating transaction " + serializable2, (Throwable)exception);
                    }
                }
                serializable3 = ((LoadException)serializable3).getNextException();
            }
        }
        if ((loadException = Globals.getStore().getLoadTransactionAckException()) != null) {
            serializable3 = loadException;
            while (serializable3 != null) {
                serializable2 = (TransactionUID)((LoadException)serializable3).getKey();
                object4 = (TransactionAcknowledgement[])((LoadException)serializable3).getValue();
                if (serializable2 == null && object4 == null) {
                    this.logger.log(16, "B3044", "both key and value for a Transaction Ack entry are corrupted");
                    continue;
                }
                if (serializable2 == null) {
                    this.logger.log(16, "B2098", object4.toString());
                } else {
                    this.logger.log(16, "B2099", ((TransactionUID)serializable2).toString());
                    try {
                        this.store.removeTransactionAck((TransactionUID)serializable2, false);
                    }
                    catch (Exception exception) {
                        this.logger.logStack(16, "B3044", "Error updating transaction ack " + serializable2, (Throwable)exception);
                    }
                }
                serializable3 = ((LoadException)serializable3).getNextException();
            }
        }
        this.logger.log(8, "B1136");
        serializable3 = this.store.getAllTransactionStates();
        TransactionList.logTransactionInfo((HashMap)serializable3, bl);
        if (((HashMap)serializable3).size() <= 0) {
            return;
        }
        serializable2 = new HashSet(((HashMap)serializable3).size());
        object4 = new HashMap();
        serializable = new HashMap();
        this.logger.log(4, "Broker left open transactions when it crashed");
        Iterator<Object> iterator = ((HashMap)serializable3).keySet().iterator();
        while (iterator.hasNext()) {
            try {
                object3 = (TransactionUID)iterator.next();
                object2 = (TransactionState)((HashMap)serializable3).get(object3);
                object = this.store.getTransactionAcks((TransactionUID)object3);
                int n = ((TransactionState)object2).getState();
                switch (n) {
                    case 0: {
                        ((HashSet)serializable2).add(object3);
                        break;
                    }
                    case 5: {
                        if (!bl) {
                            this.addTransactionID((TransactionUID)object3, (TransactionState)object2, false);
                            ((HashMap)object4).put(object3, Boolean.TRUE);
                            break;
                        }
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: {
                        this.addTransactionID((TransactionUID)object3, (TransactionState)object2, false);
                        this.setTransactionIDStored((TransactionUID)object3);
                        ((HashMap)object4).put(object3, Boolean.FALSE);
                        ((HashSet)serializable2).add(object3);
                        ((TransactionState)object2).setState(7);
                        break;
                    }
                    case 6: {
                        ((HashSet)serializable2).add(object3);
                    }
                }
                for (int i = 0; i < ((TransactionAcknowledgement[])object).length; ++i) {
                    ConsumerUID consumerUID = ((TransactionAcknowledgement)object[i]).getConsumerUID();
                    ConsumerUID consumerUID2 = ((TransactionAcknowledgement)object[i]).getStoredConsumerUID();
                    SysMessageID sysMessageID = ((TransactionAcknowledgement)object[i]).getSysMessageID();
                    HashMap<ConsumerUID, Object> hashMap = (HashMap<ConsumerUID, Object>)((HashMap)serializable).get(sysMessageID);
                    if (consumerUID == null) {
                        this.logger.log(16, "Internal Error:  Unable to locate stored ConsumerUID :" + object);
                        consumerUID = consumerUID2;
                        if (object == null) {
                            this.logger.log(16, "Internal Error:  no consumerUID stored w/ the transaction:" + object);
                            continue;
                        }
                    }
                    if (hashMap == null) {
                        hashMap = new HashMap<ConsumerUID, Object>();
                        ((HashMap)serializable).put(sysMessageID, hashMap);
                    }
                    hashMap.put(((TransactionAcknowledgement)object[i]).getStoredConsumerUID(), object3);
                    if (((HashMap)object4).get(object3) == null) continue;
                    TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(object3);
                    if (transactionInformation == null) {
                        this.logger.log(8, "Unable to retrieve  transaction information " + transactionInformation + " for " + object3 + " we may be clearing the transaction");
                        continue;
                    }
                    if (((HashMap)object4).get(object3) == Boolean.TRUE) {
                        transactionInformation.addConsumedMessage(sysMessageID, consumerUID, consumerUID2);
                    }
                    transactionInformation.addOrphanAck(sysMessageID, consumerUID);
                }
            }
            catch (Exception exception) {
                this.logger.logStack(16, "B3100", "Error parsing transaction ", (Throwable)exception);
            }
        }
        if (!(((HashMap)object4).size() <= 0 && ((HashMap)serializable).size() <= 0 || (object3 = Destination.processTransactions((Map)((Object)serializable), (Map)object4)) == null || object3.isEmpty())) {
            object2 = object3.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(object.getValue());
                transactionInformation.addPublishedMessage((SysMessageID)object.getKey());
            }
        }
        iterator = ((HashSet)serializable2).iterator();
        while (iterator.hasNext()) {
            object3 = (TransactionUID)iterator.next();
            object2 = (TransactionState)((HashMap)serializable3).get(object3);
            this.logger.log(4, "Clearing transaction " + object3);
            this.removeTransactionAck((TransactionUID)object3);
            this.removeTransactionID((TransactionUID)object3);
        }
    }

    public static void logTransactionInfo(HashMap hashMap, boolean bl) {
        Logger logger = Globals.getLogger();
        int n = 0;
        int n2 = 0;
        if (hashMap != null && hashMap.size() > 0) {
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                TransactionState transactionState = (TransactionState)iterator.next();
                if (transactionState.getState() == 5) {
                    ++n2;
                    if (!bl) continue;
                    ++n;
                    continue;
                }
                ++n;
            }
            logger.log(8, "B1079", (Object)new Integer(hashMap.size()), new Integer(n));
            if (n2 > 0) {
                logger.log(8, "B1080", (Object)new Integer(hashMap.size()), new Integer(n2));
                if (bl) {
                    logger.log(8, "B1081");
                } else {
                    logger.log(8, "B1082");
                }
            }
        }
    }
}

