/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.PacketUtil;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AckHandler
extends PacketHandler {
    static final int ACK_BLOCK_SIZE = 40;
    private int ackProcessCnt = 0;
    private FaultInjection fi = null;
    private TransactionList translist = null;
    private final Logger logger = Globals.getLogger();
    public static boolean DEBUG = false;
    public static int ACKNOWLEDGE_REQUEST = 0;
    public static int UNDELIVERABLE_REQUEST = 1;
    public static int DEAD_REQUEST = 2;

    public static void checkRequestType(int n) throws BrokerException {
        if (n > DEAD_REQUEST || n < ACKNOWLEDGE_REQUEST) {
            throw new BrokerException("Internal Error: unknown ackType " + n);
        }
    }

    public AckHandler(TransactionList transactionList) {
        this.translist = transactionList;
        this.fi = FaultInjection.getInjection();
    }

    /*
     * Unable to fully structure code
     */
    public boolean handle(IMQConnection var1_1, Packet var2_2) throws BrokerException {
        block44: {
            block46: {
                block45: {
                    block43: {
                        var3_3 = var2_2.getMessageBodySize();
                        var4_4 = var3_3 / 40;
                        var5_5 = var3_3 % 40;
                        var6_6 = 200;
                        var7_7 = null;
                        if (AckHandler.DEBUG) {
                            this.logger.log(4, "AckHandler: processing message {0} {1}", (Object)var2_2.toString(), var1_1.getConnectionUID().toString());
                        }
                        if (var1_1.isAdminConnection()) ** GOTO lbl-1000
                        if (FaultInjection.FAULT_INJECTION) {
                            ++this.ackProcessCnt;
                        } else lbl-1000:
                        // 2 sources

                        {
                            this.ackProcessCnt = 0;
                        }
                        if (var4_4 == 0) {
                            this.logger.log(32, "B3100", "Internal Error: Empty Ack Message " + var2_2.getSysMessageID().toString());
                            var7_7 = "Empty ack message";
                            var6_6 = 500;
                        }
                        if (var5_5 != 0) {
                            this.logger.log(32, "B3100", "Internal Error: Invalid Ack Message Size " + String.valueOf(var3_3) + " for message " + var2_2.getSysMessageID().toString());
                            var7_7 = "corrupted ack message";
                            var6_6 = 500;
                        }
                        var8_8 = null;
                        if (var2_2.getTransactionID() != 0L) {
                            try {
                                var8_8 = new TransactionUID(var2_2.getTransactionID());
                            }
                            catch (Exception var9_9) {
                                this.logger.log(32, "B3100", (Object)("Internal Error: can not create transactionID for " + var2_2), (Throwable)var9_9);
                                var6_6 = 500;
                            }
                        }
                        var9_10 = false;
                        var10_11 = null;
                        var11_12 = null;
                        var12_13 = null;
                        var13_14 = 0;
                        var14_15 = AckHandler.ACKNOWLEDGE_REQUEST;
                        var15_16 = false;
                        try {
                            var10_11 = var2_2.getProperties();
                            var16_17 = var10_11 == null ? null : (Integer)var10_11.get("JMQAckType");
                            var14_15 = var16_17 == null ? AckHandler.ACKNOWLEDGE_REQUEST : var16_17.intValue();
                            var17_19 = var10_11 == null ? null : (Boolean)var10_11.get("JMQValidate");
                            var15_16 = var17_19 == null ? false : var17_19.booleanValue();
                            AckHandler.checkRequestType(var14_15);
                            if (var14_15 == AckHandler.DEAD_REQUEST) {
                                var11_12 = (Throwable)var10_11.get("JMQException");
                                var12_13 = (String)var10_11.get("JMQComment");
                                var18_21 = (Integer)var10_11.get("JMSXDeliveryCount");
                                var13_14 = var18_21 == null ? -1 : var18_21.intValue();
                            }
                        }
                        catch (Exception var16_18) {
                            this.logger.logStack(8, "Internal Error: bad protocol", var16_18);
                            var14_15 = AckHandler.ACKNOWLEDGE_REQUEST;
                        }
                        if (!var1_1.isAdminConnection()) {
                            if (FaultInjection.FAULT_INJECTION) {
                                var16_17 = new HashMap<K, V>();
                                if (var10_11 != null) {
                                    var16_17.putAll(var10_11);
                                }
                                var16_17.put("mqAckCount", new Integer(this.ackProcessCnt));
                                var16_17.put("mqIsTransacted", new Boolean(var8_8 != null));
                                this.fi.checkFaultAndExit(FaultInjection.FAULT_ACK_MSG_1, (Map)var16_17, 2, false);
                            }
                        }
                        var16_17 = null;
                        try {
                            if (var6_6 == 200) {
                                var17_19 = new DataInputStream(var2_2.getMessageBodyStream());
                                var18_21 = new SysMessageID[var4_4];
                                var19_22 = new ConsumerUID[var4_4];
                                for (var20_23 = 0; var20_23 < var4_4; ++var20_23) {
                                    var21_25 = var17_19.readLong();
                                    var19_22[var20_23] = new ConsumerUID(var21_25);
                                    var19_22[var20_23].setConnectionUID(var1_1.getConnectionUID());
                                    var18_21[var20_23] = new SysMessageID();
                                    var18_21[var20_23].readID((DataInput)var17_19);
                                }
                                if (var15_16) {
                                    if (var14_15 == AckHandler.DEAD_REQUEST || var14_15 == AckHandler.UNDELIVERABLE_REQUEST) {
                                        var6_6 = 400;
                                        var7_7 = "Can not use JMQValidate with ackType of " + var14_15;
                                    } else if (var8_8 == null) {
                                        var6_6 = 400;
                                        var7_7 = "Can not use JMQValidate with no tid ";
                                    } else if (!this.validateMessages(var8_8, (SysMessageID[])var18_21, var19_22)) {
                                        var6_6 = 404;
                                        var7_7 = "Acknowledgement not processed";
                                    }
                                } else {
                                    var16_17 = var14_15 == AckHandler.DEAD_REQUEST ? this.handleDeadMsgs((SysMessageID[])var18_21, var19_22, var11_12, var12_13, var13_14) : (var14_15 == AckHandler.UNDELIVERABLE_REQUEST ? this.handleUndeliverableMsgs((SysMessageID[])var18_21, var19_22) : (var8_8 != null ? this.handleTransaction(var8_8, (SysMessageID[])var18_21, var19_22) : this.handleAcks(var1_1, (SysMessageID[])var18_21, var19_22)));
                                }
                            }
                        }
                        catch (Throwable var17_20) {
                            var6_6 = 500;
                            if (var17_20 instanceof BrokerException) {
                                var6_6 = ((BrokerException)var17_20).getStatusCode();
                            }
                            var7_7 = var17_20.getMessage();
                            if (var6_6 != 500) break block43;
                            this.logger.logStack(32, "B3100", "-------------------------------------------Internal Error: Invalid Acknowledge Packet processing\n " + (var2_2.getSendAcknowledge() != false ? " notifying client\n" : " can not notify the client") + PacketUtil.dumpPacket(var2_2) + "--------------------------------------------", var17_20);
                        }
                    }
                    if (!var1_1.isAdminConnection()) {
                        if (FaultInjection.FAULT_INJECTION) {
                            var17_19 = new HashMap<K, V>();
                            if (var10_11 != null) {
                                var17_19.putAll(var10_11);
                            }
                            var17_19.put("mqAckCount", new Integer(this.ackProcessCnt));
                            var17_19.put("mqIsTransacted", new Boolean(var8_8 != null));
                            this.fi.checkFaultAndExit(FaultInjection.FAULT_ACK_MSG_2, (Map)var17_19, 2, false);
                        }
                    }
                    if (!var2_2.getSendAcknowledge()) break block44;
                    var17_19 = new Packet(var1_1.useDirectBuffers());
                    var17_19.setPacketType(25);
                    var17_19.setConsumerID(var2_2.getConsumerID());
                    var18_21 = new Hashtable<K, V>();
                    var18_21.put("JMQStatus", new Integer(var6_6));
                    if (var7_7 != null) {
                        var18_21.put("JMQReason", var7_7);
                    }
                    if (IMQConnection.DUMP_PACKET) break block45;
                    if (!IMQConnection.OUT_DUMP_PACKET) break block46;
                }
                var18_21.put("JMQReqID", var2_2.getSysMessageID().toString());
            }
            var17_19.setProperties((Hashtable)var18_21);
            var1_1.sendControlMessage((Packet)var17_19);
        }
        if (!var1_1.isAdminConnection()) {
            if (FaultInjection.FAULT_INJECTION) {
                var17_19 = new HashMap<K, V>();
                if (var10_11 != null) {
                    var17_19.putAll(var10_11);
                }
                var17_19.put("mqAckCount", new Integer(this.ackProcessCnt));
                var17_19.put("mqIsTransacted", new Boolean(var8_8 != null));
                this.fi.checkFaultAndExit(FaultInjection.FAULT_ACK_MSG_3, (Map)var17_19, 2, false);
            }
        }
        if (var16_17 != null && !var16_17.isEmpty()) {
            var17_19 = var16_17.iterator();
            while (var17_19.hasNext()) {
                var18_21 = (PacketReference)var17_19.next();
                var19_22 = var18_21.getDestination();
                try {
                    if (var18_21.isDead()) {
                        var19_22.removeDeadMessage((PacketReference)var18_21);
                        continue;
                    }
                    var19_22.removeMessage(var18_21.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                }
                catch (Exception var20_24) {
                    this.logger.log(8, "Internal Error: unable to clean up message " + var18_21 + " after ack " + "processing");
                }
            }
        }
        return true;
    }

    public List handleAcks(IMQConnection iMQConnection, SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray) throws BrokerException, IOException {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (int i = 0; i < sysMessageIDArray.length; ++i) {
            Object object;
            Session session = Session.getSession(consumerUIDArray[i]);
            if (session == null) {
                object = Consumer.getConsumer(consumerUIDArray[i]);
                if (object == null) {
                    if (!iMQConnection.isValid() || iMQConnection.isBeingDestroyed()) {
                        this.logger.log(4, "Received ack for consumer " + consumerUIDArray[i] + " on closing connection " + iMQConnection);
                        continue;
                    }
                    if (BrokerStateHandler.shutdownStarted) {
                        throw new BrokerException("B1248");
                    }
                    throw new BrokerException("Internal Error: Unable to complete processing acks: Unknown consumer " + consumerUIDArray[i]);
                }
                if (((Consumer)object).getConsumerUID().getBrokerAddress() != Globals.getClusterBroadcast().getMyAddress()) {
                    ConsumerUID consumerUID;
                    PacketReference packetReference = Destination.get(sysMessageIDArray[i]);
                    if (!packetReference.acknowledged(consumerUID = ((Consumer)object).getConsumerUID(), ((Consumer)object).getStoredConsumerUID(), !consumerUID.isDupsOK(), true, null)) continue;
                    linkedList.add(packetReference);
                    continue;
                }
                this.logger.log(8, Globals.getBrokerResources().getString("B3100", "local consumer does not have associated session " + object));
                throw new BrokerException("Unknown local consumer " + consumerUIDArray[i]);
            }
            object = session.ackMessage(consumerUIDArray[i], sysMessageIDArray[i], null);
            if (object == null) continue;
            linkedList.add(object);
        }
        return linkedList;
    }

    public List handleTransaction(TransactionUID transactionUID, SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray) throws BrokerException {
        for (int i = 0; i < sysMessageIDArray.length; ++i) {
            try {
                ConsumerUID consumerUID;
                Session session = Session.getSession(consumerUIDArray[i]);
                Consumer consumer = Consumer.getConsumer(consumerUIDArray[i]);
                ConsumerUID consumerUID2 = consumerUID = consumer != null ? consumer.getStoredConsumerUID() : null;
                if (session == null && consumer != null) {
                    SessionUID sessionUID = consumer.getSessionUID();
                    session = Session.getSession(sessionUID);
                }
                if (session == null) {
                    if (BrokerStateHandler.shutdownStarted) {
                        throw new BrokerException("B1248");
                    }
                    throw new BrokerException("Internal Error: Unable to complete processing transaction: Unknown consumer/session " + consumerUIDArray[i]);
                }
                this.translist.addAcknowledgement(transactionUID, sysMessageIDArray[i], consumerUIDArray[i], consumerUID);
                session.acknowledgeInTransaction(consumerUIDArray[i], sysMessageIDArray[i], transactionUID);
                continue;
            }
            catch (Exception exception) {
                this.logger.log(8, "Internal Exception processing trans acknowledge [" + transactionUID + "," + sysMessageIDArray[i] + "," + consumerUIDArray[i] + "]", exception);
                throw new BrokerException("Internal Error: Unable to  complete processing acknowledgements in a tranaction: " + exception, exception);
            }
        }
        return null;
    }

    public boolean validateMessages(TransactionUID transactionUID, SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray) throws BrokerException {
        boolean bl = false;
        try {
            this.translist.getTransactionMap(transactionUID, false);
            bl = true;
        }
        catch (BrokerException brokerException) {
            // empty catch block
        }
        if (bl) {
            for (int i = 0; i < sysMessageIDArray.length; ++i) {
                Consumer consumer = Consumer.getConsumer(consumerUIDArray[i]);
                if (consumer == null) {
                    throw new BrokerException("Internal Error, unknown consumer " + consumerUIDArray[i], 400);
                }
                if (this.translist.checkAcknowledgement(transactionUID, sysMessageIDArray[i], consumer.getConsumerUID())) continue;
                return false;
            }
        } else {
            for (int i = 0; i < sysMessageIDArray.length; ++i) {
                Consumer consumer = Consumer.getConsumer(consumerUIDArray[i]);
                if (consumer == null) {
                    throw new BrokerException("Internal Error, unknown consumer " + consumerUIDArray[i], 400);
                }
                PacketReference packetReference = Destination.get(sysMessageIDArray[i]);
                if (packetReference == null) {
                    this.logger.log(4, "in validateMessages: Could not find " + sysMessageIDArray[i]);
                    continue;
                }
                if (packetReference.hasConsumerAcked(consumer.getStoredConsumerUID())) continue;
                return false;
            }
        }
        return true;
    }

    public List handleDeadMsgs(SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray, Throwable throwable, String string, int n) throws BrokerException {
        ArrayList<PacketReference> arrayList = new ArrayList<PacketReference>();
        for (int i = 0; i < sysMessageIDArray.length; ++i) {
            PacketReference packetReference;
            Session session = Session.getSession(consumerUIDArray[i]);
            if (session == null) {
                this.logger.log(4, "Dead message for Unknown Consumer/Session" + consumerUIDArray[i]);
                continue;
            }
            if (DEBUG) {
                this.logger.log(4, "Handling Dead Message " + consumerUIDArray[i] + ":" + sysMessageIDArray[i]);
            }
            if ((packetReference = session.handleDead(consumerUIDArray[i], sysMessageIDArray[i], throwable, string, n)) == null) continue;
            arrayList.add(packetReference);
        }
        return arrayList;
    }

    public List handleUndeliverableMsgs(SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray) throws BrokerException {
        ArrayList<PacketReference> arrayList = new ArrayList<PacketReference>();
        for (int i = 0; i < sysMessageIDArray.length; ++i) {
            PacketReference packetReference;
            Session session = Session.getSession(consumerUIDArray[i]);
            if (session == null) {
                this.logger.log(4, "Undeliverable message for Unknown Consumer/Session" + consumerUIDArray[i]);
            }
            if (DEBUG) {
                this.logger.log(4, "Handling Undeliverable Message " + consumerUIDArray[i] + ":" + sysMessageIDArray[i]);
            }
            if ((packetReference = session.handleUndeliverable(consumerUIDArray[i], sysMessageIDArray[i])) == null) continue;
            arrayList.add(packetReference);
        }
        return arrayList;
    }
}

