/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.util.ClusterUtil;
import com.sun.messaging.jmq.jmsserver.management.util.MQAddressUtil;
import com.sun.messaging.jms.management.server.BrokerNotification;
import com.sun.messaging.jms.management.server.ClusterNotification;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.openmbean.CompositeData;

public class BrokerMonitor
extends MQMBeanReadOnly
implements ConfigListener {
    private Properties brokerProps = null;
    private static MBeanAttributeInfo[] attrs;
    private static String[] brokerNotificationTypes;
    private static String[] clusterNotificationTypes;
    private static MBeanNotificationInfo[] notifs;

    public BrokerMonitor() {
        this.initProps();
        BrokerConfig brokerConfig = Globals.getConfig();
        brokerConfig.addListener("imq.instancename", this);
        brokerConfig.addListener("imq.portmapper.port", this);
        brokerConfig.addListener("imq.product.version", this);
        brokerConfig.addListener("imq.system.max_count", this);
    }

    public String getBrokerID() {
        return Globals.getBrokerID();
    }

    public Boolean getEmbedded() {
        return new Boolean(Broker.isInProcess());
    }

    public Boolean isEmbedded() {
        return this.getEmbedded();
    }

    public String getInstanceName() {
        return this.brokerProps.getProperty("imq.instancename");
    }

    public Integer getPort() throws MBeanException {
        String string = this.brokerProps.getProperty("imq.portmapper.port");
        Integer n = null;
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            this.handleGetterException("Port", exception);
        }
        return n;
    }

    public MQAddress getMQAddress() {
        MQAddress mQAddress = null;
        try {
            mQAddress = MQAddressUtil.getPortMapperMQAddress(this.getPort());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mQAddress;
    }

    public String getVersion() {
        return this.brokerProps.getProperty("imq.product.version");
    }

    public String getMBeanName() {
        return "BrokerMonitor";
    }

    public String getMBeanDescription() {
        return mbr.getString("MB1042");
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return null;
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    public void validate(String string, String string2) throws PropertyUpdateException {
    }

    public boolean update(String string, String string2) {
        this.initProps();
        return true;
    }

    public void notifyQuiesceStart() {
        this.sendNotification(new BrokerNotification("mq.broker.quiesce.start", this, this.sequenceNumber++));
    }

    public void notifyQuiesceComplete() {
        this.sendNotification(new BrokerNotification("mq.broker.quiesce.complete", this, this.sequenceNumber++));
    }

    public void notifyShutdownStart() {
        this.sendNotification(new BrokerNotification("mq.broker.shutdown.start", this, this.sequenceNumber++));
    }

    public void notifyTakeoverStart(String string) {
        BrokerNotification brokerNotification = new BrokerNotification("mq.broker.takeover.start", this, this.sequenceNumber++);
        brokerNotification.setFailedBrokerID(string);
        CompositeData compositeData = this.getLocalBrokerInfo();
        if (compositeData != null) {
            brokerNotification.setBrokerAddress((String)compositeData.get("Address"));
            brokerNotification.setBrokerID((String)compositeData.get("ID"));
        }
        this.sendNotification(brokerNotification);
    }

    public void notifyTakeoverComplete(String string) {
        BrokerNotification brokerNotification = new BrokerNotification("mq.broker.takeover.complete", this, this.sequenceNumber++);
        brokerNotification.setFailedBrokerID(string);
        CompositeData compositeData = this.getLocalBrokerInfo();
        if (compositeData != null) {
            brokerNotification.setBrokerAddress((String)compositeData.get("Address"));
            brokerNotification.setBrokerID((String)compositeData.get("ID"));
        }
        this.sendNotification(brokerNotification);
    }

    public void notifyTakeoverFail(String string) {
        BrokerNotification brokerNotification = new BrokerNotification("mq.broker.takeover.fail", this, this.sequenceNumber++);
        brokerNotification.setFailedBrokerID(string);
        CompositeData compositeData = this.getLocalBrokerInfo();
        if (compositeData != null) {
            brokerNotification.setBrokerAddress((String)compositeData.get("Address"));
            brokerNotification.setBrokerID((String)compositeData.get("ID"));
        }
        this.sendNotification(brokerNotification);
    }

    public void notifyClusterBrokerJoin(String string) {
        ClusterNotification clusterNotification = new ClusterNotification("mq.cluster.broker.join", this, this.sequenceNumber++);
        clusterNotification.setBrokerID(string);
        clusterNotification.setBrokerAddress(ClusterUtil.getBrokerAddress(string));
        clusterNotification.setClusterID(Globals.getClusterID());
        clusterNotification.setHighlyAvailable(Globals.getHAEnabled());
        boolean bl = false;
        bl = clusterNotification.isHighlyAvailable() ? false : false;
        clusterNotification.setMasterBroker(bl);
        this.sendNotification(clusterNotification);
    }

    private CompositeData getLocalBrokerInfo() {
        ClusterManager clusterManager = Globals.getClusterManager();
        CompositeData compositeData = null;
        if (clusterManager == null) {
            return null;
        }
        MQAddress mQAddress = clusterManager.getMQAddress();
        String string = null;
        try {
            string = clusterManager.lookupBrokerID(BrokerMQAddress.createAddress(mQAddress.toString()));
        }
        catch (Exception exception) {
            return null;
        }
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            ClusteredBroker clusteredBroker = clusterManager.getBroker(string);
            if (clusteredBroker == null) {
                return null;
            }
            compositeData = ClusterUtil.getConfigCompositeData(clusteredBroker);
        }
        catch (Exception exception) {
            return null;
        }
        return compositeData;
    }

    private void initProps() {
        this.brokerProps = Globals.getConfig().toProperties();
        Version version = Globals.getVersion();
        this.brokerProps.putAll((Map<?, ?>)version.getProps());
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[5];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("BrokerID", String.class.getName(), mbr.getString("MB1028"), true, false, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("Embedded", Boolean.class.getName(), mbr.getString("MB1029"), true, false, true);
        Class clazz = String.class;
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("InstanceName", clazz.getName(), mbr.getString("MB1030"), true, false, false);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("Port", Integer.class.getName(), mbr.getString("MB1031"), true, false, false);
        Class clazz2 = String.class;
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("Version", clazz2.getName(), mbr.getString("MB1032"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        brokerNotificationTypes = new String[]{"mq.broker.quiesce.complete", "mq.broker.quiesce.start", "mq.broker.shutdown.start", "mq.broker.takeover.complete", "mq.broker.takeover.fail", "mq.broker.takeover.start"};
        clusterNotificationTypes = new String[]{"mq.cluster.broker.join"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[2];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(brokerNotificationTypes, BrokerNotification.class.getName(), mbr.getString("MB1026"));
        mBeanNotificationInfoArray[1] = new MBeanNotificationInfo(clusterNotificationTypes, ClusterNotification.class.getName(), mbr.getString("MB1024"));
        notifs = mBeanNotificationInfoArray;
    }
}

