/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import [Ljava.lang.String;;
import com.sun.messaging.jmq.io.DestMetricsCounters;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.util.DestinationUtil;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jms.management.server.DestinationNotification;
import com.sun.messaging.jms.management.server.DestinationState;
import com.sun.messaging.jms.management.server.MQObjectName;
import java.util.Iterator;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;

public class DestinationMonitor
extends MQMBeanReadOnly {
    private Destination d = null;
    private static MBeanAttributeInfo[] attrs;
    private static MBeanOperationInfo[] ops;
    private static String[] dstNotificationTypes;
    private static MBeanNotificationInfo[] notifs;

    public DestinationMonitor(Destination destination) {
        this.d = destination;
    }

    public Integer getAvgNumActiveConsumers() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Integer(destMetricsCounters.getAvgActiveConsumers());
    }

    public Integer getAvgNumBackupConsumers() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Integer(destMetricsCounters.getAvgFailoverConsumers());
    }

    public Integer getAvgNumConsumers() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Integer(destMetricsCounters.getAvgActiveConsumers());
    }

    public Long getAvgNumMsgs() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Long(destMetricsCounters.getAverageMessages());
    }

    public Long getAvgTotalMsgBytes() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Long(destMetricsCounters.getAverageMessageBytes());
    }

    public String getConnectionID() {
        if (!this.isTemporary().booleanValue()) {
            return null;
        }
        ConnectionUID connectionUID = this.d.getConnectionUID();
        if (connectionUID == null) {
            return null;
        }
        return Long.toString(connectionUID.longValue());
    }

    public Boolean isCreatedByAdmin() {
        boolean bl = !this.d.isAutoCreated() && !this.d.isInternal() && !this.d.isDMQ() && !this.d.isAdmin();
        return new Boolean(bl);
    }

    public Boolean getCreatedByAdmin() {
        return this.isCreatedByAdmin();
    }

    public Long getDiskReserved() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Long(destMetricsCounters.getDiskReserved());
    }

    public Long getDiskUsed() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Long(destMetricsCounters.getDiskUsed());
    }

    public Integer getDiskUtilizationRatio() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Integer(destMetricsCounters.getDiskUtilizationRatio());
    }

    public Long getMsgBytesIn() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Long(destMetricsCounters.getMessageBytesIn());
    }

    public Long getMsgBytesOut() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Long(destMetricsCounters.getMessageBytesOut());
    }

    public String getName() {
        return this.d.getDestinationName();
    }

    public Integer getNumActiveConsumers() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Integer(destMetricsCounters.getActiveConsumers());
    }

    public Integer getNumBackupConsumers() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Integer(destMetricsCounters.getFailoverConsumers());
    }

    public Integer getNumConsumers() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Integer(destMetricsCounters.getNumConsumers());
    }

    public Long getNumMsgs() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        if (destinationInfo == null) {
            return null;
        }
        return new Long(destinationInfo.nMessages - destinationInfo.nTxnMessages);
    }

    public Long getNumMsgsHeldInTransaction() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        if (destinationInfo == null) {
            return null;
        }
        return new Long(destinationInfo.nTxnMessages);
    }

    public Long getNumMsgsIn() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Long(destMetricsCounters.getMessagesIn());
    }

    public Long getNumMsgsOut() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Long(destMetricsCounters.getMessagesOut());
    }

    public Long getNumMsgsPendingAcks() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        if (destinationInfo == null) {
            return null;
        }
        return new Long(destinationInfo.nUnackMessages);
    }

    public Integer getNumProducers() {
        return new Integer(this.d.getProducerCount());
    }

    public Long getPeakMsgBytes() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Long(destMetricsCounters.getHighWaterLargestMsgBytes());
    }

    public Integer getPeakNumActiveConsumers() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Integer(destMetricsCounters.getHWActiveConsumers());
    }

    public Integer getPeakNumBackupConsumers() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Integer(destMetricsCounters.getHWFailoverConsumers());
    }

    public Integer getPeakNumConsumers() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Integer(destMetricsCounters.getHWActiveConsumers());
    }

    public Long getPeakNumMsgs() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Long(destMetricsCounters.getHighWaterMessages());
    }

    public Long getPeakTotalMsgBytes() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Long(destMetricsCounters.getHighWaterMessageBytes());
    }

    public Integer getState() {
        return new Integer(DestinationUtil.toExternalDestState(this.d.getState()));
    }

    public String getStateLabel() {
        return DestinationState.toString(DestinationUtil.toExternalDestState(this.d.getState()));
    }

    public Boolean isTemporary() {
        return new Boolean(this.d.isTemporary());
    }

    public Boolean getTemporary() {
        return this.isTemporary();
    }

    public Long getTotalMsgBytes() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        if (destinationInfo == null) {
            return null;
        }
        return new Long(destinationInfo.nMessageBytes - destinationInfo.nTxnMessageBytes);
    }

    public Long getTotalMsgBytesHeldInTransaction() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        if (destinationInfo == null) {
            return null;
        }
        return new Long(destinationInfo.nTxnMessageBytes);
    }

    public String getType() {
        return this.d.isQueue() ? "q" : "t";
    }

    public String[] getActiveConsumerIDs() throws MBeanException {
        int n = this.getNumActiveConsumers();
        if (n <= 0) {
            return null;
        }
        Iterator iterator = this.d.getActiveConsumers().iterator();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (iterator.hasNext()) {
            Consumer consumer = (Consumer)iterator.next();
            long l = consumer.getConsumerUID().longValue();
            try {
                String string;
                stringArray[n2] = string = Long.toString(l);
            }
            catch (Exception exception) {
                this.handleOperationException("getActiveConsumerIDs", exception);
            }
            ++n2;
        }
        return stringArray;
    }

    public String[] getBackupConsumerIDs() throws MBeanException {
        int n = this.getNumBackupConsumers();
        if (n <= 0) {
            return null;
        }
        Iterator iterator = this.d.getFailoverConsumers().iterator();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (iterator.hasNext()) {
            Consumer consumer = (Consumer)iterator.next();
            long l = consumer.getConsumerUID().longValue();
            try {
                String string;
                stringArray[n2] = string = Long.toString(l);
            }
            catch (Exception exception) {
                this.handleOperationException("getBackupConsumerIDs", exception);
            }
            ++n2;
        }
        return stringArray;
    }

    public ObjectName getConnection() throws MBeanException {
        ObjectName objectName = null;
        if (!this.isTemporary().booleanValue()) {
            return null;
        }
        ConnectionUID connectionUID = this.d.getConnectionUID();
        if (connectionUID == null) {
            return null;
        }
        try {
            objectName = MQObjectName.createConnectionMonitor(Long.toString(connectionUID.longValue()));
        }
        catch (Exception exception) {
            this.handleOperationException("getConnection", exception);
        }
        return objectName;
    }

    public String[] getConsumerIDs() throws MBeanException {
        int n = this.getNumConsumers();
        if (n <= 0) {
            return null;
        }
        Iterator iterator = this.d.getConsumers();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (iterator.hasNext()) {
            Consumer consumer = (Consumer)iterator.next();
            long l = consumer.getConsumerUID().longValue();
            try {
                String string;
                stringArray[n2] = string = Long.toString(l);
            }
            catch (Exception exception) {
                this.handleOperationException("getConsumerIDs", exception);
            }
            ++n2;
        }
        return stringArray;
    }

    public String[] getProducerIDs() throws MBeanException {
        int n = this.getNumProducers();
        if (n <= 0) {
            return null;
        }
        Iterator iterator = this.d.getProducers();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (iterator.hasNext()) {
            Producer producer = (Producer)iterator.next();
            long l = producer.getProducerUID().longValue();
            try {
                stringArray[n2] = Long.toString(l);
            }
            catch (Exception exception) {
                this.handleOperationException("getProducerIDs", exception);
            }
            ++n2;
        }
        return stringArray;
    }

    public String getMBeanName() {
        return "DestinationMonitor";
    }

    public String getMBeanDescription() {
        return mbr.getString("MB1134");
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    public void notifyDestinationCompact() {
        DestinationNotification destinationNotification = new DestinationNotification("mq.destination.compact", this, this.sequenceNumber++);
        destinationNotification.setDestinationName(this.getName());
        destinationNotification.setDestinationType(this.getType());
        this.sendNotification(destinationNotification);
    }

    public void notifyDestinationPause(String string) {
        DestinationNotification destinationNotification = new DestinationNotification("mq.destination.pause", this, this.sequenceNumber++);
        destinationNotification.setDestinationName(this.getName());
        destinationNotification.setDestinationType(this.getType());
        destinationNotification.setPauseType(string);
        this.sendNotification(destinationNotification);
    }

    public void notifyDestinationPurge() {
        DestinationNotification destinationNotification = new DestinationNotification("mq.destination.purge", this, this.sequenceNumber++);
        destinationNotification.setDestinationName(this.getName());
        destinationNotification.setDestinationType(this.getType());
        this.sendNotification(destinationNotification);
    }

    public void notifyDestinationResume() {
        DestinationNotification destinationNotification = new DestinationNotification("mq.destination.resume", this, this.sequenceNumber++);
        destinationNotification.setDestinationName(this.getName());
        destinationNotification.setDestinationType(this.getType());
        this.sendNotification(destinationNotification);
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[34];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("AvgNumActiveConsumers", Integer.class.getName(), mbr.getString("MB1090"), true, false, false);
        Class clazz = Integer.class;
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("AvgNumBackupConsumers", clazz.getName(), mbr.getString("MB1091"), true, false, false);
        Class clazz2 = Integer.class;
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("AvgNumConsumers", clazz2.getName(), mbr.getString("MB1092"), true, false, false);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("AvgNumMsgs", Long.class.getName(), mbr.getString("MB1093"), true, false, false);
        Class clazz3 = Long.class;
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("AvgTotalMsgBytes", clazz3.getName(), mbr.getString("MB1094"), true, false, false);
        mBeanAttributeInfoArray[5] = new MBeanAttributeInfo("ConnectionID", String.class.getName(), mbr.getString("MB1095"), true, false, false);
        mBeanAttributeInfoArray[6] = new MBeanAttributeInfo("CreatedByAdmin", Boolean.class.getName(), mbr.getString("MB1096"), true, false, true);
        Class clazz4 = Long.class;
        mBeanAttributeInfoArray[7] = new MBeanAttributeInfo("DiskReserved", clazz4.getName(), mbr.getString("MB1097"), true, false, false);
        Class clazz5 = Long.class;
        mBeanAttributeInfoArray[8] = new MBeanAttributeInfo("DiskUsed", clazz5.getName(), mbr.getString("MB1098"), true, false, false);
        Class clazz6 = Integer.class;
        mBeanAttributeInfoArray[9] = new MBeanAttributeInfo("DiskUtilizationRatio", clazz6.getName(), mbr.getString("MB1099"), true, false, false);
        Class clazz7 = Long.class;
        mBeanAttributeInfoArray[10] = new MBeanAttributeInfo("MsgBytesIn", clazz7.getName(), mbr.getString("MB1100"), true, false, false);
        Class clazz8 = Long.class;
        mBeanAttributeInfoArray[11] = new MBeanAttributeInfo("MsgBytesOut", clazz8.getName(), mbr.getString("MB1101"), true, false, false);
        Class clazz9 = String.class;
        mBeanAttributeInfoArray[12] = new MBeanAttributeInfo("Name", clazz9.getName(), mbr.getString("MB1087"), true, false, false);
        Class clazz10 = Integer.class;
        mBeanAttributeInfoArray[13] = new MBeanAttributeInfo("NumActiveConsumers", clazz10.getName(), mbr.getString("MB1102"), true, false, false);
        Class clazz11 = Integer.class;
        mBeanAttributeInfoArray[14] = new MBeanAttributeInfo("NumBackupConsumers", clazz11.getName(), mbr.getString("MB1103"), true, false, false);
        Class clazz12 = Integer.class;
        mBeanAttributeInfoArray[15] = new MBeanAttributeInfo("NumConsumers", clazz12.getName(), mbr.getString("MB1104"), true, false, false);
        Class clazz13 = Long.class;
        mBeanAttributeInfoArray[16] = new MBeanAttributeInfo("NumMsgs", clazz13.getName(), mbr.getString("MB1105"), true, false, false);
        Class clazz14 = Long.class;
        mBeanAttributeInfoArray[17] = new MBeanAttributeInfo("NumMsgsHeldInTransaction", clazz14.getName(), mbr.getString("MB1106"), true, false, false);
        Class clazz15 = Long.class;
        mBeanAttributeInfoArray[18] = new MBeanAttributeInfo("NumMsgsIn", clazz15.getName(), mbr.getString("MB1107"), true, false, false);
        Class clazz16 = Long.class;
        mBeanAttributeInfoArray[19] = new MBeanAttributeInfo("NumMsgsOut", clazz16.getName(), mbr.getString("MB1108"), true, false, false);
        Class clazz17 = Long.class;
        mBeanAttributeInfoArray[20] = new MBeanAttributeInfo("NumMsgsPendingAcks", clazz17.getName(), mbr.getString("MB1109"), true, false, false);
        Class clazz18 = Integer.class;
        mBeanAttributeInfoArray[21] = new MBeanAttributeInfo("NumProducers", clazz18.getName(), mbr.getString("MB1110"), true, false, false);
        Class clazz19 = Long.class;
        mBeanAttributeInfoArray[22] = new MBeanAttributeInfo("PeakMsgBytes", clazz19.getName(), mbr.getString("MB1111"), true, false, false);
        Class clazz20 = Integer.class;
        mBeanAttributeInfoArray[23] = new MBeanAttributeInfo("PeakNumActiveConsumers", clazz20.getName(), mbr.getString("MB1112"), true, false, false);
        Class clazz21 = Integer.class;
        mBeanAttributeInfoArray[24] = new MBeanAttributeInfo("PeakNumBackupConsumers", clazz21.getName(), mbr.getString("MB1113"), true, false, false);
        Class clazz22 = Integer.class;
        mBeanAttributeInfoArray[25] = new MBeanAttributeInfo("PeakNumConsumers", clazz22.getName(), mbr.getString("MB1114"), true, false, false);
        Class clazz23 = Long.class;
        mBeanAttributeInfoArray[26] = new MBeanAttributeInfo("PeakNumMsgs", clazz23.getName(), mbr.getString("MB1115"), true, false, false);
        Class clazz24 = Long.class;
        mBeanAttributeInfoArray[27] = new MBeanAttributeInfo("PeakTotalMsgBytes", clazz24.getName(), mbr.getString("MB1116"), true, false, false);
        Class clazz25 = Integer.class;
        mBeanAttributeInfoArray[28] = new MBeanAttributeInfo("State", clazz25.getName(), mbr.getString("MB1117"), true, false, false);
        Class clazz26 = String.class;
        mBeanAttributeInfoArray[29] = new MBeanAttributeInfo("StateLabel", clazz26.getName(), mbr.getString("MB1118"), true, false, false);
        Class clazz27 = Boolean.class;
        mBeanAttributeInfoArray[30] = new MBeanAttributeInfo("Temporary", clazz27.getName(), mbr.getString("MB1119"), true, false, true);
        Class clazz28 = Long.class;
        mBeanAttributeInfoArray[31] = new MBeanAttributeInfo("TotalMsgBytes", clazz28.getName(), mbr.getString("MB1120"), true, false, false);
        Class clazz29 = Long.class;
        mBeanAttributeInfoArray[32] = new MBeanAttributeInfo("TotalMsgBytesHeldInTransaction", clazz29.getName(), mbr.getString("MB1121"), true, false, false);
        Class clazz30 = String.class;
        mBeanAttributeInfoArray[33] = new MBeanAttributeInfo("Type", clazz30.getName(), mbr.getString("MB1088"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[5];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getActiveConsumerIDs", mbr.getString("MB1128"), null, String;.class.getName(), 0);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("getBackupConsumerIDs", mbr.getString("MB1129"), null, String;.class.getName(), 0);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("getConnection", mbr.getString("MB1130"), null, ObjectName.class.getName(), 0);
        mBeanOperationInfoArray[3] = new MBeanOperationInfo("getConsumerIDs", mbr.getString("MB1131"), null, String;.class.getName(), 0);
        mBeanOperationInfoArray[4] = new MBeanOperationInfo("getProducerIDs", mbr.getString("MB1132"), null, String;.class.getName(), 0);
        ops = mBeanOperationInfoArray;
        dstNotificationTypes = new String[]{"mq.destination.compact", "mq.destination.pause", "mq.destination.purge", "mq.destination.resume"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(dstNotificationTypes, DestinationNotification.class.getName(), mbr.getString("MB1133"));
        notifs = mBeanNotificationInfoArray;
    }
}

