/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.PortMapperEntry;
import com.sun.messaging.jmq.io.PortMapperTable;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterBrokerInfoReply;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerAddressImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerLinkWriter;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerListLock;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.ClusterImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.DefaultTrustManager;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.LinkInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.Packet;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class BrokerLink
extends Thread {
    public static boolean DEBUG;
    private boolean connected = false;
    private boolean expectBrokerInfoPkt = true;
    private boolean expectBrokerInfoReplyPkt = false;
    private Socket conn = null;
    private InputStream is = null;
    private OutputStream os = null;
    private BrokerLinkWriter writer = null;
    private Packet linkInitPkt;
    private BrokerAddressImpl self;
    private BrokerAddressImpl remote;
    private ClusterImpl parent = null;
    private boolean linkInitDone = false;
    private Object linkInitWaitObject = null;
    private boolean autoConnect = false;
    private BrokerListLock brokerListLock = new BrokerListLock();
    private static boolean DEBUG_CLUSTER_PACKET;
    private static boolean DEBUG_CLUSTER_ALL;
    private static boolean DEBUG_CLUSTER_CONN;
    private static Logger logger;
    private static final BrokerResources br;
    private long createLinkFailures = 0L;
    private static Hashtable waitingMasterLogs;
    private boolean readActive = true;
    private SSLSocketFactory factory = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BrokerLink(BrokerAddressImpl brokerAddressImpl, BrokerAddressImpl brokerAddressImpl2, ClusterImpl clusterImpl) {
        this.self = brokerAddressImpl;
        this.remote = brokerAddressImpl2;
        this.setName("BrokerLink:" + brokerAddressImpl2);
        this.parent = clusterImpl;
        this.linkInitDone = false;
        this.linkInitWaitObject = new Object();
        this.setDaemon(true);
    }

    public void setAutoConnect(boolean bl) {
        this.autoConnect = bl;
    }

    public boolean getAutoConnect() {
        return this.autoConnect;
    }

    private void setRemote(BrokerAddressImpl brokerAddressImpl) {
        this.remote = brokerAddressImpl;
        this.setName("BrokerLink:" + brokerAddressImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitLinkInit() {
        if (DEBUG) {
            logger.log(4, "BrokerLink.waitLinkInit : " + this);
        }
        Object object = this.linkInitWaitObject;
        synchronized (object) {
            while (!this.linkInitDone) {
                try {
                    logger.log(8, "B1150", this.remote.toString());
                    this.linkInitWaitObject.wait(60000L);
                }
                catch (Exception exception) {}
            }
        }
        if (DEBUG) {
            logger.log(4, "Returning from BrokerLink.waitLinkInit : " + this);
        }
    }

    public synchronized void setFlowControl(boolean bl) {
        if (this.writer == null) {
            return;
        }
        this.writer.setFlowControl(bl);
    }

    public synchronized void sendPacket(GPacket gPacket) throws IOException {
        this.sendPacket(gPacket, false);
    }

    public synchronized void sendPacket(GPacket gPacket, boolean bl) throws IOException {
        if (DEBUG) {
            logger.log(4, "BrokerLink.sendPacket(GPacket)");
        }
        if (this.writer == null) {
            throw new IOException("Packet send failed. Broker unreachable : " + this.remote);
        }
        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_PACKET) {
            logger.log(4, "SENDING PACKET :\n" + gPacket.toLongString());
            if (gPacket.getPayload() != null) {
                byte[] byArray = gPacket.getPayload().array();
                logger.log(4, "Payload : " + Packet.hexdump(byArray, Integer.MAX_VALUE));
            }
        }
        this.writer.sendPacket(gPacket, bl);
    }

    public synchronized void sendPacket(Packet packet) throws IOException {
        this.sendPacket(packet, false);
    }

    public synchronized void sendPacket(Packet packet, boolean bl) throws IOException {
        if (DEBUG) {
            logger.log(4, "BrokerLink.sendPacket(Packet)");
        }
        if (this.writer == null) {
            throw new IOException("Packet send failed. Broker unreachable : " + this.remote);
        }
        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_PACKET) {
            logger.log(4, "SENDING PACKET :\nLink = " + this + "\n" + "Packet = " + packet + "\n");
        }
        this.writer.sendPacket(packet, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void linkDown() {
        if (DEBUG) {
            logger.log(4, "BrokerLink.linkDown()");
        }
        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_CONN) {
            logger.log(8, "Link down\n\tRemote BrokerAddress = " + this.remote + "\n\tRemote IP = " + this.conn.getInetAddress() + "\n\tRemote Port = " + this.conn.getPort() + "\n\tLocal IP = " + this.conn.getLocalAddress() + "\n\tLocal Port = " + this.conn.getLocalPort());
        }
        if (DEBUG) {
            logger.log(2, "Cluster connection closed.");
        }
        this.brokerListLock.lock();
        try {
            BrokerLink brokerLink = this;
            synchronized (brokerLink) {
                block17: {
                    if (this.writer != null) break block17;
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.connected = false;
                    return;
                }
                this.writer.shutdown();
                this.writer = null;
                try {
                    this.is.close();
                    this.os.close();
                    this.conn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.connected = false;
                this.is = null;
                this.os = null;
            }
            this.parent.removeBroker(this.remote, this);
        }
        finally {
            this.brokerListLock.unlock();
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized SSLSocketFactory getTrustSocketFactory() throws Exception {
        if (this.factory == null) {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            TrustManager[] trustManagerArray = new TrustManager[]{new DefaultTrustManager()};
            sSLContext.init(null, trustManagerArray, null);
            this.factory = sSLContext.getSocketFactory();
        }
        return this.factory;
    }

    private Socket makeSSLSocket(InetAddress inetAddress, int n) throws Exception {
        if (Globals.getConfig().getBooleanProperty("imq.cluster.trust_all", true)) {
            SSLSocketFactory sSLSocketFactory = this.getTrustSocketFactory();
            return sSLSocketFactory.createSocket(inetAddress, n);
        }
        return SSLSocketFactory.getDefault().createSocket(inetAddress, n);
    }

    private PortMapperEntry getRealRemotePort() throws Exception {
        String string = String.valueOf(101) + "\n";
        PortMapperTable portMapperTable = new PortMapperTable();
        Socket socket = new Socket(this.remote.getHost(), this.remote.getPort());
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        try {
            outputStream.write(string.getBytes());
            outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        portMapperTable.read(inputStream);
        inputStream.close();
        outputStream.close();
        socket.close();
        return portMapperTable.get("cluster");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void createLink() {
        BrokerAddressImpl brokerAddressImpl;
        block25: {
            if (DEBUG) {
                logger.log(4, "BrokerLink.createLink()");
            }
            this.brokerListLock.lock();
            brokerAddressImpl = null;
            BrokerLink brokerLink = this;
            // MONITORENTER : brokerLink
            if (!this.autoConnect) {
                // MONITOREXIT : brokerLink
                this.brokerListLock.unlock();
                return;
            }
            if (!this.connected) break block25;
            this.brokerListLock.unlock();
            return;
        }
        try {
            try {
                PortMapperEntry portMapperEntry = this.getRealRemotePort();
                if (portMapperEntry == null) {
                    throw new BrokerException(br.getKString("B4256", this.remote));
                }
                int n = portMapperEntry.getPort();
                if (!portMapperEntry.getProtocol().equalsIgnoreCase(this.parent.getTransport())) {
                    throw new BrokerException(br.getKString("B4208", this.parent.getTransport(), portMapperEntry.getProtocol()));
                }
                this.conn = portMapperEntry.getProtocol().equalsIgnoreCase("ssl") ? this.makeSSLSocket(this.remote.getHost(), n) : new Socket(this.remote.getHost(), n);
                this.initNewConn(false);
                this.connected = true;
                brokerAddressImpl = BrokerLink.consumeLinkInit(this.conn, this, this.parent);
            }
            catch (Exception exception) {
                Object object;
                if (!this.connected) {
                    if (this.conn != null) {
                        try {
                            this.conn.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    if (this.writer != null) {
                        this.writer.shutdown();
                        this.writer = null;
                    }
                }
                if (this.createLinkFailures % 40L == 0L) {
                    object = exception.getMessage();
                    if (object == null) {
                        object = exception.getClass().getName();
                    }
                    logger.log(16, "B2105", (Object)this.remote.toString(), object);
                    logger.logStack(4, "BrokerLink.createLink() failed", exception);
                }
                ++this.createLinkFailures;
                object = this.linkInitWaitObject;
                // MONITORENTER : object
                if (!this.linkInitDone) {
                    this.linkInitDone = true;
                    this.linkInitWaitObject.notifyAll();
                }
                // MONITOREXIT : object
            }
            if (brokerAddressImpl != null && !this.parent.addBroker(this.remote, this)) {
                this.closeConn();
            }
        }
        finally {
            this.brokerListLock.unlock();
        }
        if (!DEBUG) return;
        logger.log(4, "BrokerLink.createLink() finished.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static BrokerAddressImpl consumeLinkInit(Socket socket, BrokerLink brokerLink, ClusterImpl clusterImpl) throws IOException {
        if (DEBUG) {
            logger.log(4, "BrokerLink.consumeLinkInit()");
        }
        BrokerAddressImpl brokerAddressImpl = null;
        InputStream inputStream = socket.getInputStream();
        Packet packet = new Packet();
        packet.readPacket(inputStream);
        if (packet.getPacketType() != 4) {
            logger.log(4, (brokerLink == null ? "Socket=" + socket.getInetAddress() : "Link=" + brokerLink) + ", expect LINK_INIT but got:" + packet.getPacketType());
            socket.close();
            return null;
        }
        LinkInfo linkInfo = null;
        try {
            linkInfo = ClusterImpl.processLinkInit(packet);
        }
        catch (BrokerException brokerException) {
            logger.log(32, br.getKString("B3195", socket.getInetAddress().toString()), brokerException);
            if (brokerLink == null) {
                socket.close();
            } else {
                brokerLink.shutdown();
            }
            return null;
        }
        catch (Exception exception) {
            socket.close();
            return null;
        }
        if (DEBUG) {
            logger.log(4, "processLinkInit returned!");
        }
        brokerAddressImpl = linkInfo.getAddress();
        if (brokerLink != null) {
            brokerLink.setRemote(brokerAddressImpl);
        }
        if (!clusterImpl.checkConfigServer(brokerAddressImpl)) {
            BrokerAddressImpl brokerAddressImpl2 = (BrokerAddressImpl)clusterImpl.getConfiguredConfigServer();
            if (brokerAddressImpl2 != null) {
                Integer n = (Integer)waitingMasterLogs.get(brokerAddressImpl.getMQAddress());
                if (n == null || n % 30 == 0) {
                    logger.log(8, "B1251", (Object)brokerAddressImpl, brokerAddressImpl2);
                } else {
                    logger.log(4, "B1251", (Object)brokerAddressImpl, brokerAddressImpl2);
                }
                Hashtable hashtable = waitingMasterLogs;
                synchronized (hashtable) {
                    Integer n2 = (Integer)waitingMasterLogs.get(brokerAddressImpl.getMQAddress());
                    if (n2 == null) {
                        waitingMasterLogs.put(brokerAddressImpl.getMQAddress(), new Integer(1));
                    } else {
                        waitingMasterLogs.put(brokerAddressImpl.getMQAddress(), new Integer(n2 + 1));
                    }
                }
            } else {
                logger.log(32, "B3100", "No master broker. Closing cluster connection with " + brokerAddressImpl);
            }
            socket.close();
            return null;
        }
        try {
            if ((clusterImpl.getConfigServer() == null || linkInfo.getConfigServer() == null) && clusterImpl.getConfigServer() != linkInfo.getConfigServer() || clusterImpl.getConfigServer() != null && linkInfo.getConfigServer() != null && !clusterImpl.getConfigServer().getMQAddress().equals(linkInfo.getConfigServer().getMQAddress())) {
                logger.log(32, "B3097", brokerAddressImpl);
                if (brokerLink == null) {
                    socket.close();
                } else {
                    brokerLink.shutdown();
                }
                return null;
            }
        }
        catch (Exception exception) {
            logger.logStack(4, exception.getMessage() + (brokerLink == null ? "Socket " + socket.getInetAddress() : "Link " + brokerLink), exception);
            if (brokerLink == null) {
                socket.close();
            } else {
                brokerLink.linkDown();
            }
            return null;
        }
        if (DEBUG) {
            logger.log(2, "remote.matchProps = " + linkInfo.getMatchProps());
            logger.log(2, "local.matchProps = " + clusterImpl.getMatchProps());
        }
        Properties properties = linkInfo.getMatchProps();
        Properties properties2 = clusterImpl.getMatchProps();
        String string = BrokerLink.compareProps(properties2, properties);
        if (string != null) {
            logger.log(32, "B3098", (Object)brokerAddressImpl, string);
            if (brokerLink == null) {
                socket.close();
            } else {
                brokerLink.shutdown();
            }
            return null;
        }
        if (DEBUG) {
            logger.log(4, "BrokerLink.consumeLinkInit() finished");
        }
        if (!$assertionsDisabled && brokerAddressImpl == null) {
            throw new AssertionError();
        }
        return brokerAddressImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean acceptConnection(BrokerAddressImpl brokerAddressImpl, Socket socket) {
        block18: {
            if (DEBUG) {
                logger.log(4, "BrokerLink.acceptConnection()");
            }
            this.brokerListLock.lock();
            BrokerLink brokerLink = this;
            // MONITORENTER : brokerLink
            this.setRemote(brokerAddressImpl);
            if (this.connected) {
                if (DEBUG) {
                    logger.log(4, "Already connected!");
                }
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean bl = false;
                // MONITOREXIT : brokerLink
                this.brokerListLock.unlock();
                return bl;
            }
            if (this.parent.addBroker(brokerAddressImpl, this)) break block18;
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = false;
            // MONITOREXIT : brokerLink
            this.brokerListLock.unlock();
            return bl;
        }
        this.conn = socket;
        try {
            this.initNewConn(true);
        }
        catch (Exception exception) {
            boolean bl = true;
            // MONITOREXIT : brokerLink
            this.brokerListLock.unlock();
            return bl;
        }
        try {
            this.connected = true;
            // MONITOREXIT : brokerLink
            return true;
        }
        finally {
            this.brokerListLock.unlock();
        }
    }

    private void initNewConn(boolean bl) throws IOException {
        Object object;
        if (DEBUG) {
            logger.log(4, "BrokerLink.initNewconn()");
        }
        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_CONN) {
            object = bl ? "Accepted" : "Established";
            logger.log(8, "Connection " + (String)object + "\n\tRemote BrokerAddress = " + this.remote + "\n\tRemote IP = " + this.conn.getInetAddress() + "\n\tRemote Port = " + this.conn.getPort() + "\n\tLocal IP = " + this.conn.getLocalAddress() + "\n\tLocal Port = " + this.conn.getLocalPort());
        }
        this.expectBrokerInfoPkt = true;
        this.is = this.conn.getInputStream();
        this.os = this.conn.getOutputStream();
        this.writer = new BrokerLinkWriter(this.remote, this);
        this.writer.startWriterThread(this.os);
        if (this.linkInitPkt == null) {
            this.linkInitPkt = this.parent.getLinkInitPkt();
        }
        object = this.parent.getBrokerInfoPkt();
        if (DEBUG) {
            logger.log(2, "Cluster connection established: {0}", this);
        }
        this.sendPacket(this.linkInitPkt);
        this.sendPacket((Packet)object);
        this.parent.sendFlowControlUpdate(this.remote);
    }

    public void closeConn() {
        this.closeConn(false);
    }

    public void closeConn(boolean bl) {
        this.closeConn(false, bl);
    }

    protected void closeConn(boolean bl, boolean bl2) {
        if (DEBUG) {
            logger.log(4, "BrokerLink.closeConn()");
        }
        if (!this.connected && !this.autoConnect) {
            try {
                this.interrupt();
            }
            catch (Exception exception) {
                logger.log(4, "BrokerLink.closeConn(): interrupt thread failed: " + exception.getMessage());
            }
        }
        try {
            if (bl) {
                this.conn.shutdownOutput();
                return;
            }
            if (bl2) {
                this.conn.close();
                return;
            }
            if (!this.writer.isOutputShutdown()) {
                this.conn.close();
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean isOutputShutdown() {
        if (this.conn == null) {
            return false;
        }
        return this.conn.isOutputShutdown();
    }

    public void shutdown() {
        if (DEBUG) {
            logger.log(4, "BrokerLink.shutdown()");
        }
        this.autoConnect = false;
        this.closeConn();
    }

    private static String compareProps(Properties properties, Properties properties2) {
        String string = null;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            String string4 = properties2.getProperty(string2);
            if (string3 == null && string4 == null) continue;
            if (string3 == null && string4 != null || string4 == null && string3 != null) {
                string = string + "\t" + string2;
                continue;
            }
            if (string3.equals(string4)) continue;
            if (string == null) {
                string = "\t" + string2 + "\n";
                continue;
            }
            string = string + "\t" + string2 + "\n";
        }
        return string;
    }

    private Packet tryReadPacket(boolean bl) throws IOException {
        if (DEBUG) {
            logger.log(4, "BrokerLink.tryReadPacket()");
        }
        Packet packet = null;
        try {
            packet = new Packet();
            packet.readPacket(this.is);
            this.readActive = true;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (!bl) {
                throw outOfMemoryError;
            }
            Globals.handleGlobalError(outOfMemoryError, br.getKString("B0019"));
            packet = this.tryReadPacket(false);
        }
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeBrokerInfoPkt() throws Exception {
        Object object;
        if (DEBUG) {
            logger.log(4, "BrokerLink.consumeBrokerInfoPkt()");
        }
        this.expectBrokerInfoReplyPkt = false;
        Packet packet = new Packet();
        packet.readPacket(this.is);
        if (packet.getPacketType() != 3) {
            logger.log(4, "Link = " + this + ", Missed BROKER_INFO : " + packet.getPacketType());
            this.conn.close();
            return;
        }
        BrokerInfo brokerInfo = (BrokerInfo)this.parent.receivePacket(this.remote, packet);
        if (brokerInfo == null) {
            logger.log(4, "Link = " + this + ", BROKER_INFO rejected");
            throw new IOException("BrokerInfo rejected");
        }
        this.expectBrokerInfoPkt = false;
        Integer n = brokerInfo.getClusterProtocolVersion();
        if (n != null && n >= 400) {
            object = this.parent.getBrokerInfoReply(brokerInfo);
            GPacket gPacket = ((ClusterBrokerInfoReply)object).getGPacket();
            boolean bl = ((ClusterBrokerInfoReply)object).sendAndClose();
            this.sendPacket(gPacket, bl);
            this.expectBrokerInfoReplyPkt = true;
            if (bl) {
                return;
            }
        }
        object = this.linkInitWaitObject;
        synchronized (object) {
            if (this.parent.isConfigServerResolved()) {
                this.linkInitDone = true;
                this.linkInitWaitObject.notify();
            }
        }
    }

    private void consumeBrokerInfoReplyPkt() throws Exception {
        if (DEBUG) {
            logger.log(4, "BrokerLink.consumeBrokerInfoReplyPkt()");
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.read(this.is);
        if (gPacket.getType() != 46) {
            logger.log(4, "Link = " + this + ", Missed BROKER_INFO_REPLY : " + gPacket.getType());
            this.conn.close();
            return;
        }
        this.parent.receivePacket(this.remote, gPacket);
    }

    private void consumePacket() throws IOException {
        if (DEBUG) {
            logger.log(4, "BrokerLink.consumePacket()");
        }
        Packet packet = new Packet();
        try {
            packet = this.tryReadPacket(true);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.log(32, "B3108");
            Broker.getBroker().exit(Globals.getBrokerStateHandler().getRestartCode(), br.getString("B3108"), 3);
        }
        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_PACKET) {
            logger.log(4, "RECEIVING PACKET :\nLink = " + this + "\n" + "Packet = " + packet);
        }
        try {
            this.parent.receivePacket(this.remote, packet);
        }
        catch (Exception exception) {
            logger.logStack(32, "B2036", packet, (Throwable)exception);
        }
    }

    private void consumeGPacket() throws IOException {
        if (DEBUG) {
            logger.log(4, "BrokerLink.consumeGPacket()");
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.read(this.is);
        this.readActive = true;
        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_PACKET) {
            logger.log(4, "RECEIVING PACKET :\nLink = " + this + "\n" + "Packet = " + gPacket.toLongString());
            if (gPacket.getPayload() != null) {
                byte[] byArray = gPacket.getPayload().array();
                logger.log(4, "Payload : " + Packet.hexdump(byArray, Integer.MAX_VALUE));
            }
        }
        try {
            this.parent.receivePacket(this.remote, gPacket);
        }
        catch (Exception exception) {
            logger.logStack(32, "B2036", gPacket, (Throwable)exception);
        }
    }

    protected boolean isIOActive() {
        boolean bl = false;
        try {
            if (this.writer != null) {
                bl = this.writer.isWriteActive();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.readActive || bl;
    }

    protected void clearIOActiveFlag() {
        this.readActive = false;
        try {
            if (this.writer != null) {
                this.writer.clearWriteActiveFlag();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            if (!this.connected) {
                if (!this.autoConnect) break;
                this.createLink();
                if (this.connected) continue;
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {}
                continue;
            }
            try {
                if (this.expectBrokerInfoPkt) {
                    if (DEBUG) {
                        logger.log(4, "Waiting for BROKER_INFO...");
                    }
                    this.consumeBrokerInfoPkt();
                    if (this.expectBrokerInfoReplyPkt) {
                        this.consumeBrokerInfoReplyPkt();
                    }
                    if (DEBUG) {
                        logger.log(4, "Received BROKER_INFO...");
                    }
                }
                if (this.parent.useGPackets) {
                    this.consumeGPacket();
                    continue;
                }
                this.consumePacket();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                logger.log(32, "B3108");
                Broker.getBroker().exit(Globals.getBrokerStateHandler().getRestartCode(), br.getString("B3108"), 3);
            }
            catch (Exception exception) {
                logger.logStack(4, "Link Down " + this, exception);
                this.linkDown();
            }
        }
        Object object = this.linkInitWaitObject;
        synchronized (object) {
            this.linkInitDone = true;
            this.linkInitWaitObject.notify();
        }
        this.parent.handleBrokerLinkShutdown(this.remote);
    }

    public String toString() {
        return this.self.toString() + " <---> " + this.remote.toString();
    }

    static {
        $assertionsDisabled = !BrokerLink.class.desiredAssertionStatus();
        DEBUG = false;
        DEBUG_CLUSTER_PACKET = Globals.getConfig().getBooleanProperty("imq.cluster.debug.packet");
        DEBUG_CLUSTER_ALL = Globals.getConfig().getBooleanProperty("imq.cluster.debug.all");
        DEBUG_CLUSTER_CONN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.conn");
        logger = Globals.getLogger();
        br = Globals.getBrokerResources();
        waitingMasterLogs = new Hashtable();
    }
}

