/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterConsumerInfo;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ClusterMessageAckInfo {
    protected Logger logger = Globals.getLogger();
    private SysMessageID sysid = null;
    private ConsumerUID intid = null;
    private int ackType;
    private Long ackackXid = null;
    private Map optionalProps = null;
    private Long transactionID = null;
    private BrokerAddress msgHome;
    private Cluster c = null;
    private GPacket pkt = null;
    private DataInputStream dis = null;
    private static FaultInjection fi;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ClusterMessageAckInfo(SysMessageID sysMessageID, ConsumerUID consumerUID, int n, Long l, Map map, Long l2, BrokerAddress brokerAddress, Cluster cluster) {
        this.sysid = sysMessageID;
        this.intid = consumerUID;
        this.ackType = n;
        this.ackackXid = l;
        this.optionalProps = map;
        this.transactionID = l2;
        this.msgHome = brokerAddress;
        this.c = cluster;
    }

    private ClusterMessageAckInfo(GPacket gPacket, Cluster cluster) {
        this.pkt = gPacket;
        this.c = cluster;
    }

    private ClusterMessageAckInfo(GPacket gPacket) {
        this.pkt = gPacket;
        this.c = null;
    }

    public static ClusterMessageAckInfo newInstance(SysMessageID sysMessageID, ConsumerUID consumerUID, int n, Long l, Map map, Long l2, BrokerAddress brokerAddress, Cluster cluster) {
        return new ClusterMessageAckInfo(sysMessageID, consumerUID, n, l, map, l2, brokerAddress, cluster);
    }

    public static ClusterMessageAckInfo newInstance(GPacket gPacket, Cluster cluster) {
        return new ClusterMessageAckInfo(gPacket, cluster);
    }

    public GPacket getGPacket() throws IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream;
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)3);
        gPacket.putProp("T", new Integer(this.ackType));
        this.c.marshalBrokerAddress(this.c.getSelfAddress(), gPacket);
        gPacket.putProp("messageBrokerSession", new Long(this.msgHome.getBrokerSessionUID().longValue()));
        if (this.msgHome.getHAEnabled()) {
            gPacket.putProp("messageStoreSession", new Long(this.msgHome.getStoreSessionUID().longValue()));
        }
        if (this.optionalProps != null) {
            byteArrayOutputStream = null;
            object = this.optionalProps.keySet().iterator();
            while (object.hasNext()) {
                byteArrayOutputStream = (ByteArrayOutputStream)object.next();
                gPacket.putProp(byteArrayOutputStream, this.optionalProps.get(byteArrayOutputStream));
            }
        }
        if (this.transactionID != null) {
            gPacket.putProp("transactionID", this.transactionID);
        }
        if (this.ackackXid != null) {
            gPacket.setBit(1, true);
            gPacket.putProp("X", this.ackackXid);
        }
        if (this.ackType == 7 || this.ackType == 8 || this.ackType == 3 && this.transactionID != null) {
            return gPacket;
        }
        byteArrayOutputStream = new ByteArrayOutputStream();
        object = new DataOutputStream(byteArrayOutputStream);
        this.sysid.writeID((DataOutput)object);
        ClusterConsumerInfo.writeConsumerUID(this.intid, (DataOutputStream)object);
        ((DataOutputStream)object).flush();
        byteArrayOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        gPacket.setPayload(ByteBuffer.wrap(byArray));
        return gPacket;
    }

    public int getAckType() {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        return (Integer)this.pkt.getProp("T");
    }

    public Map getOptionalProps() {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        Set set = this.pkt.propsKeySet();
        if (set == null || set.size() == 0) {
            return null;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Object k = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            k = iterator.next();
            hashMap.put(k, this.pkt.getProp(k));
        }
        return hashMap;
    }

    public UID getMessageStoreSessionUID() {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        Long l = (Long)this.pkt.getProp("messageStoreSession");
        if (l == null) {
            return null;
        }
        return new UID(l);
    }

    public UID getMessageBrokerSessionUID() {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        Long l = (Long)this.pkt.getProp("messageBrokerSession");
        if (l == null) {
            return null;
        }
        return new UID(l);
    }

    public Long getTransactionID() {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        return (Long)this.pkt.getProp("transactionID");
    }

    public void initPayloadRead() {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        byte[] byArray = this.pkt.getPayload().array();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.dis = new DataInputStream(byteArrayInputStream);
    }

    public SysMessageID readPayloadSysMessageID() throws IOException {
        if (!$assertionsDisabled && this.dis == null) {
            throw new AssertionError();
        }
        SysMessageID sysMessageID = new SysMessageID();
        sysMessageID.readID(this.dis);
        return sysMessageID;
    }

    public ConsumerUID readPayloadConsumerUID() throws Exception {
        BrokerAddress brokerAddress;
        if (!$assertionsDisabled && this.dis == null) {
            throw new AssertionError();
        }
        ConsumerUID consumerUID = ClusterConsumerInfo.readConsumerUID(this.dis);
        if (this.c != null && (brokerAddress = this.c.unmarshalBrokerAddress(this.pkt)) != null) {
            consumerUID.setBrokerAddress(brokerAddress);
        }
        return consumerUID;
    }

    public void initToString(SysMessageID sysMessageID, ConsumerUID consumerUID) {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        this.sysid = sysMessageID;
        this.intid = consumerUID;
    }

    public boolean needReply() {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        return this.pkt.getBit(1);
    }

    public GPacket getReplyGPacket(int n, String string) {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)4);
        gPacket.putProp("X", (Long)this.pkt.getProp("X"));
        gPacket.putProp("T", new Integer(this.getAckType()));
        if (this.pkt.getProp("messageBrokerSession") != null) {
            gPacket.putProp("messageBrokerSession", this.pkt.getProp("messageBrokerSession"));
        }
        if (this.pkt.getProp("messageStoreSession") != null) {
            gPacket.putProp("messageStoreSession", this.pkt.getProp("messageStoreSession"));
        }
        if (this.pkt.getProp("transactionID") != null) {
            gPacket.putProp("transactionID", this.pkt.getProp("transactionID"));
        }
        gPacket.putProp("S", new Integer(n));
        if (string != null) {
            gPacket.putProp("reason", string);
        }
        if (this.pkt.getPayload() != null) {
            gPacket.setPayload(ByteBuffer.wrap(this.pkt.getPayload().array()));
        }
        return gPacket;
    }

    public String toString() {
        if (this.pkt == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n\tAckType = ").append(this.ackType);
            stringBuffer.append("\n\tMessageBrokerSession = ").append(this.msgHome.getBrokerSessionUID().longValue());
            if (this.msgHome.getHAEnabled()) {
                stringBuffer.append("\n\tMessageStoreSession = ").append(this.msgHome.getStoreSessionUID().longValue());
            }
            if (this.transactionID != null) {
                stringBuffer.append("\n\tTransactionID = ").append(this.transactionID);
            }
            if (this.ackackXid != null) {
                stringBuffer.append("\n\tAckAck = ").append("true");
            }
            stringBuffer.append("\n\tMessage Home = ").append(this.msgHome);
            if (this.sysid != null) {
                stringBuffer.append("\n\tSysMessageID = ").append(this.sysid);
            }
            if (this.intid != null) {
                stringBuffer.append("\n\tConsumerUID = ").append(this.intid);
            }
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\tAckType = ").append(this.getAckType());
        if (this.getMessageBrokerSessionUID() != null) {
            stringBuffer.append("\n\tMessageBrokerSession = ").append(this.getMessageBrokerSessionUID().longValue());
        }
        if (this.getMessageStoreSessionUID() != null) {
            stringBuffer.append("\n\tMessageStoreSession = ").append(this.getMessageStoreSessionUID().longValue());
        }
        if (this.getTransactionID() != null) {
            stringBuffer.append("\n\tTransactionID = ").append(this.getTransactionID());
        }
        if (this.sysid != null) {
            stringBuffer.append("\n\tSysMessageID = ").append(this.sysid);
        }
        if (this.intid != null) {
            stringBuffer.append("\n\tConsumerUID = ").append(this.intid);
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static Long getAckAckXid(GPacket gPacket) {
        return (Long)gPacket.getProp("X");
    }

    public static Integer getAckAckType(GPacket gPacket) {
        return (Integer)gPacket.getProp("T");
    }

    public static int getAckAckStatus(GPacket gPacket) {
        return (Integer)gPacket.getProp("S");
    }

    public static String getAckAckStatusReason(GPacket gPacket) {
        return (String)gPacket.getProp("reason");
    }

    public static String toString(GPacket gPacket) {
        int n = ClusterMessageAckInfo.getAckAckType(gPacket);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\tackStatus = ").append(Status.getString(ClusterMessageAckInfo.getAckAckStatus(gPacket)));
        if (gPacket.getProp("reason") != null) {
            stringBuffer.append("\n\tReason = ").append(ClusterMessageAckInfo.getAckAckStatusReason(gPacket));
        }
        stringBuffer.append("\n\tAckType = ").append(n);
        if (gPacket.getProp("messageBrokerSession") != null) {
            stringBuffer.append("\n\tMessageBrokerSession = ").append(gPacket.getProp("messageBrokerSession"));
        }
        if (gPacket.getProp("messageStoreSession") != null) {
            stringBuffer.append("\n\tMessageStoreSession = ").append(gPacket.getProp("messageStoreSession"));
        }
        if (gPacket.getProp("transactionID") != null) {
            stringBuffer.append("\n\tTransactionID = ").append(gPacket.getProp("transactionID"));
        }
        if (gPacket.getPayload() != null) {
            ClusterMessageAckInfo clusterMessageAckInfo = new ClusterMessageAckInfo(gPacket);
            try {
                clusterMessageAckInfo.initPayloadRead();
                stringBuffer.append("\n\tSysMessageID = ").append(clusterMessageAckInfo.readPayloadSysMessageID());
                stringBuffer.append("\n\tConsumerUID = ").append(clusterMessageAckInfo.readPayloadConsumerUID().longValue());
                stringBuffer.append("\n");
            }
            catch (Exception exception) {
                Globals.getLogger().logStack(16, exception.getMessage(), exception);
            }
        }
        return stringBuffer.toString();
    }

    private static String convertAckTypeToFaultString(int n, Long l) {
        switch (n) {
            case 3: {
                return l == null ? "" : FaultInjection.MSG_REMOTE_ACK_TXNCOMMIT;
            }
            case 6: {
                return FaultInjection.MSG_REMOTE_ACK_TXNACK;
            }
            case 7: {
                return FaultInjection.MSG_REMOTE_ACK_TXNPREPARE;
            }
            case 8: {
                return FaultInjection.MSG_REMOTE_ACK_TXNROLLBACK;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CHECKFAULT(HashMap hashMap, int n, Long l, String string, String string2) {
        int n2 = 0;
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        Integer n3 = new Integer(n);
        HashMap hashMap3 = hashMap;
        synchronized (hashMap3) {
            Integer n4 = (Integer)hashMap.get(n3);
            if (n4 != null) {
                n2 = n4;
            }
            if (string2.equals(FaultInjection.STAGE_1)) {
                hashMap.put(n3, new Integer(++n2));
            }
        }
        hashMap2.put(FaultInjection.MSG_ACKCOUNT_PROP, new Integer(n2));
        fi.checkFaultAndExit(string + ClusterMessageAckInfo.convertAckTypeToFaultString(n, l) + string2, null, 2, false);
    }

    static {
        $assertionsDisabled = !ClusterMessageAckInfo.class.desiredAssertionStatus();
        fi = FaultInjection.getInjection();
    }
}

