/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.service.imq.Operation;
import com.sun.messaging.jmq.jmsserver.util.pool.BasicRunnable;
import com.sun.messaging.jmq.jmsserver.util.pool.ThreadPool;
import com.sun.messaging.jmq.util.GoodbyeReason;
import java.io.EOFException;
import java.io.IOException;

public class OperationRunnable
extends BasicRunnable {
    public static final int FOREVER = -1;
    public static final int UNTIL_DONE = 0;
    Operation op = null;
    int opcnt = 0;
    int OperationCount = 0;
    protected int ioevents = 0;
    protected boolean wait = false;
    Object opUpdateLock = new Object();

    public OperationRunnable(int n, ThreadPool threadPool, boolean bl) {
        super(n, threadPool);
        this.wait = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.opUpdateLock;
        synchronized (object) {
            this.op = null;
        }
        this.release();
    }

    public void suspend() {
        super.suspend();
        if (this.op != null) {
            this.op.suspend();
        }
    }

    public void resume() {
        super.resume();
        if (this.op != null) {
            this.op.resume();
        }
    }

    public String toString() {
        return "OpRun[id =" + this.id + ", ioevents=" + this.ioevents + ", behavior=" + OperationRunnable.behaviorToString(this.behavior) + ", op={" + this.op + "}, state=" + this.stateToString(this.state) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignOperation(Operation operation, int n, int n2) throws IllegalAccessException {
        Object object = this.opUpdateLock;
        synchronized (object) {
            if (this.op != null) {
                throw new IllegalAccessException(Globals.getBrokerResources().getKString("B4117", "Error trying to assign " + operation + " to  assigned operation " + this));
            }
            this.op = operation;
            this.op.threadAssigned(this, n);
            this.OperationCount = n2;
            this.opcnt = 0;
            this.ioevents = n;
        }
        this.assigned();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeOperation() {
        Object object = this.opUpdateLock;
        synchronized (object) {
            if (this.op != null) {
                this.op.notifyRelease(this, this.ioevents);
                this.op = null;
            }
        }
        this.release();
    }

    public void destroy(String string) {
        if (this.op != null) {
            this.op.destroy(true, GoodbyeReason.OTHER, string);
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process() throws IOException {
        Operation operation = null;
        Object object = this.opUpdateLock;
        synchronized (object) {
            operation = this.op;
        }
        if (operation == null || this.state < 3) {
            return;
        }
        if (!operation.isValid()) {
            this.freeOperation();
            return;
        }
        if (this.state > 5) {
            if (operation != null) {
                if (operation.isValid()) {
                    operation.destroy(false, GoodbyeReason.CON_FATAL_ERROR, "invalid operation");
                }
                this.freeOperation();
            }
            throw new IOException(Globals.getBrokerResources().getKString("B4117", "Exiting"));
        }
        try {
            boolean bl = operation.process(this.ioevents, this.wait);
            switch (this.OperationCount) {
                case -1: {
                    return;
                }
                case 0: {
                    if (bl) {
                        this.freeOperation();
                    }
                    return;
                }
            }
            ++this.opcnt;
            if (this.opcnt >= this.OperationCount || bl) {
                this.freeOperation();
            }
            return;
        }
        catch (IOException iOException) {
            if (operation != null) {
                if (DEBUG) {
                    this.logger.logStack(4, "Debug: Connection going away", iOException);
                }
                if (iOException instanceof EOFException) {
                    operation.destroy(false, GoodbyeReason.CLIENT_CLOSED, Globals.getBrokerResources().getKString("B0061"));
                } else {
                    operation.destroy(false, GoodbyeReason.CON_FATAL_ERROR, iOException.toString());
                }
            }
            this.freeOperation();
            return;
        }
    }
}

