/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.JMQXid;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GetTransactionsHandler
extends AdminCmdHandler {
    TransactionList tl = null;

    public GetTransactionsHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
        this.tl = adminDataHandler.tl;
    }

    public static Hashtable getTransactionInfo(TransactionList transactionList, TransactionUID transactionUID) {
        TransactionState transactionState = transactionList.retrieveState(transactionUID);
        if (transactionState == null) {
            return null;
        }
        JMQXid jMQXid = transactionList.UIDToXid(transactionUID);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (jMQXid != null) {
            hashtable.put("xid", jMQXid.toString());
        }
        hashtable.put("txnid", new Long(transactionUID.longValue()));
        if (transactionState.getUser() != null) {
            hashtable.put("user", transactionState.getUser());
        }
        if (transactionState.getClientID() != null) {
            hashtable.put("clientid", transactionState.getClientID());
        }
        hashtable.put("timestamp", new Long(System.currentTimeMillis() - transactionUID.age()));
        hashtable.put("connection", transactionState.getConnectionString());
        hashtable.put("nmsgs", new Integer(transactionList.retrieveNSentMessages(transactionUID)));
        hashtable.put("nacks", new Integer(transactionList.retrieveNConsumedMessages(transactionUID)));
        hashtable.put("state", new Integer(transactionState.getState()));
        return hashtable;
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        Object object;
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + "Getting transactions " + hashtable);
        }
        int n = 200;
        String string = null;
        TransactionUID transactionUID = null;
        Long l = (Long)hashtable.get("JMQTransactionID");
        if (l != null) {
            transactionUID = new TransactionUID(l);
        }
        Hashtable hashtable2 = null;
        Vector<Hashtable> vector = new Vector<Hashtable>();
        if (transactionUID != null) {
            hashtable2 = GetTransactionsHandler.getTransactionInfo(this.tl, transactionUID);
            if (hashtable2 != null) {
                vector.add(hashtable2);
            }
        } else {
            object = this.tl.getTransactions(-1);
            if (object != null) {
                Enumeration enumeration = ((Vector)object).elements();
                while (enumeration.hasMoreElements()) {
                    transactionUID = (TransactionUID)enumeration.nextElement();
                    hashtable2 = GetTransactionsHandler.getTransactionInfo(this.tl, transactionUID);
                    if (hashtable2 == null) continue;
                    vector.add(hashtable2);
                }
            }
        }
        if (transactionUID != null && vector.size() == 0) {
            n = 404;
            string = this.rb.getString("B3113", transactionUID);
        }
        object = new Packet(iMQConnection.useDirectBuffers());
        ((Packet)object).setPacketType(5);
        GetTransactionsHandler.setProperties((Packet)object, 61, n, string);
        try {
            ((Packet)object).getProperties().put("JMQQuantity", new Integer(vector.size()));
        }
        catch (IOException iOException) {
            this.logger.log(16, "B3100", (Object)"Admin: GetTransactions: Could not extract properties from pkt", (Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.log(16, "B3100", (Object)"Admin: GetTransactions: Could not extract properties from pkt", (Throwable)classNotFoundException);
        }
        this.setBodyObject((Packet)object, vector);
        this.parent.sendReply(iMQConnection, packet, (Packet)object);
        return true;
    }
}

