/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.util.memory.levels;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.util.memory.MemoryGlobals;
import com.sun.messaging.jmq.jmsserver.util.memory.levels.Green;

public class Yellow
extends Green {
    protected static final int DEFAULT_GC_ITR = 1000;
    protected int GcIterationCount = 0;

    public Yellow(String string) {
        super(string);
        this.MEMORY_NAME_KEY = "B0022";
        this.GcIterationCount = Globals.getConfig().getIntProperty("imq." + string + ".gcitr", 1000);
    }

    public int getMessageCount(long l, int n) {
        if (n >= 0) {
            n = 1;
        }
        return super.getMessageCount(l, n) / n;
    }

    public long getMemory(long l, int n) {
        if (n >= 0) {
            n = 1;
        }
        return super.getMemory(l, n) / (long)n / 2L;
    }

    public int gcCount() {
        return 1;
    }

    public int gcIteration() {
        return this.GcIterationCount;
    }

    public boolean cleanup(int n) {
        super.cleanup(n);
        this.logger.log(8, "B1089");
        this.logger.log(4, "Broker is swapping persistent/sent but un-acked  messages");
        Globals.getConnectionManager().cleanupMemory(true);
        return true;
    }

    public boolean enter(boolean bl) {
        super.enter(bl);
        if (bl) {
            return false;
        }
        MemoryGlobals.MEM_FREE_P_ACKED = true;
        return true;
    }

    public boolean leave(boolean bl) {
        super.leave(bl);
        if (bl) {
            return false;
        }
        MemoryGlobals.MEM_FREE_P_ACKED = false;
        return false;
    }
}

