/*
 * @(#)SOAPtoJMSServlet.java	1.5 02/07/19
 *
 * Copyright (c) 2002 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

import javax.xml.messaging.JAXMServlet;
import javax.xml.messaging.ReqRespListener;

import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPPart;

import com.sun.messaging.xml.MessageTransformer;

import com.sun.messaging.TopicConnectionFactory;

import javax.jms.MessageListener;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.Session;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.JMSException;
import javax.jms.TopicPublisher;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

/**
 * This example shows how to use the MessageTransformer utility to convert SOAP
 * message to JMS message.  When SOAP messages are received, they are
 * delivered to the ReqRespListener's onMessage() method.  The onMessage()
 * implementation uses the utility to convert SOAP to JMS message, then
 * publishes the message to the JMS Topic.
 * <p>
 * The onMessage() method adds <MessageStatus> element with value "published"
 * to the SOAPBody and returns the SOAP message to the caller.
 */
public class SOAPtoJMSServlet extends JAXMServlet implements ReqRespListener {

    TopicConnectionFactory tcf = null;
    TopicConnection tc = null;
    TopicSession session = null;
    Topic topic = null;

    TopicPublisher publisher = null;

    /**
     * The init method set up JMS Connection/Session/Publisher.
     */
    public void init(ServletConfig config) throws ServletException {

        super.init(config);

        try {

            tcf = new com.sun.messaging.TopicConnectionFactory();

            tc = tcf.createTopicConnection();
            session = tc.createTopicSession(false, Session.AUTO_ACKNOWLEDGE);

            String topicName = config.getInitParameter("TopicName");
            if ( topicName == null ) {
                topicName = "TestTopic";
            }

            topic = session.createTopic(topicName);
            publisher = session.createPublisher(topic);

        } catch (Exception jmse) {
            throw new ServletException (jmse);
        }
    }

    /**
     * Clean up JMS connection.
     */
    public void destroy() {
        try {
            if ( tc != null ) {
                tc.close();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * SOAP Messages are delivered to this method and then published to the
     * JMS topic destination.
     */
    public SOAPMessage onMessage (SOAPMessage soapMessage) {

        try {
            Message message =
            MessageTransformer.SOAPMessageIntoJMSMessage(soapMessage, session);

            publisher.publish( message );

        } catch (Exception e) {
            e.printStackTrace();
        }

        SOAPMessage resp = generateResponseMessage(soapMessage);

        return resp;
    }

    /**
     * Add a MessageStatus element with the value of "published" to
     * the soapMessage.
     */
    public SOAPMessage generateResponseMessage(SOAPMessage soapMessage) {

        try {
            SOAPPart soapPart = soapMessage.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            SOAPBody soapBody = envelope.getBody();

            soapBody.addChildElement("MessageStatus").addTextNode("published");
            soapMessage.saveChanges();
        } catch (SOAPException soape) {
            soape.printStackTrace();
        }

        return soapMessage;
    }

}
