/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.beans;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;

public class BeanProperty {
    private final Class beanClass;
    private final String propertyName;
    private Class valueClass = null;
    private List getterChain = null;
    private List setterChain = null;
    private static final Object[] EMPTY_ARGUMENTS = new Object[0];
    private static final Class[] EMPTY_PARAMETER_TYPES = new Class[0];

    public BeanProperty(Class beanClass, String propertyName, boolean readable, boolean writable) {
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass may not be null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName may not be null");
        }
        this.beanClass = beanClass;
        this.propertyName = propertyName;
        String[] propertyParts = propertyName.split("\\.");
        ArrayList<Method> commonChain = new ArrayList<Method>();
        Class<?> currentClass = beanClass;
        for (int p = 0; p < propertyParts.length - 1; ++p) {
            Method partGetter = this.findGetterMethod(currentClass, propertyParts[p]);
            commonChain.add(partGetter);
            currentClass = partGetter.getReturnType();
        }
        if (readable) {
            this.getterChain = new ArrayList();
            this.getterChain.addAll(commonChain);
            Method lastGetter = this.findGetterMethod(currentClass, propertyParts[propertyParts.length - 1]);
            this.getterChain.add(lastGetter);
            this.valueClass = lastGetter.getReturnType();
        }
        if (writable) {
            this.setterChain = new ArrayList();
            this.setterChain.addAll(commonChain);
            Method lastSetter = this.findSetterMethod(currentClass, propertyParts[propertyParts.length - 1]);
            this.setterChain.add(lastSetter);
            if (this.valueClass == null) {
                this.valueClass = lastSetter.getParameterTypes()[0];
            }
        }
    }

    private Method findGetterMethod(Class targetClass, String property) {
        for (Class currentClass = targetClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            String getProperty = "get" + this.capitalize(property);
            Method result = this.getMethod(currentClass, getProperty, EMPTY_PARAMETER_TYPES);
            if (result != null) {
                this.validateGetter(result);
                return result;
            }
            String isProperty = "is" + this.capitalize(property);
            result = this.getMethod(currentClass, isProperty, EMPTY_PARAMETER_TYPES);
            if (result == null) continue;
            this.validateGetter(result);
            return result;
        }
        throw new IllegalArgumentException("Failed to find getter for property \"" + property + "\" of " + targetClass);
    }

    private Method findSetterMethod(Class targetClass, String property) {
        String setProperty = "set" + this.capitalize(property);
        for (Class currentClass = targetClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Method[] classMethods = currentClass.getMethods();
            for (int m = 0; m < classMethods.length; ++m) {
                if (!classMethods[m].getName().equals(setProperty) || classMethods[m].getParameterTypes().length != 1) continue;
                this.validateSetter(classMethods[m]);
                return classMethods[m];
            }
        }
        throw new IllegalArgumentException("Failed to find setter for property \"" + property + "\" of " + targetClass);
    }

    private void validateGetter(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalArgumentException("Getter \"" + method + "\" is not public");
        }
        if (Void.TYPE.equals(method.getReturnType())) {
            throw new IllegalArgumentException("Getter \"" + method + "\" returns void");
        }
    }

    private void validateSetter(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalArgumentException("Setter \"" + method + "\" is not public");
        }
        if (method.getParameterTypes().length != 1) {
            throw new IllegalArgumentException("Setter \"" + method + "\" does not take one paramter");
        }
    }

    private String capitalize(String property) {
        StringBuffer result = new StringBuffer();
        result.append(Character.toUpperCase(property.charAt(0)));
        result.append(property.substring(1));
        return result.toString();
    }

    private Method getMethod(Class targetClass, String methodName, Class[] parameterTypes) {
        try {
            return targetClass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class getValueClass() {
        return this.valueClass;
    }

    public boolean isReadable() {
        return this.getterChain != null;
    }

    public boolean isWritable() {
        return this.setterChain != null;
    }

    public Object get(Object member) {
        if (!this.isReadable()) {
            throw new IllegalStateException("Property " + this.propertyName + " of " + this.beanClass + " not readable");
        }
        try {
            Object currentMember = member;
            int n = this.getterChain.size();
            for (int i = 0; i < n; ++i) {
                Method currentMethod = (Method)this.getterChain.get(i);
                currentMember = currentMethod.invoke(currentMember, EMPTY_ARGUMENTS);
                if (currentMember != null) continue;
                return null;
            }
            return currentMember;
        }
        catch (IllegalAccessException e) {
            SecurityException se = new SecurityException();
            se.initCause(e);
            throw se;
        }
        catch (InvocationTargetException e) {
            throw new UndeclaredThrowableException(e.getCause());
        }
    }

    public Object set(Object member, Object newValue) {
        if (!this.isWritable()) {
            throw new IllegalStateException("Property " + this.propertyName + " of " + this.beanClass + " not writable");
        }
        try {
            Object currentMember = member;
            int n = this.setterChain.size() - 1;
            for (int i = 0; i < n; ++i) {
                Method currentMethod = (Method)this.setterChain.get(i);
                currentMember = currentMethod.invoke(currentMember, EMPTY_ARGUMENTS);
                if (currentMember != null) continue;
                return null;
            }
            Method setterMethod = (Method)this.setterChain.get(this.setterChain.size() - 1);
            return setterMethod.invoke(currentMember, newValue);
        }
        catch (IllegalAccessException e) {
            SecurityException se = new SecurityException();
            se.initCause(e);
            throw se;
        }
        catch (InvocationTargetException e) {
            throw new UndeclaredThrowableException(e.getCause());
        }
    }

    public boolean equals(Object other) {
        BeanProperty otherProperty = (BeanProperty)other;
        if (!this.beanClass.equals(otherProperty.beanClass)) {
            return false;
        }
        return this.propertyName.equals(otherProperty.propertyName);
    }
}

