/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.AbstractTableComparatorChooser;
import ca.odell.glazedlists.impl.SortIconFactory;
import ca.odell.glazedlists.impl.gui.SortingStrategy;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.SortableRenderer;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class TableComparatorChooser
extends AbstractTableComparatorChooser {
    private final SortArrowHeaderRenderer sortArrowHeaderRenderer;
    private final TableModelHandler tableModelHandler = new TableModelHandler();
    private JTable table = null;
    private ActionListener sortListener = null;
    private static Icon[] icons = SortIconFactory.loadIcons();
    private final HeaderClickHandler headerClickHandler;

    public TableComparatorChooser(JTable table, SortedList sortedList, boolean multipleColumnSort) {
        this(table, sortedList, multipleColumnSort ? MULTIPLE_COLUMN_MOUSE : SINGLE_COLUMN);
    }

    public TableComparatorChooser(JTable table, SortedList sortedList, Object strategy) {
        super(sortedList, ((EventTableModel)table.getModel()).getTableFormat());
        TableComparatorChooser.validateSortingStrategy(strategy);
        this.table = table;
        this.sortArrowHeaderRenderer = new SortArrowHeaderRenderer(table.getTableHeader().getDefaultRenderer());
        table.getTableHeader().setDefaultRenderer(this.sortArrowHeaderRenderer);
        table.setColumnSelectionAllowed(false);
        table.getModel().addTableModelListener(this.tableModelHandler);
        this.headerClickHandler = new HeaderClickHandler(table, (SortingStrategy)strategy);
    }

    private static void validateSortingStrategy(Object strategy) {
        if (!(strategy instanceof SortingStrategy)) {
            throw new IllegalArgumentException("Unrecognized sorting strategy, \"" + strategy + "\", use one of AbstractTableComparatorChooser.SINGLE_COLUMN, AbstractTableComparatorChooser.MULTIPLE_COLUMN_MOUSE, or AbstractTableComparatorChooser.MULTIPLE_COLUMN_KEYBOARD");
        }
    }

    public void addSortActionListener(ActionListener sortActionListener) {
        this.sortListener = AWTEventMulticaster.add(this.sortListener, sortActionListener);
    }

    public void removeSortActionListener(ActionListener sortActionListener) {
        this.sortListener = AWTEventMulticaster.remove(this.sortListener, sortActionListener);
    }

    protected void redetectComparator(Comparator currentComparator) {
        super.redetectComparator(currentComparator);
        this.table.getTableHeader().revalidate();
        this.table.getTableHeader().repaint();
    }

    protected final void rebuildComparator() {
        super.rebuildComparator();
        this.table.getTableHeader().revalidate();
        this.table.getTableHeader().repaint();
        if (this.sortListener != null) {
            this.sortListener.actionPerformed(new ActionEvent(this, 0, "sort"));
        }
    }

    protected final int getSortingStyle(int column) {
        return super.getSortingStyle(this.table.convertColumnIndexToModel(column));
    }

    protected boolean isSortingMouseEvent(MouseEvent e) {
        return e.getButton() == 1;
    }

    public static void setIconPath(String path) {
        icons = SortIconFactory.loadIcons(path);
    }

    public void dispose() {
        super.dispose();
        this.headerClickHandler.dispose();
        if (this.table.getTableHeader().getDefaultRenderer() == this.sortArrowHeaderRenderer) {
            this.table.getTableHeader().setDefaultRenderer(this.sortArrowHeaderRenderer.getDelegateRenderer());
        }
        this.table.getModel().removeTableModelListener(this.tableModelHandler);
        this.table = null;
    }

    private class HeaderClickHandler
    extends MouseAdapter {
        private final JTable table;
        private final SortingStrategy delegate;
        private boolean mouseEventIsPerformingPopupTrigger = false;

        public HeaderClickHandler(JTable table, SortingStrategy delegate) {
            this.table = table;
            this.delegate = delegate;
            table.getTableHeader().addMouseListener(this);
        }

        public void mouseClicked(MouseEvent e) {
            if (this.mouseEventIsPerformingPopupTrigger) {
                return;
            }
            if (!TableComparatorChooser.this.isSortingMouseEvent(e)) {
                return;
            }
            boolean shift = e.isShiftDown();
            boolean control = e.isControlDown() || e.isMetaDown();
            TableColumnModel columnModel = this.table.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = this.table.convertColumnIndexToModel(viewColumn);
            int clicks = e.getClickCount();
            if (clicks >= 1 && column != -1) {
                this.delegate.columnClicked(TableComparatorChooser.this.sortingState, column, clicks, shift, control);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseEventIsPerformingPopupTrigger = mouseEvent.isPopupTrigger();
        }

        public void dispose() {
            this.table.getTableHeader().removeMouseListener(this);
        }
    }

    class SortArrowHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer delegateRenderer;

        public SortArrowHeaderRenderer(TableCellRenderer delegateRenderer) {
            this.delegateRenderer = delegateRenderer;
        }

        public TableCellRenderer getDelegateRenderer() {
            return this.delegateRenderer;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component rendered;
            Icon sortIcon = icons[TableComparatorChooser.this.getSortingStyle(column)];
            if (this.delegateRenderer instanceof SortableRenderer) {
                ((SortableRenderer)((Object)this.delegateRenderer)).setSortIcon(sortIcon);
                rendered = this.delegateRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            } else {
                rendered = this.delegateRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (rendered instanceof JLabel) {
                    JLabel label = (JLabel)rendered;
                    label.setIcon(sortIcon);
                    label.setHorizontalTextPosition(10);
                }
            }
            return rendered;
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        public void tableChanged(TableModelEvent event) {
            Comparator currentComparator;
            if (event.getFirstRow() == -1 && event.getColumn() == -1) {
                TableComparatorChooser.this.setTableFormat(((EventTableModel)TableComparatorChooser.this.table.getModel()).getTableFormat());
            }
            if ((currentComparator = TableComparatorChooser.this.sortedList.getComparator()) != TableComparatorChooser.this.sortedListComparator) {
                TableComparatorChooser.this.redetectComparator(currentComparator);
            }
        }
    }
}

