/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.antlr.Tool;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.DecisionProbe;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFA;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.NFAToDFAConverter;
import org.antlr.analysis.Transition;
import org.antlr.codegen.CodeGenerator;
import org.antlr.misc.IntSet;
import org.antlr.misc.IntervalSet;
import org.antlr.misc.Utils;
import org.antlr.runtime.IntStream;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.FASerializer;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.Interpreter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DFA {
    public static final int REACHABLE_UNKNOWN = -2;
    public static final int REACHABLE_BUSY = -1;
    public static final int REACHABLE_NO = 0;
    public static final int REACHABLE_YES = 1;
    public static final int MAX_STATES_PER_ALT_IN_DFA = 450;
    public static int MAX_TIME_PER_DFA_CREATION = 1000;
    public static int MAX_STATE_TRANSITIONS_FOR_TABLE = 65534;
    public DFAState startState;
    public int decisionNumber;
    public NFAState decisionNFAStartState;
    public String description;
    protected Map uniqueStates;
    protected Vector states;
    protected int stateCounter;
    protected int numberOfStates;
    protected int user_k;
    protected int max_k;
    protected boolean reduced;
    protected boolean cyclic;
    protected List unreachableAlts;
    protected int nAlts;
    protected DFAState[] altToAcceptState;
    protected IntSet recursiveAltSet;
    public NFA nfa;
    protected NFAToDFAConverter nfaConverter;
    public DecisionProbe probe;
    protected long conversionStartTime;
    public Map edgeTransitionClassMap;
    protected int edgeTransitionClass;
    public List specialStates;
    public List specialStateSTs;
    public Vector accept;
    public Vector eot;
    public Vector eof;
    public Vector min;
    public Vector max;
    public Vector special;
    public Vector transition;
    public Vector transitionEdgeTables;
    protected int uniqueCompressedSpecialStateNum;

    public void resetStateNumbersToBeContiguous() {
        if (this.getUserMaxLookahead() > 0) {
            return;
        }
        int snum = 0;
        int i = 0;
        while (i <= this.getMaxStateNumber()) {
            DFAState s = this.getState(i);
            if (s != null) {
                boolean alreadyRenumbered;
                boolean bl = false;
                if (s.stateNumber < i) {
                    bl = true;
                }
                if (!(alreadyRenumbered = bl)) {
                    s.stateNumber = snum++;
                }
            }
            ++i;
        }
        if (snum != this.getNumberOfStates()) {
            ErrorManager.internalError("DFA " + this.decisionNumber + ": " + this.decisionNFAStartState.getDescription() + " num unique states " + this.getNumberOfStates() + "!= num renumbered states " + snum);
        }
    }

    public List getJavaCompressedAccept() {
        return DFA.getRunLengthEncoding(this.accept);
    }

    public List getJavaCompressedEOT() {
        return DFA.getRunLengthEncoding(this.eot);
    }

    public List getJavaCompressedEOF() {
        return DFA.getRunLengthEncoding(this.eof);
    }

    public List getJavaCompressedMin() {
        return DFA.getRunLengthEncoding(this.min);
    }

    public List getJavaCompressedMax() {
        return DFA.getRunLengthEncoding(this.max);
    }

    public List getJavaCompressedSpecial() {
        return DFA.getRunLengthEncoding(this.special);
    }

    public List getJavaCompressedTransition() {
        if (this.transition == null || this.transition.size() == 0) {
            return null;
        }
        ArrayList<List> encoded = new ArrayList<List>(this.transition.size());
        int i = 0;
        while (i < this.transition.size()) {
            Vector transitionsForState = (Vector)this.transition.elementAt(i);
            encoded.add(DFA.getRunLengthEncoding(transitionsForState));
            ++i;
        }
        return encoded;
    }

    /*
     * WARNING - void declaration
     */
    public static List getRunLengthEncoding(List data) {
        if (data == null || data.size() == 0) {
            void negOneI;
            ArrayList<String> empty = new ArrayList<String>();
            empty.add("");
            return negOneI;
        }
        Integer negOneI = Utils.integer(-1);
        int size = Math.max(2, data.size() / 2);
        ArrayList<String> encoded = new ArrayList<String>(size);
        int i = 0;
        while (i < data.size()) {
            Integer I = (Integer)data.get(i);
            if (I == null) {
                I = negOneI;
            }
            int n = 0;
            int j = i;
            while (j < data.size()) {
                Integer v = (Integer)data.get(j);
                if (v == null) {
                    v = negOneI;
                }
                if (!I.equals(v)) break;
                ++n;
                ++j;
            }
            encoded.add(DFA.encodeIntAsCharEscape((char)n));
            encoded.add(DFA.encodeIntAsCharEscape((char)I.intValue()));
            i += n;
        }
        return encoded;
    }

    public void createStateTables(CodeGenerator generator) {
        this.description = this.getNFADecisionStartState().getDescription();
        this.description = generator.target.getTargetStringLiteralFromString(this.description);
        this.special = new Vector(this.getNumberOfStates());
        this.special.setSize(this.getNumberOfStates());
        this.specialStates = new ArrayList();
        this.specialStateSTs = new ArrayList();
        this.accept = new Vector(this.getNumberOfStates());
        this.accept.setSize(this.getNumberOfStates());
        this.eot = new Vector(this.getNumberOfStates());
        this.eot.setSize(this.getNumberOfStates());
        this.eof = new Vector(this.getNumberOfStates());
        this.eof.setSize(this.getNumberOfStates());
        this.min = new Vector(this.getNumberOfStates());
        this.min.setSize(this.getNumberOfStates());
        this.max = new Vector(this.getNumberOfStates());
        this.max.setSize(this.getNumberOfStates());
        this.transition = new Vector(this.getNumberOfStates());
        this.transition.setSize(this.getNumberOfStates());
        this.transitionEdgeTables = new Vector(this.getNumberOfStates());
        this.transitionEdgeTables.setSize(this.getNumberOfStates());
        Iterator<Object> it = null;
        it = this.getUserMaxLookahead() > 0 ? this.states.iterator() : this.getUniqueStates().values().iterator();
        while (it.hasNext()) {
            DFAState s = (DFAState)it.next();
            if (s.isAcceptState()) {
                this.accept.set(s.stateNumber, Utils.integer(s.getUniquelyPredictedAlt()));
                continue;
            }
            this.createMinMaxTables(s);
            this.createTransitionTableEntryForState(s);
            this.createSpecialTable(s);
            this.createEOTAndEOFTables(s);
        }
        int i = 0;
        while (i < this.specialStates.size()) {
            DFAState ss = (DFAState)this.specialStates.get(i);
            StringTemplate stateST = generator.generateSpecialState(ss);
            this.specialStateSTs.add(stateST);
            ++i;
        }
    }

    protected void createMinMaxTables(DFAState s) {
        int smin = -1;
        int smax = -3;
        int j = 0;
        while (j < s.getNumberOfTransitions()) {
            Transition edge = s.transition(j);
            Label label = edge.label;
            if (label.isAtom()) {
                if (label.getAtom() >= 0) {
                    if (label.getAtom() < smin) {
                        smin = label.getAtom();
                    }
                    if (label.getAtom() > smax) {
                        smax = label.getAtom();
                    }
                }
            } else if (label.isSet()) {
                IntervalSet labels = (IntervalSet)label.getSet();
                int lmin = labels.getMinElement();
                if (lmin < smin && lmin >= 0) {
                    smin = labels.getMinElement();
                }
                if (labels.getMaxElement() > smax) {
                    smax = labels.getMaxElement();
                }
            }
            ++j;
        }
        if (smax < 0) {
            smin = 0;
            smax = 0;
        }
        this.min.set(s.stateNumber, Utils.integer((char)smin));
        this.max.set(s.stateNumber, Utils.integer((char)smax));
        if (smax < 0 || smin > 65534 || smin < 0) {
            ErrorManager.internalError("messed up: min=" + this.min + ", max=" + this.max);
        }
    }

    protected void createTransitionTableEntryForState(DFAState s) {
        int smax = (Integer)this.max.get(s.stateNumber);
        int smin = (Integer)this.min.get(s.stateNumber);
        Vector<Integer> stateTransitions = new Vector<Integer>(smax - smin + 1);
        stateTransitions.setSize(smax - smin + 1);
        this.transition.set(s.stateNumber, stateTransitions);
        int j = 0;
        while (j < s.getNumberOfTransitions()) {
            Transition edge = s.transition(j);
            Label label = edge.label;
            if (label.isAtom() && label.getAtom() >= 0) {
                int labelIndex = label.getAtom() - smin;
                stateTransitions.set(labelIndex, Utils.integer(edge.target.stateNumber));
            } else if (label.isSet()) {
                IntervalSet labels = (IntervalSet)label.getSet();
                int[] atoms = labels.toArray();
                int a = 0;
                while (a < atoms.length) {
                    if (atoms[a] >= 0) {
                        int labelIndex = atoms[a] - smin;
                        stateTransitions.set(labelIndex, Utils.integer(edge.target.stateNumber));
                    }
                    ++a;
                }
            }
            ++j;
        }
        Integer edgeClass = (Integer)this.edgeTransitionClassMap.get(stateTransitions);
        if (edgeClass != null) {
            this.transitionEdgeTables.set(s.stateNumber, edgeClass);
        } else {
            edgeClass = Utils.integer(this.edgeTransitionClass);
            this.transitionEdgeTables.set(s.stateNumber, edgeClass);
            this.edgeTransitionClassMap.put(stateTransitions, edgeClass);
            ++this.edgeTransitionClass;
        }
    }

    protected void createEOTAndEOFTables(DFAState s) {
        int j = 0;
        while (j < s.getNumberOfTransitions()) {
            block8: {
                Label label;
                Transition edge;
                block6: {
                    block7: {
                        edge = s.transition(j);
                        label = edge.label;
                        if (!label.isAtom()) break block6;
                        if (label.getAtom() != -2) break block7;
                        this.eot.set(s.stateNumber, Utils.integer(edge.target.stateNumber));
                        break block8;
                    }
                    if (label.getAtom() != -1) break block8;
                    this.eof.set(s.stateNumber, Utils.integer(edge.target.stateNumber));
                    break block8;
                }
                if (label.isSet()) {
                    IntervalSet labels = (IntervalSet)label.getSet();
                    int[] atoms = labels.toArray();
                    int a = 0;
                    while (a < atoms.length) {
                        if (atoms[a] == -2) {
                            this.eot.set(s.stateNumber, Utils.integer(edge.target.stateNumber));
                        } else if (atoms[a] == -1) {
                            this.eof.set(s.stateNumber, Utils.integer(edge.target.stateNumber));
                        }
                        ++a;
                    }
                }
            }
            ++j;
        }
    }

    protected void createSpecialTable(DFAState s) {
        boolean hasSemPred = false;
        int j = 0;
        while (j < s.getNumberOfTransitions()) {
            Transition edge = s.transition(j);
            Label label = edge.label;
            if (label.isSemanticPredicate() || ((DFAState)edge.target).getGatedPredicatesInNFAConfigurations() != null) {
                hasSemPred = true;
                break;
            }
            ++j;
        }
        int smax = (Integer)this.max.get(s.stateNumber);
        int smin = (Integer)this.min.get(s.stateNumber);
        if (hasSemPred || smax - smin > MAX_STATE_TRANSITIONS_FOR_TABLE) {
            this.special.set(s.stateNumber, Utils.integer(this.uniqueCompressedSpecialStateNum));
            ++this.uniqueCompressedSpecialStateNum;
            this.specialStates.add(s);
        } else {
            this.special.set(s.stateNumber, Utils.integer(-1));
        }
    }

    public static String encodeIntAsCharEscape(int v) {
        if (v <= 127) {
            return "\\" + Integer.toOctalString(v);
        }
        String hex = Integer.toHexString(v | 0x10000).substring(1, 5);
        return "\\u" + hex;
    }

    public int predict(IntStream input) {
        Interpreter interp = new Interpreter(this.nfa.grammar, input);
        return interp.predict(this);
    }

    protected DFAState addState(DFAState d) {
        if (this.getUserMaxLookahead() > 0) {
            return d;
        }
        DFAState existing = (DFAState)this.uniqueStates.get(d);
        if (existing != null) {
            return existing;
        }
        this.uniqueStates.put(d, d);
        ++this.numberOfStates;
        return d;
    }

    public void removeState(DFAState d) {
        DFAState it = (DFAState)this.uniqueStates.remove(d);
        if (it != null) {
            --this.numberOfStates;
        }
    }

    public Map getUniqueStates() {
        return this.uniqueStates;
    }

    public int getMaxStateNumber() {
        return this.states.size() - 1;
    }

    public DFAState getState(int stateNumber) {
        return (DFAState)this.states.get(stateNumber);
    }

    public void setState(int stateNumber, DFAState d) {
        this.states.set(stateNumber, d);
    }

    public boolean isReduced() {
        return this.reduced;
    }

    public boolean isCyclic() {
        boolean bl = false;
        if (this.cyclic && this.getUserMaxLookahead() == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isTokensRuleDecision() {
        if (this.nfa.grammar.type != 1) {
            return false;
        }
        NFAState nfaStart = this.getNFADecisionStartState();
        NFAState TokensRuleStart = this.nfa.grammar.getRuleStartState("Tokens");
        NFAState TokensDecisionStart = (NFAState)TokensRuleStart.transition((int)0).target;
        boolean bl = false;
        if (nfaStart == TokensDecisionStart) {
            bl = true;
        }
        return bl;
    }

    public int getUserMaxLookahead() {
        if (this.user_k >= 0) {
            return this.user_k;
        }
        GrammarAST blockAST = this.nfa.grammar.getDecisionBlockAST(this.decisionNumber);
        Object k = blockAST.getOption("k");
        if (k == null) {
            this.user_k = this.nfa.grammar.getGrammarMaxLookahead();
            return this.user_k;
        }
        if (k instanceof Integer) {
            Integer kI = (Integer)k;
            this.user_k = kI;
        } else if (k.equals("*")) {
            this.user_k = 0;
        }
        return this.user_k;
    }

    public boolean getAutoBacktrackMode() {
        String autoBacktrack = (String)this.decisionNFAStartState.getAssociatedASTNode().getOption("backtrack");
        if (autoBacktrack == null) {
            autoBacktrack = (String)this.nfa.grammar.getOption("backtrack");
        }
        boolean bl = false;
        if (autoBacktrack != null && autoBacktrack.equals("true")) {
            bl = true;
        }
        return bl;
    }

    public void setUserMaxLookahead(int k) {
        this.user_k = k;
    }

    public int getMaxLookaheadDepth() {
        if (this.isCyclic()) {
            return Integer.MAX_VALUE;
        }
        return this.max_k;
    }

    public List getUnreachableAlts() {
        return this.unreachableAlts;
    }

    public void verify() {
        if (!this.probe.nonRegularDecision) {
            this.doesStateReachAcceptState(this.startState);
        }
    }

    protected boolean doesStateReachAcceptState(DFAState d) {
        if (d.isAcceptState()) {
            d.setAcceptStateReachable(1);
            int predicts = d.getUniquelyPredictedAlt();
            this.unreachableAlts.remove(Utils.integer(predicts));
            return true;
        }
        d.setAcceptStateReachable(-1);
        boolean anEdgeReachesAcceptState = false;
        int i = 0;
        while (i < d.getNumberOfTransitions()) {
            Transition t = d.transition(i);
            DFAState edgeTarget = (DFAState)t.target;
            int targetStatus = edgeTarget.getAcceptStateReachable();
            if (targetStatus == -1) {
                this.cyclic = true;
            } else if (targetStatus == 1) {
                anEdgeReachesAcceptState = true;
            } else if (targetStatus != 0 && this.doesStateReachAcceptState(edgeTarget)) {
                anEdgeReachesAcceptState = true;
            }
            ++i;
        }
        if (anEdgeReachesAcceptState) {
            d.setAcceptStateReachable(1);
        } else {
            d.setAcceptStateReachable(0);
            this.reduced = false;
        }
        return anEdgeReachesAcceptState;
    }

    public NFAState getNFADecisionStartState() {
        return this.decisionNFAStartState;
    }

    public DFAState getAcceptState(int alt) {
        return this.altToAcceptState[alt];
    }

    public void setAcceptState(int alt, DFAState acceptState) {
        this.altToAcceptState[alt] = acceptState;
    }

    public String getDescription() {
        return this.description;
    }

    public int getDecisionNumber() {
        return this.decisionNFAStartState.getDecisionNumber();
    }

    public GrammarAST getDecisionASTNode() {
        return this.decisionNFAStartState.getAssociatedASTNode();
    }

    public boolean isGreedy() {
        GrammarAST blockAST = this.nfa.grammar.getDecisionBlockAST(this.decisionNumber);
        String v = (String)blockAST.getOption("greedy");
        return v == null || !v.equals("false");
    }

    public DFAState newState() {
        DFAState n = new DFAState(this);
        n.stateNumber = this.stateCounter++;
        this.states.setSize(n.stateNumber + 1);
        this.states.set(n.stateNumber, n);
        return n;
    }

    public int getNumberOfStates() {
        if (this.getUserMaxLookahead() > 0) {
            return this.states.size();
        }
        return this.numberOfStates;
    }

    public int getNumberOfAlts() {
        return this.nAlts;
    }

    public boolean analysisAborted() {
        return this.probe.analysisAborted();
    }

    protected void initAltRelatedInfo() {
        this.unreachableAlts = new LinkedList();
        int i = 1;
        while (i <= this.nAlts) {
            this.unreachableAlts.add(Utils.integer(i));
            ++i;
        }
        this.altToAcceptState = new DFAState[this.nAlts + 1];
    }

    public String toString() {
        FASerializer serializer = new FASerializer(this.nfa.grammar);
        if (this.startState == null) {
            return "";
        }
        return serializer.serialize(this.startState, false);
    }

    private final /* synthetic */ void this() {
        this.decisionNumber = 0;
        this.uniqueStates = new HashMap();
        this.states = new Vector();
        this.stateCounter = 0;
        this.numberOfStates = 0;
        this.user_k = -1;
        this.max_k = -1;
        this.reduced = true;
        this.cyclic = false;
        this.nAlts = 0;
        this.recursiveAltSet = new IntervalSet();
        this.probe = new DecisionProbe(this);
        this.edgeTransitionClassMap = new LinkedHashMap();
        this.edgeTransitionClass = 0;
        this.uniqueCompressedSpecialStateNum = 0;
    }

    public DFA(int decisionNumber, NFAState decisionStartState) {
        this.this();
        this.decisionNumber = decisionNumber;
        this.decisionNFAStartState = decisionStartState;
        this.nfa = decisionStartState.nfa;
        this.nAlts = this.nfa.grammar.getNumberOfAltsForDecisionNFA(decisionStartState);
        this.initAltRelatedInfo();
        this.nfaConverter = new NFAToDFAConverter(this);
        this.nfaConverter.convert();
        this.verify();
        if (!this.probe.isDeterministic() || this.probe.analysisAborted() || this.probe.analysisOverflowed()) {
            this.probe.issueWarnings();
        }
        this.resetStateNumbersToBeContiguous();
        if (Tool.internalOption_PrintDFA) {
            System.out.println("DFA d=" + decisionNumber);
            FASerializer serializer = new FASerializer(this.nfa.grammar);
            String result = serializer.serialize(this.startState);
            System.out.println(result);
        }
    }
}

