#!/bin/sh -e

# $1 version
TAR=../jajuk_$1.orig.tar.gz
DIR=jajuk-$1.orig
VERSION=`echo $1 | sed -e 's/[+~].*//g' | sed -e 's/\./_/g'`
# trunk version
# REVISION=`echo $1 | sed -e 's/.*svn//'`
# tag version
TAG=release-$VERSION

# clean up the upstream tarball
mkdir $DIR
mkdir $DIR/src
(cd $DIR/src; \
# tag version
svn export https://jajuk.svn.sourceforge.net/svnroot/jajuk/tags/$TAG/src/main)
# trunk version
# svn export -r $REVISION https://jajuk.svn.sourceforge.net/svnroot/jajuk/trunk/jajuk/src/main)
GZIP=--best tar -c -z -f $TAR -X debian/orig-tar.exclude $DIR
rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi

exit 0
