/*
 * Decompiled with CFR 0.152.
 */
package jnlp.sample.servlet;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class DownloadRequest {
    private static final String ARG_ARCH = "arch";
    private static final String ARG_OS = "os";
    private static final String ARG_LOCALE = "locale";
    private static final String ARG_VERSION_ID = "version-id";
    private static final String ARG_CURRENT_VERSION_ID = "current-version-id";
    private static final String ARG_PLATFORM_VERSION_ID = "platform-version-id";
    private static final String ARG_KNOWN_PLATFORMS = "known-platforms";
    private static final String TEST_JRE = "TestJRE";
    private String _path = null;
    private String _version = null;
    private String _currentVersionId = null;
    private String[] _os = null;
    private String[] _arch = null;
    private String[] _locale = null;
    private String[] _knownPlatforms = null;
    private String _query = null;
    private String _testJRE = null;
    private boolean _isPlatformRequest = false;
    private ServletContext _context = null;
    private String _encoding = null;
    private HttpServletRequest _httpRequest = null;
    public static final String ACCEPT_ENCODING = "accept-encoding";

    public DownloadRequest(HttpServletRequest httpServletRequest) {
        this(null, httpServletRequest);
    }

    public DownloadRequest(ServletContext servletContext, HttpServletRequest httpServletRequest) {
        File file;
        String string;
        this._context = servletContext;
        this._httpRequest = httpServletRequest;
        this._path = httpServletRequest.getRequestURI();
        this._encoding = httpServletRequest.getHeader(ACCEPT_ENCODING);
        String string2 = httpServletRequest.getContextPath();
        if (string2 != null) {
            this._path = this._path.substring(string2.length());
        }
        if (this._path == null) {
            this._path = httpServletRequest.getServletPath();
        }
        if (this._path == null) {
            this._path = "/";
        }
        this._path = this._path.trim();
        if (this._context != null && !this._path.endsWith("/") && (string = this._context.getRealPath(this._path)) != null && (file = new File(string)) != null && file.exists() && file.isDirectory()) {
            this._path = this._path + "/";
        }
        if (this._path.endsWith("/")) {
            this._path = this._path + "launch.jnlp";
        }
        this._version = this.getParameter(httpServletRequest, ARG_VERSION_ID);
        this._currentVersionId = this.getParameter(httpServletRequest, ARG_CURRENT_VERSION_ID);
        this._os = this.getParameterList(httpServletRequest, ARG_OS);
        this._arch = this.getParameterList(httpServletRequest, ARG_ARCH);
        this._locale = this.getParameterList(httpServletRequest, ARG_LOCALE);
        this._knownPlatforms = this.getParameterList(httpServletRequest, ARG_KNOWN_PLATFORMS);
        string = this.getParameter(httpServletRequest, ARG_PLATFORM_VERSION_ID);
        boolean bl = this._isPlatformRequest = string != null;
        if (this._isPlatformRequest) {
            this._version = string;
        }
        this._query = httpServletRequest.getQueryString();
        this._testJRE = this.getParameter(httpServletRequest, TEST_JRE);
    }

    private DownloadRequest(DownloadRequest downloadRequest) {
        this._encoding = downloadRequest._encoding;
        this._context = downloadRequest._context;
        this._httpRequest = downloadRequest._httpRequest;
        this._path = downloadRequest._path;
        this._version = downloadRequest._currentVersionId;
        this._currentVersionId = null;
        this._os = downloadRequest._os;
        this._arch = downloadRequest._arch;
        this._locale = downloadRequest._locale;
        this._knownPlatforms = downloadRequest._knownPlatforms;
        this._isPlatformRequest = downloadRequest._isPlatformRequest;
        this._query = downloadRequest._query;
        this._testJRE = downloadRequest._testJRE;
    }

    private String getParameter(HttpServletRequest httpServletRequest, String string) {
        String string2 = httpServletRequest.getParameter(string);
        return string2 == null ? null : string2.trim();
    }

    private static String[] getStringList(String string) {
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.length();
        StringBuffer stringBuffer = null;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (stringBuffer == null) continue;
                arrayList.add(stringBuffer.toString());
                stringBuffer = null;
                continue;
            }
            if (c == '\\') {
                if (i + 1 >= n) continue;
                c = string.charAt(++i);
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append(c);
                continue;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            stringBuffer.append(c);
        }
        if (stringBuffer != null) {
            arrayList.add(stringBuffer.toString());
        }
        if (arrayList.size() == 0) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    private String[] getParameterList(HttpServletRequest httpServletRequest, String string) {
        String string2 = httpServletRequest.getParameter(string);
        return string2 == null ? null : DownloadRequest.getStringList(string2.trim());
    }

    public String getPath() {
        return this._path;
    }

    public String getVersion() {
        return this._version;
    }

    public String getCurrentVersionId() {
        return this._currentVersionId;
    }

    public String getQuery() {
        return this._query;
    }

    public String getTestJRE() {
        return this._testJRE;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public String[] getOS() {
        return this._os;
    }

    public String[] getArch() {
        return this._arch;
    }

    public String[] getLocale() {
        return this._locale;
    }

    public String[] getKnownPlatforms() {
        return this._knownPlatforms;
    }

    public boolean isPlatformRequest() {
        return this._isPlatformRequest;
    }

    public HttpServletRequest getHttpRequest() {
        return this._httpRequest;
    }

    DownloadRequest getFromDownloadRequest() {
        return new DownloadRequest(this);
    }

    public String toString() {
        return "DownloadRequest[path=" + this._path + this.showEntry(" encoding=", this._encoding) + this.showEntry(" query=", this._query) + this.showEntry(" TestJRE=", this._testJRE) + this.showEntry(" version=", this._version) + this.showEntry(" currentVersionId=", this._currentVersionId) + this.showEntry(" os=", this._os) + this.showEntry(" arch=", this._arch) + this.showEntry(" locale=", this._locale) + this.showEntry(" knownPlatforms=", this._knownPlatforms) + " isPlatformRequest=" + this._isPlatformRequest + "]";
    }

    private String showEntry(String string, String string2) {
        if (string2 == null) {
            return "";
        }
        return string + string2;
    }

    private String showEntry(String string, String[] stringArray) {
        if (stringArray == null) {
            return "";
        }
        return string + Arrays.asList(stringArray).toString();
    }
}

