/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.j2ee.session;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.logging.Logger;
import org.mortbay.j2ee.session.AbstractStore;
import org.mortbay.j2ee.session.LocalState;
import org.mortbay.j2ee.session.State;
import org.mortbay.j2ee.session.StateAdaptor;
import org.mortbay.j2ee.session.StateInterceptor;

public abstract class AbstractReplicatedStore
extends AbstractStore {
    protected static final Logger _log = Logger.getLogger((Class)(class$org$mortbay$j2ee$session$AbstractReplicatedStore == null ? (class$org$mortbay$j2ee$session$AbstractReplicatedStore = AbstractReplicatedStore.class$("org.mortbay.j2ee.session.AbstractReplicatedStore")) : class$org$mortbay$j2ee$session$AbstractReplicatedStore));
    protected ClassLoader _loader;
    private static final ThreadLocal _replicating = new ThreadLocal();
    protected Map _sessions = new HashMap();
    protected static Map _methodToInteger = new HashMap();
    protected static Method[] _integerToMethod = new Method[8];
    protected static Method CREATE_SESSION;
    protected static Method DESTROY_SESSION;
    protected static Method TOUCH_SESSIONS;
    protected static Method SET_LAST_ACCESSED_TIME;
    protected Map _subscribers = new HashMap();
    static /* synthetic */ Class class$org$mortbay$j2ee$session$AbstractReplicatedStore;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$org$mortbay$j2ee$session$State;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Map;

    public AbstractReplicatedStore() {
        this._loader = Thread.currentThread().getContextClassLoader();
    }

    public ClassLoader getLoader() {
        return this._loader;
    }

    public void setLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public static boolean getReplicating() {
        return _replicating.get() == Boolean.TRUE;
    }

    public static void setReplicating(boolean replicating) {
        _replicating.set(replicating ? Boolean.TRUE : Boolean.FALSE);
    }

    public Object clone() {
        AbstractReplicatedStore ars = (AbstractReplicatedStore)super.clone();
        ars.setLoader(this.getLoader());
        return ars;
    }

    public void destroy() {
        _log.trace((Object)"destroying...");
        this._sessions.clear();
        this._sessions = null;
        this.setManager(null);
        super.destroy();
        _log.trace((Object)"...destroyed");
    }

    public State newState(String id, int maxInactiveInterval) throws Exception {
        long creationTime = System.currentTimeMillis();
        if (!AbstractReplicatedStore.getReplicating()) {
            Object[] argInstances = new Object[]{id, new Long(creationTime), new Integer(maxInactiveInterval), new Integer(this._actualMaxInactiveInterval)};
            this.publish(null, CREATE_SESSION, argInstances);
        }
        this.createSession(id, creationTime, maxInactiveInterval, this._actualMaxInactiveInterval);
        return this.loadState(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State loadState(String id) {
        Object tmp;
        Map map = this._sessions;
        synchronized (map) {
            tmp = this._sessions.get(id);
        }
        return (State)tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeState(State state) {
        try {
            String id = state.getId();
            Map map = this._sessions;
            synchronized (map) {
                this._sessions.put(id, state);
            }
        }
        catch (Exception e) {
            _log.error((Object)"error storing session", (Throwable)e);
        }
    }

    public void removeState(State state) throws Exception {
        String id = state.getId();
        if (!AbstractReplicatedStore.getReplicating()) {
            Object[] argInstances = new Object[]{id};
            this.publish(null, DESTROY_SESSION, argInstances);
        }
        this.destroySession(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scavenge() throws Exception {
        _log.trace((Object)"starting distributed session scavenge...");
        Map map = this._sessions;
        synchronized (map) {
            Iterator i = this._sessions.entrySet().iterator();
            while (i.hasNext()) {
                if (((LocalState)i.next().getValue()).isValid(this._scavengerExtraTime)) continue;
                i.remove();
            }
        }
        _log.trace((Object)"...distributed session scavenge finished");
    }

    public void passivateSession(StateAdaptor sa) {
    }

    public boolean isDistributed() {
        return true;
    }

    public String getContextPath() {
        return this.getManager().getContextPath();
    }

    protected abstract void publish(String var1, Method var2, Object[] var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatch(String id, Integer methodId, Object[] argInstances) {
        try {
            AbstractReplicatedStore.setReplicating(true);
            AbstractReplicatedStore target = null;
            if (id == null) {
                target = this;
            } else {
                Map map = this._subscribers;
                synchronized (map) {
                    target = this._subscribers.get(id);
                }
            }
            try {
                Method method = _integerToMethod[methodId];
                if (target == null) {
                    _log.warn((Object)("null target for " + method));
                } else {
                    method.invoke((Object)target, argInstances);
                }
            }
            catch (Exception e) {
                _log.error((Object)"this should never happen - code version mismatch ?", (Throwable)e);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            AbstractReplicatedStore.setReplicating(false);
            throw throwable;
        }
        AbstractReplicatedStore.setReplicating(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSession(String id, long creationTime, int maxInactiveInterval, int actualMaxInactiveInterval) {
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("creating replicated session: " + id));
        }
        LocalState state = new LocalState(id, creationTime, maxInactiveInterval, actualMaxInactiveInterval);
        Map map = this._sessions;
        synchronized (map) {
            this._sessions.put(id, state);
        }
        if (AbstractReplicatedStore.getReplicating()) {
            this.getManager().getHttpSession(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySession(String id) {
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("destroying replicated session: " + id));
        }
        if (this.getManager().sessionExists(id)) {
            this.getManager().destroyContainer(this.getManager().getHttpSession(id));
        }
        Map map = this._sessions;
        synchronized (map) {
            this._sessions.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touchSessions(String[] ids, long time) {
        int i = 0;
        while (i < ids.length) {
            Object target;
            String id = ids[i];
            Map map = this._subscribers;
            synchronized (map) {
                target = this._subscribers.get(id);
            }
            try {
                ((StateInterceptor)target).setLastAccessedTime(time);
            }
            catch (Exception e) {
                _log.warn((Object)("unable to touch session: " + id + " probably already removed"));
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String id, Object o) {
        Map map = this._subscribers;
        synchronized (map) {
            this._subscribers.put(id, o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String id) {
        Map map = this._subscribers;
        synchronized (map) {
            this._subscribers.remove(id);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            int index = 0;
            Method m = null;
            AbstractReplicatedStore._integerToMethod[index] = m = (CREATE_SESSION = (class$org$mortbay$j2ee$session$AbstractReplicatedStore == null ? (class$org$mortbay$j2ee$session$AbstractReplicatedStore = AbstractReplicatedStore.class$("org.mortbay.j2ee.session.AbstractReplicatedStore")) : class$org$mortbay$j2ee$session$AbstractReplicatedStore).getMethod("createSession", class$java$lang$String == null ? (class$java$lang$String = AbstractReplicatedStore.class$("java.lang.String")) : class$java$lang$String, Long.TYPE, Integer.TYPE, Integer.TYPE));
            _methodToInteger.put(m.getName(), new Integer(index));
            AbstractReplicatedStore._integerToMethod[++index] = m = (DESTROY_SESSION = (class$org$mortbay$j2ee$session$AbstractReplicatedStore == null ? (class$org$mortbay$j2ee$session$AbstractReplicatedStore = AbstractReplicatedStore.class$("org.mortbay.j2ee.session.AbstractReplicatedStore")) : class$org$mortbay$j2ee$session$AbstractReplicatedStore).getMethod("destroySession", class$java$lang$String == null ? (class$java$lang$String = AbstractReplicatedStore.class$("java.lang.String")) : class$java$lang$String));
            _methodToInteger.put(m.getName(), new Integer(index));
            AbstractReplicatedStore._integerToMethod[++index] = m = (TOUCH_SESSIONS = (class$org$mortbay$j2ee$session$AbstractReplicatedStore == null ? (class$org$mortbay$j2ee$session$AbstractReplicatedStore = AbstractReplicatedStore.class$("org.mortbay.j2ee.session.AbstractReplicatedStore")) : class$org$mortbay$j2ee$session$AbstractReplicatedStore).getMethod("touchSessions", array$Ljava$lang$String == null ? (array$Ljava$lang$String = AbstractReplicatedStore.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, Long.TYPE));
            _methodToInteger.put(m.getName(), new Integer(index));
            AbstractReplicatedStore._integerToMethod[++index] = m = (SET_LAST_ACCESSED_TIME = (class$org$mortbay$j2ee$session$State == null ? (class$org$mortbay$j2ee$session$State = AbstractReplicatedStore.class$("org.mortbay.j2ee.session.State")) : class$org$mortbay$j2ee$session$State).getMethod("setLastAccessedTime", Long.TYPE));
            _methodToInteger.put(m.getName(), new Integer(index));
            AbstractReplicatedStore._integerToMethod[++index] = m = (class$org$mortbay$j2ee$session$State == null ? (class$org$mortbay$j2ee$session$State = AbstractReplicatedStore.class$("org.mortbay.j2ee.session.State")) : class$org$mortbay$j2ee$session$State).getMethod("setMaxInactiveInterval", Integer.TYPE);
            _methodToInteger.put(m.getName(), new Integer(index));
            AbstractReplicatedStore._integerToMethod[++index] = m = (class$org$mortbay$j2ee$session$State == null ? (class$org$mortbay$j2ee$session$State = AbstractReplicatedStore.class$("org.mortbay.j2ee.session.State")) : class$org$mortbay$j2ee$session$State).getMethod("setAttribute", class$java$lang$String == null ? (class$java$lang$String = AbstractReplicatedStore.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = AbstractReplicatedStore.class$("java.lang.Object")) : class$java$lang$Object, Boolean.TYPE);
            _methodToInteger.put(m.getName(), new Integer(index));
            AbstractReplicatedStore._integerToMethod[++index] = m = (class$org$mortbay$j2ee$session$State == null ? (class$org$mortbay$j2ee$session$State = AbstractReplicatedStore.class$("org.mortbay.j2ee.session.State")) : class$org$mortbay$j2ee$session$State).getMethod("setAttributes", class$java$util$Map == null ? (class$java$util$Map = AbstractReplicatedStore.class$("java.util.Map")) : class$java$util$Map);
            _methodToInteger.put(m.getName(), new Integer(index));
            AbstractReplicatedStore._integerToMethod[++index] = m = (class$org$mortbay$j2ee$session$State == null ? (class$org$mortbay$j2ee$session$State = AbstractReplicatedStore.class$("org.mortbay.j2ee.session.State")) : class$org$mortbay$j2ee$session$State).getMethod("removeAttribute", class$java$lang$String == null ? (class$java$lang$String = AbstractReplicatedStore.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE);
            _methodToInteger.put(m.getName(), new Integer(index));
            ++index;
        }
        catch (Exception e) {
            System.err.println("AbstractReplicatedStore: something went wrong building dispatch tables");
            e.printStackTrace(System.err);
        }
    }
}

