/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.enhydra.jdbc.standard.StandardConnectionHandle;
import org.enhydra.jdbc.standard.StandardConnectionPoolDataSource;
import org.enhydra.jdbc.util.Logger;

public class StandardPooledConnection
implements PooledConnection {
    protected StandardConnectionPoolDataSource dataSource;
    public Connection con;
    public StandardConnectionHandle connectionHandle;
    Vector listeners;
    boolean isClosed;
    public Logger log;

    public StandardPooledConnection(StandardConnectionPoolDataSource dataSource, String user, String password) throws SQLException {
        this.dataSource = dataSource;
        this.con = dataSource.getConnection(user, password);
        this.listeners = new Vector(5, 5);
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.connectionHandle != null && !this.connectionHandle.isClosed()) {
            this.connectionHandle.close();
        }
        this.newConnectionHandle();
        return this.connectionHandle;
    }

    protected void newConnectionHandle() {
        this.connectionHandle = new StandardConnectionHandle(this, this.dataSource.getMasterPrepStmtCache(), this.dataSource.getPreparedStmtCacheSize());
    }

    public void close() throws SQLException {
        this.con.close();
        this.dataSource.getMasterPrepStmtCache().remove(this.con.toString());
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.removeElement(listener);
    }

    void closeEvent() {
        ConnectionEvent event = new ConnectionEvent(this);
        int i = 0;
        while (i < this.listeners.size()) {
            Object obj = this.listeners.elementAt(i);
            ConnectionEventListener cel = (ConnectionEventListener)obj;
            cel.connectionClosed(event);
            ++i;
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        int i = 0;
        while (i < this.listeners.size()) {
            Object obj = this.listeners.elementAt(i);
            ConnectionEventListener cel = (ConnectionEventListener)obj;
            cel.connectionErrorOccurred(event);
            ++i;
        }
    }

    public Connection getPhysicalConnection() {
        return this.con;
    }

    public void setLogger(Logger alog) {
        this.log = alog;
    }
}

