/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.util.configuration;

import java.util.Properties;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.HandlerFactory;
import org.objectweb.util.monolog.api.LevelFactory;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.objectweb.util.monolog.file.monolog.PropertiesConfAccess;

public class TraceCarol {
    public static final String prefix = "org.objectweb.carol";
    protected static Logger carolLogger = null;
    protected static Logger jndiCarolLogger = null;
    protected static Logger rmiCarolLogger = null;

    public static void configure() {
        Properties props = new Properties();
        try {
            props.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("trace.properties"));
        }
        catch (Exception e) {
            System.err.println("Configuration file for log not found. Traces are disabled: " + e);
            return;
        }
        String lfClassName = props.getProperty("log.config.classname", null);
        if (lfClassName == null) {
            System.err.println("Malformed log configuration file: log.config.classname not available");
            return;
        }
        try {
            LoggerFactory lf = (LoggerFactory)Class.forName(lfClassName).newInstance();
            PropertiesConfAccess.load((Properties)props, (LoggerFactory)lf, (HandlerFactory)((HandlerFactory)lf), (LevelFactory)((LevelFactory)lf));
            TraceCarol.configure(lf);
        }
        catch (Exception e) {
            System.err.println("Logs are disabled:" + e);
        }
    }

    public static void configure(LoggerFactory lf) {
        carolLogger = lf.getLogger(prefix);
        jndiCarolLogger = lf.getLogger("org.objectweb.carol.jndi");
        rmiCarolLogger = lf.getLogger("org.objectweb.carol.rmi");
    }

    public static void verbose(String msg) {
        if (carolLogger != null) {
            carolLogger.log(BasicLevel.INFO, (Object)msg);
        }
    }

    public static void error(String msg) {
        if (carolLogger != null) {
            carolLogger.log(BasicLevel.ERROR, (Object)msg);
        }
    }

    public static void error(String msg, Throwable th) {
        if (carolLogger != null) {
            carolLogger.log(BasicLevel.ERROR, (Object)msg, th);
        }
    }

    public static boolean isDebugCarol() {
        return carolLogger != null && carolLogger.isLoggable(BasicLevel.DEBUG);
    }

    public static void debugCarol(String msg) {
        if (carolLogger != null) {
            carolLogger.log(BasicLevel.DEBUG, (Object)msg);
        }
    }

    public static boolean isDebugJndiCarol() {
        return jndiCarolLogger != null && jndiCarolLogger.isLoggable(BasicLevel.DEBUG);
    }

    public static void debugJndiCarol(String msg) {
        if (jndiCarolLogger != null) {
            jndiCarolLogger.log(BasicLevel.DEBUG, (Object)msg);
        }
    }

    public static boolean isDebugRmiCarol() {
        return rmiCarolLogger != null && rmiCarolLogger.isLoggable(BasicLevel.DEBUG);
    }

    public static void debugRmiCarol(String msg) {
        if (rmiCarolLogger != null) {
            rmiCarolLogger.log(BasicLevel.DEBUG, (Object)msg);
        }
    }
}

