/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jdmk.ClassLoaderRepositorySupport;
import com.sun.jdmk.MBeanInstantiatorImpl;
import com.sun.jdmk.MBeanServerImpl;
import com.sun.jdmk.MBeanServerInt;
import com.sun.jdmk.ModifiableClassLoaderRepository;
import com.sun.jdmk.trace.Trace;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerPermission;
import javax.management.ObjectName;
import javax.management.loading.ClassLoaderRepository;

public class MBeanServerFactory {
    private static final ObjectName delegateName;
    private static final ArrayList mBeanServerList;
    private static final ModifiableClassLoaderRepository loaderRepository;
    private static final ClassLoaderRepository publicLoaderRepository;
    static /* synthetic */ Class class$javax$management$MBeanServerFactory;

    private MBeanServerFactory() {
    }

    public static void releaseMBeanServer(MBeanServer mBeanServer) {
        MBeanServerFactory.checkPermission("releaseMBeanServer");
        MBeanServerFactory.removeMBeanServer(mBeanServer);
    }

    public static MBeanServer createMBeanServer() {
        return MBeanServerFactory.createMBeanServer(null);
    }

    public static MBeanServer createMBeanServer(String string) {
        MBeanServerFactory.checkPermission("createMBeanServer");
        MBeanInstantiatorImpl mBeanInstantiatorImpl = new MBeanInstantiatorImpl(loaderRepository);
        MBeanServerImpl mBeanServerImpl = new MBeanServerImpl(mBeanInstantiatorImpl, string);
        MBeanServerFactory.addMBeanServer(mBeanServerImpl);
        return mBeanServerImpl;
    }

    public static MBeanServer newMBeanServer() {
        return MBeanServerFactory.newMBeanServer(null);
    }

    public static MBeanServer newMBeanServer(String string) {
        MBeanServerFactory.checkPermission("newMBeanServer");
        MBeanInstantiatorImpl mBeanInstantiatorImpl = new MBeanInstantiatorImpl(loaderRepository);
        MBeanServerImpl mBeanServerImpl = new MBeanServerImpl(mBeanInstantiatorImpl, string);
        return mBeanServerImpl;
    }

    public static synchronized ArrayList findMBeanServer(String string) {
        MBeanServerFactory.checkPermission("findMBeanServer");
        if (string == null) {
            return (ArrayList)mBeanServerList.clone();
        }
        ArrayList<MBeanServer> arrayList = new ArrayList<MBeanServer>();
        Iterator iterator = mBeanServerList.iterator();
        while (iterator.hasNext()) {
            MBeanServer mBeanServer = (MBeanServer)iterator.next();
            String string2 = MBeanServerFactory.mBeanServerName(mBeanServer);
            if (!string.equals(string2)) continue;
            arrayList.add(mBeanServer);
        }
        return arrayList;
    }

    public static ClassLoaderRepository getClassLoaderRepository(MBeanServer mBeanServer) {
        if (mBeanServer instanceof MBeanServerInt) {
            return ((MBeanServerInt)((Object)mBeanServer)).getMBeanInstantiator().getClassLoaderRepository();
        }
        return publicLoaderRepository;
    }

    private static String mBeanServerName(MBeanServer mBeanServer) {
        try {
            return (String)mBeanServer.getAttribute(delegateName, "MBeanServerId");
        }
        catch (JMException jMException) {
            return null;
        }
    }

    private static void checkPermission(String string) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            MBeanServerPermission mBeanServerPermission = new MBeanServerPermission(string);
            securityManager.checkPermission(mBeanServerPermission);
        }
    }

    private static synchronized void addMBeanServer(MBeanServer mBeanServer) {
        mBeanServerList.add(mBeanServer);
    }

    private static synchronized void removeMBeanServer(MBeanServer mBeanServer) {
        boolean bl = mBeanServerList.remove(mBeanServer);
        if (!bl) {
            MBeanServerFactory.trace("removeMBeanServer", "MBeanServer was not in list!");
        }
    }

    private static void trace(String string, String string2) {
        if (Trace.isSelected(1, 1)) {
            Trace.send(1, 1, (class$javax$management$MBeanServerFactory == null ? (class$javax$management$MBeanServerFactory = MBeanServerFactory.class$("javax.management.MBeanServerFactory")) : class$javax$management$MBeanServerFactory).getName(), string, string2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ObjectName objectName;
        try {
            objectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (JMException jMException) {
            objectName = null;
            MBeanServerFactory.trace("<clinit>", "internal error creating delegate ObjectName: " + jMException);
        }
        delegateName = objectName;
        mBeanServerList = new ArrayList();
        loaderRepository = new ClassLoaderRepositorySupport();
        publicLoaderRepository = new PublicClassLoaderRepository(loaderRepository);
    }

    private static final class PublicClassLoaderRepository
    implements ClassLoaderRepository {
        private final ClassLoaderRepository clr;

        private PublicClassLoaderRepository(ClassLoaderRepository classLoaderRepository) {
            this.clr = classLoaderRepository;
        }

        public Class loadClass(String string) throws ClassNotFoundException {
            return this.clr.loadClass(string);
        }

        public Class loadClassWithout(ClassLoader classLoader, String string) throws ClassNotFoundException {
            return this.clr.loadClassWithout(classLoader, string);
        }
    }
}

