/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm.log;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import javax.transaction.xa.Xid;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.log.LogWriter;

public class FileLogWriter
implements LogWriter {
    private static int logsIndex = 0;
    private static Hashtable logs = new Hashtable();
    private static Hashtable logFiles = new Hashtable();

    public FileLogWriter() {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"public constructor");
        }
        File file = new File("logs");
        boolean result = file.mkdir();
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("logs directory created=" + result));
        }
    }

    public void begin(Xid xid) {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("xid=" + xid));
        }
        try {
            File file = new File("logs" + File.separator + logsIndex + ".log");
            FileWriter fw = new FileWriter(file);
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("log file=" + logsIndex + ".log"));
            }
            ++logsIndex;
            logs.put(xid, fw);
            logFiles.put(xid, file);
            fw.write("BEGIN - " + xid + "\n");
            fw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void startVote(Xid xid) {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("xid=" + xid));
        }
        FileWriter fw = (FileWriter)logs.get(xid);
        try {
            fw.write("START_VOTE - " + xid + "\n");
            fw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void endVote(Xid xid, int vote) {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("xid=" + xid + ", vote=" + vote));
        }
        FileWriter fw = (FileWriter)logs.get(xid);
        try {
            fw.write("END_VOTE - " + xid + ", " + vote + "\n");
            fw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void startCommit(Xid xid, boolean twoPhaseCommit) {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("xid=" + xid + ", twoPhaseCommit=" + twoPhaseCommit));
        }
        FileWriter fw = (FileWriter)logs.get(xid);
        try {
            fw.write("START_COMMIT - " + xid + ", " + twoPhaseCommit + "\n");
            fw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void endCommit(Xid xid, int heuristicDecision) {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("xid=" + xid + ", heuristicDecision=" + heuristicDecision));
        }
        FileWriter fw = (FileWriter)logs.get(xid);
        try {
            fw.write("END_COMMIT - " + xid + ", " + heuristicDecision + "\n");
            fw.flush();
            this.flushLog(xid);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void startRollback(Xid xid) {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("xid=" + xid));
        }
        FileWriter fw = (FileWriter)logs.get(xid);
        try {
            fw.write("START_ROLLBACK - " + xid + "\n");
            fw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void endRollback(Xid xid) {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("xid=" + xid));
        }
        FileWriter fw = (FileWriter)logs.get(xid);
        try {
            fw.write("END_ROLLBACK - " + xid + "\n");
            fw.flush();
            this.flushLog(xid);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void flushLog(Xid xid) {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("xid=" + xid));
        }
        FileWriter fw = (FileWriter)logs.get(xid);
        try {
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logs.remove(xid);
        File file = (File)logFiles.get(xid);
        file.delete();
        logFiles.remove(xid);
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("file deleted (file=" + file + ")"));
        }
    }

    public String toString() {
        return "[logsIndex=" + logsIndex + ", logs=" + logs.toString() + "]";
    }
}

