/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi.compiler;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.objectweb.carol.cmi.compiler.CompilerException;
import org.objectweb.carol.cmi.compiler.Conf;
import org.objectweb.carol.cmi.compiler.MethodProto;
import org.objectweb.carol.cmi.compiler.TemplateCompiler;
import org.objectweb.carol.cmi.compiler.Utils;

public class Compiler {
    private boolean keep = false;
    private boolean noc = false;
    private String compiler = "javac";
    private String classPath = null;
    private String genConf = null;
    private ArrayList conf = new ArrayList();
    private ArrayList classes = new ArrayList();
    private String srcDir = null;
    private String destDir = ".";
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private static MethodComparator methodComparator = new MethodComparator();
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$org$objectweb$carol$cmi$compiler$Compiler;

    public void configure(String[] args) throws CompilerException {
        int i = 0;
        while (i < args.length) {
            String arg;
            if ((arg = args[i++]).equals("-keep") || arg.equals("-keepgenerated")) {
                this.keep = true;
                continue;
            }
            if (arg.equals("-noc")) {
                this.noc = true;
                continue;
            }
            if (arg.equals("-c")) {
                if (i == args.length) {
                    throw new CompilerException("-c : missing argument");
                }
                this.compiler = args[i++];
                continue;
            }
            if (arg.equals("-classpath")) {
                if (i == args.length) {
                    throw new CompilerException("-classpath : missing argument");
                }
                this.classPath = args[i++];
                continue;
            }
            if (arg.equals("-genconf")) {
                if (i == args.length) {
                    throw new CompilerException("-genconf : missing argument");
                }
                this.genConf = args[i++];
                continue;
            }
            if (arg.equals("-conf")) {
                if (i == args.length) {
                    throw new CompilerException("-conf : missing argument");
                }
                this.conf.add(args[i++]);
                continue;
            }
            if (arg.equals("-d")) {
                if (i == args.length) {
                    throw new CompilerException("-d : missing argument");
                }
                this.destDir = args[i++];
                continue;
            }
            if (arg.equals("-s")) {
                if (i == args.length) {
                    throw new CompilerException("-s : missing argument");
                }
                this.srcDir = args[i++];
                continue;
            }
            if (arg.startsWith("-")) {
                throw new CompilerException(arg + ": unknown option");
            }
            this.classes.add(arg);
        }
        if (this.srcDir == null) {
            this.srcDir = this.destDir;
        }
        if (this.noc) {
            this.keep = true;
        }
        if (this.classPath != null) {
            this.classLoader = Compiler.buildClassLoader(this.classPath);
        }
    }

    public void run() throws CompilerException {
        if (this.genConf != null) {
            if (this.conf.size() != 0) {
                System.err.println("options -conf and -genconf are not compatible");
                System.exit(1);
            }
            this.generateClusterConfExample();
        } else {
            Conf cconf = new Conf(this.classLoader, this.classes);
            Iterator i = this.conf.iterator();
            while (i.hasNext()) {
                cconf.loadConfig((String)i.next());
            }
            i = this.classes.iterator();
            while (i.hasNext()) {
                String className = (String)i.next();
                if (className == null || className == "") {
                    throw new CompilerException("Empty class name to compile");
                }
                TemplateCompiler tc = new TemplateCompiler(this, cconf.getClassConf(className));
                this.compileAndRemove(tc.genConfig());
                this.compileAndRemove(tc.genStub());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileAndRemove(String fileName) throws CompilerException {
        try {
            if (!this.noc) {
                Utils.compileFile(this, fileName);
            }
        }
        finally {
            File f;
            if (!this.keep && (f = new File(fileName)).exists()) {
                f.delete();
            }
        }
    }

    private void generateClusterConfExample() throws CompilerException {
        try {
            FileWriter f = new FileWriter(this.genConf);
            f.write("<!DOCTYPE cluster-config PUBLIC\n");
            f.write("\t\"\"\n");
            f.write("\t\"cluster-config-0.2.dtd\">\n\n");
            f.write("<cluster-config>\n\n");
            Iterator i = this.classes.iterator();
            while (i.hasNext()) {
                Class cl;
                String className = (String)i.next();
                try {
                    cl = this.loadClass(className);
                }
                catch (ClassNotFoundException e1) {
                    throw new CompilerException("class not found " + className, e1);
                }
                f.write("<class>\n\t<name>" + className + "</name>\n");
                Method[] remMths = Compiler.getRemoteMethods(cl);
                int j = 0;
                while (j < remMths.length) {
                    f.write("\t<method>\n\t\t<signature>");
                    f.write(new MethodProto(remMths[j]).toString());
                    f.write("</signature>\n\t\t<rr/>\n\t</method>\n");
                    ++j;
                }
                f.write("</class>\n\n");
            }
            f.write("</cluster-config>\n");
            f.close();
        }
        catch (IOException e) {
            throw new CompilerException(this.genConf, e);
        }
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.classLoader.loadClass(className);
    }

    public static boolean isRemoteItf(Class cl) {
        if (!cl.isInterface() || !(class$java$rmi$Remote == null ? (class$java$rmi$Remote = Compiler.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(cl)) {
            return false;
        }
        Method[] m = cl.getMethods();
        int i = 0;
        while (i < m.length) {
            Class<?>[] ex = m[i].getExceptionTypes();
            int j = 0;
            while (j < ex.length && !(class$java$rmi$RemoteException == null ? Compiler.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).isAssignableFrom(ex[j])) {
                ++j;
            }
            if (j == ex.length) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Set getRemoteItfs(Class cl) {
        HashSet remItfs = new HashSet();
        while (cl != null) {
            Class<?>[] itfs = cl.getInterfaces();
            if (Compiler.isRemoteItf(cl)) {
                remItfs.add(cl);
            }
            int i = 0;
            while (i < itfs.length) {
                Class<?> itf = itfs[i];
                if (Compiler.isRemoteItf(itf)) {
                    remItfs.add(itf);
                }
                ++i;
            }
            cl = cl.getSuperclass();
        }
        return remItfs;
    }

    public static Method[] getRemoteMethods(Class cl) {
        int i;
        TreeSet<Method> remMethods = new TreeSet<Method>(methodComparator);
        Set itfs = Compiler.getRemoteItfs(cl);
        TreeSet<Method> itfMethods = new TreeSet<Method>(methodComparator);
        Iterator it = itfs.iterator();
        while (it.hasNext()) {
            Class itf = (Class)it.next();
            Method[] m = itf.getMethods();
            i = 0;
            while (i < m.length) {
                itfMethods.add(m[i]);
                ++i;
            }
        }
        TreeSet<Method> clMethods = new TreeSet<Method>(methodComparator);
        Method[] methods = cl.getMethods();
        i = 0;
        while (i < methods.length) {
            clMethods.add(methods[i]);
            ++i;
        }
        Iterator i1 = clMethods.iterator();
        Iterator i2 = itfMethods.iterator();
        if (i1.hasNext() && i2.hasNext()) {
            Method m1 = (Method)i1.next();
            Method m2 = (Method)i2.next();
            do {
                int d;
                if ((d = methodComparator.compare(m1, m2)) > 0) {
                    m2 = i2.hasNext() ? (Method)i2.next() : null;
                    continue;
                }
                if (d < 0) {
                    m1 = i1.hasNext() ? (Method)i1.next() : null;
                    continue;
                }
                remMethods.add(m2);
                m1 = i1.hasNext() ? (Method)i1.next() : null;
                Method method = m2 = i2.hasNext() ? (Method)i2.next() : null;
            } while (m1 != null && m2 != null);
        }
        int i3 = remMethods.size();
        Method[] m = new Method[i3];
        it = remMethods.iterator();
        i3 = 0;
        while (it.hasNext()) {
            m[i3++] = (Method)it.next();
        }
        return m;
    }

    public static ClassLoader buildClassLoader(String classPath) {
        String classpath = classPath + System.getProperty("path.separator", "") + System.getProperty("java.class.path", "");
        Vector<URL> nurls = new Vector<URL>();
        StringTokenizer st = new StringTokenizer(classpath, System.getProperty("path.separator", ""));
        while (st.hasMoreTokens()) {
            String url = st.nextToken();
            if (url.equals("")) continue;
            try {
                URL u = new File(url).toURL();
                nurls.addElement(u);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (nurls.size() == 0) {
            return Thread.currentThread().getContextClassLoader();
        }
        Object[] urls = new URL[nurls.size()];
        nurls.copyInto(urls);
        return new URLClassLoader((URL[])urls, null);
    }

    public static void usage() {
        System.out.println("Usage: java " + (class$org$objectweb$carol$cmi$compiler$Compiler == null ? (class$org$objectweb$carol$cmi$compiler$Compiler = Compiler.class$("org.objectweb.carol.cmi.compiler.Compiler")) : class$org$objectweb$carol$cmi$compiler$Compiler).getName() + " [options] [class names]");
        System.out.println();
        System.out.println("Options:\n  -keep                do not delete generated source files\n  -keepgenerated       same as -keep\n  -noc                 do not compile generated source files (implies -keep)\n  -c <java compiler>   compile generated source files with this java compiler\n                       (defaults to javac)\n  -classpath <path>    extra classpath passed to -c compiler\n  -d <directory>       root directory for generated class files                        (defaults to current directory)\n  -s <directory>       root directory for generated source files\n                       (defaults to -d directory)\n  -conf <xml-file>     specify the XML configuration file to use\n  -genconf <xml-file>  generate an XML configuration file example\n");
    }

    public static void generate(String[] args) throws CompilerException {
        Compiler cc = new Compiler();
        cc.configure(args);
        cc.run();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Compiler.usage();
            return;
        }
        try {
            Compiler.generate(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public String getSrcDir() {
        return this.srcDir;
    }

    public boolean isCompile() {
        return !this.noc;
    }

    public String getCompiler() {
        return this.compiler;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public String getClassPath() {
        return this.classPath;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class MethodComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Method m1 = (Method)o1;
            Method m2 = (Method)o2;
            int r = m1.getName().compareTo(m2.getName());
            if (r != 0) {
                return r;
            }
            Class<?>[] p1 = m1.getParameterTypes();
            Class<?>[] p2 = m2.getParameterTypes();
            int i = 0;
            while (i < p1.length && i < p2.length) {
                r = p1[i].getName().compareTo(p2[i].getName());
                if (r != 0) {
                    return r;
                }
                ++i;
            }
            if (i == p1.length) {
                if (i == p2.length) {
                    return 0;
                }
                return -1;
            }
            return 1;
        }
    }
}

