/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.loadbalancer;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.loadbalancer.ByteBufferPool;
import org.mortbay.loadbalancer.Connection;
import org.mortbay.loadbalancer.Policy;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.LifeCycleThread;
import org.mortbay.util.LogSupport;

public class Listener
extends LifeCycleThread {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$loadbalancer$Listener == null ? (class$org$mortbay$loadbalancer$Listener = Listener.class$("org.mortbay.loadbalancer.Listener")) : class$org$mortbay$loadbalancer$Listener));
    Policy _policy;
    Selector _selector;
    ServerSocketChannel _acceptChannel;
    InetSocketAddress _address;
    ByteBufferPool _bufferPool;
    static /* synthetic */ Class class$org$mortbay$loadbalancer$Listener;

    public Listener() throws IOException {
    }

    public Listener(ByteBufferPool pool, InetSocketAddress address, Policy policy) throws IOException {
        this._address = address;
        this._bufferPool = pool;
        this._policy = policy;
    }

    public Listener(ByteBufferPool pool, InetAddrPort address, Policy policy) throws IOException {
        this._address = new InetSocketAddress(address.getInetAddress(), address.getPort());
        this._bufferPool = pool;
        this._policy = policy;
    }

    public Selector getSelector() {
        return this._selector;
    }

    public Policy getPolicy() {
        return this._policy;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this._address;
    }

    public void setInetSocketAddress(InetSocketAddress address) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._address = address;
    }

    public ByteBufferPool getBufferPool() {
        return this._bufferPool;
    }

    public void setBufferPool(ByteBufferPool bufferPool) {
        this._bufferPool = bufferPool;
    }

    public void start() throws Exception {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        if (this._bufferPool == null) {
            throw new IllegalStateException("No BufferPool");
        }
        this._acceptChannel = ServerSocketChannel.open();
        this._acceptChannel.configureBlocking(false);
        this._acceptChannel.socket().bind(this._address);
        log.info((Object)("Listening on " + this._acceptChannel));
        this._selector = Selector.open();
        this._acceptChannel.register(this._selector, 16);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Selector " + this._selector));
        }
        super.start();
    }

    public void stop() throws InterruptedException {
        super.stop();
        try {
            this._selector.close();
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
        try {
            this._acceptChannel.close();
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
    }

    public void loop() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("client keys=" + this._selector.keys()));
        }
        if (this._selector.select() > 0) {
            Set<SelectionKey> ready = this._selector.selectedKeys();
            Iterator<SelectionKey> iter = ready.iterator();
            while (iter.hasNext()) {
                SelectionKey key = iter.next();
                iter.remove();
                SelectableChannel channel = key.channel();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Ready key " + key + " for " + channel));
                }
                if (!channel.isOpen()) {
                    key.cancel();
                    continue;
                }
                if (channel instanceof ServerSocketChannel) {
                    SocketChannel socket_channel = ((ServerSocketChannel)channel).accept();
                    socket_channel.configureBlocking(false);
                    socket_channel.socket().setTcpNoDelay(true);
                    Connection connection = new Connection(this._bufferPool, this, socket_channel, 16);
                    socket_channel.register(this._selector, 1, connection);
                    continue;
                }
                if (!(channel instanceof SocketChannel)) continue;
                Connection connection = (Connection)key.attachment();
                try {
                    if ((key.interestOps() & 4) != 0) {
                        connection.clientWriteWakeup(key);
                        continue;
                    }
                    if ((key.interestOps() & 1) == 0) continue;
                    connection.client2server(key);
                }
                catch (ClosedChannelException e) {
                    LogSupport.ignore((Log)log, (Throwable)e);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

