/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.loadbalancer;

public class NonBlockingQueue {
    private Object[] _queue;
    private int _pos;
    private int _size;

    public NonBlockingQueue(int capacity) {
        this._queue = new Object[capacity];
        this._pos = 0;
        this._size = 0;
    }

    public int size() {
        return this._size;
    }

    public boolean isFull() {
        return this._size == this._queue.length;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public synchronized boolean queue(Object o) {
        if (this.isFull()) {
            return false;
        }
        this._queue[(this._pos + this._size) % this._queue.length] = o;
        ++this._size;
        return true;
    }

    public synchronized Object peek() {
        if (this._size == 0) {
            throw new IllegalStateException("Empty");
        }
        return this._queue[this._pos];
    }

    public synchronized Object next() {
        if (this._size == 0) {
            throw new IllegalStateException("Empty");
        }
        Object o = this._queue[this._pos];
        --this._size;
        this._pos = (this._pos + 1) % this._queue.length;
        return o;
    }
}

