/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.j2ee.session;

import java.rmi.RemoteException;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.jboss.logging.Logger;
import org.mortbay.j2ee.session.Manager;
import org.mortbay.j2ee.session.State;
import org.mortbay.j2ee.session.StateInterceptor;
import org.mortbay.jetty.servlet.SessionManager;

public class StateAdaptor
implements SessionManager.Session {
    protected static final Logger _log = Logger.getLogger((Class)(class$org$mortbay$j2ee$session$StateAdaptor == null ? (class$org$mortbay$j2ee$session$StateAdaptor = StateAdaptor.class$("org.mortbay.j2ee.session.StateAdaptor")) : class$org$mortbay$j2ee$session$StateAdaptor));
    Manager _manager;
    State _state = null;
    boolean _new = true;
    final String _id;
    static /* synthetic */ Class class$org$mortbay$j2ee$session$StateAdaptor;

    StateAdaptor(String id, Manager manager, int maxInactiveInterval, long lastAccessedTime) {
        this._id = id;
        this._manager = manager;
    }

    void setState(State state) {
        this._state = state;
    }

    State getState() {
        return this._state;
    }

    public boolean isValid() {
        if (this._state == null) {
            return false;
        }
        StateInterceptor si = (StateInterceptor)this._state;
        si.setManager(this._manager);
        si.setSession((HttpSession)this);
        try {
            this._state.getLastAccessedTime();
            return true;
        }
        catch (IllegalStateException ignore) {
            return false;
        }
        catch (Exception e) {
            _log.error((Object)"problem contacting HttpSession", (Throwable)e);
            return false;
        }
    }

    public long getCreationTime() throws IllegalStateException {
        this.checkState();
        try {
            return this._state.getCreationTime();
        }
        catch (RemoteException e) {
            _log.error((Object)"could not get CreationTime", (Throwable)e);
            throw new IllegalStateException("problem with distribution layer");
        }
    }

    public String getId() throws IllegalStateException {
        this.checkState();
        return this._id;
    }

    public long getLastAccessedTime() throws IllegalStateException {
        this.checkState();
        try {
            return this._state.getLastAccessedTime();
        }
        catch (RemoteException e) {
            _log.error((Object)"could not get LastAccessedTime", (Throwable)e);
            throw new IllegalStateException("problem with distribution layer");
        }
    }

    public void setMaxInactiveInterval(int interval) {
        this.checkState();
        try {
            this._state.setMaxInactiveInterval(interval);
        }
        catch (RemoteException e) {
            _log.error((Object)"could not set MaxInactiveInterval", (Throwable)e);
        }
    }

    public int getMaxInactiveInterval() {
        this.checkState();
        try {
            return this._state.getMaxInactiveInterval();
        }
        catch (RemoteException e) {
            _log.error((Object)"could not get MaxInactiveInterval", (Throwable)e);
            return 0;
        }
    }

    public Object getAttribute(String name) throws IllegalStateException {
        this.checkState();
        try {
            return this._state.getAttribute(name);
        }
        catch (RemoteException e) {
            _log.error((Object)"could not get Attribute", (Throwable)e);
            throw new IllegalStateException("problem with distribution layer");
        }
    }

    public Object getValue(String name) throws IllegalStateException {
        this.checkState();
        try {
            return this._state.getAttribute(name);
        }
        catch (RemoteException e) {
            _log.error((Object)"could not get Value", (Throwable)e);
            throw new IllegalStateException("problem with distribution layer");
        }
    }

    public Enumeration getAttributeNames() throws IllegalStateException {
        this.checkState();
        try {
            return this._state.getAttributeNameEnumeration();
        }
        catch (RemoteException e) {
            _log.error((Object)"could not get AttributeNames", (Throwable)e);
            throw new IllegalStateException("problem with distribution layer");
        }
    }

    public String[] getValueNames() throws IllegalStateException {
        this.checkState();
        try {
            return this._state.getAttributeNameStringArray();
        }
        catch (RemoteException e) {
            _log.error((Object)"could not get ValueNames", (Throwable)e);
            throw new IllegalStateException("problem with distribution layer");
        }
    }

    public void setAttribute(String name, Object value) throws IllegalStateException {
        this.checkState();
        try {
            if (value == null) {
                this._state.removeAttribute(name, false);
            } else {
                if (name == null) {
                    throw new IllegalArgumentException("invalid attribute name: " + name);
                }
                this._state.setAttribute(name, value, false);
            }
        }
        catch (RemoteException e) {
            _log.error((Object)"could not set Attribute", (Throwable)e);
            throw new IllegalStateException("problem with distribution layer");
        }
    }

    public void putValue(String name, Object value) throws IllegalStateException {
        this.checkState();
        if (name == null) {
            throw new IllegalArgumentException("invalid attribute name: " + name);
        }
        if (value == null) {
            throw new IllegalArgumentException("invalid attribute value: " + value);
        }
        try {
            this._state.setAttribute(name, value, false);
        }
        catch (RemoteException e) {
            _log.error((Object)"could not put Value", (Throwable)e);
            throw new IllegalStateException("problem with distribution layer");
        }
    }

    public void removeAttribute(String name) throws IllegalStateException {
        this.checkState();
        try {
            this._state.removeAttribute(name, false);
        }
        catch (RemoteException e) {
            _log.error((Object)"could not remove Attribute", (Throwable)e);
            throw new IllegalStateException("problem with distribution layer");
        }
    }

    public void removeValue(String name) throws IllegalStateException {
        this.checkState();
        try {
            this._state.removeAttribute(name, false);
        }
        catch (RemoteException e) {
            _log.error((Object)"could not remove Value", (Throwable)e);
            throw new IllegalStateException("problem with distribution layer");
        }
    }

    public void invalidate() throws IllegalStateException {
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("user invalidated session: " + this.getId()));
        }
        this._manager.destroySession((HttpSession)this);
    }

    public boolean isNew() throws IllegalStateException {
        return this._new;
    }

    public ServletContext getServletContext() {
        return this._manager.getServletContext();
    }

    public HttpSessionContext getSessionContext() {
        return this._manager.getSessionContext();
    }

    public void access() {
        long time = System.currentTimeMillis();
        this.setLastAccessedTime(time);
        this._new = false;
    }

    public void setLastAccessedTime(long time) throws IllegalStateException {
        this.checkState();
        try {
            this._state.setLastAccessedTime(time);
        }
        catch (RemoteException e) {
            _log.error((Object)"could not set LastAccessedTime", (Throwable)e);
            throw new IllegalStateException("problem with distribution layer");
        }
    }

    protected void checkState() throws IllegalStateException {
        if (this._state == null) {
            throw new IllegalStateException("invalid session");
        }
        StateInterceptor si = (StateInterceptor)this._state;
        si.setManager(this._manager);
        si.setSession((HttpSession)this);
    }

    public String toString() {
        return "<" + this.getClass() + "->" + this._state + ">";
    }

    public void migrate() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

