/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi;

import java.util.Collection;
import java.util.Iterator;
import org.objectweb.carol.cmi.ClusterStubData;
import org.objectweb.carol.cmi.NoMoreStubException;
import org.objectweb.carol.cmi.SecureRandom;
import org.objectweb.carol.cmi.StubData;
import org.objectweb.carol.cmi.StubLB;
import org.objectweb.carol.cmi.StubLBFilter;

public class RoundRobin
extends StubLB {
    private ClusterStubData csd;
    private int len;
    private StubData[] sd;
    private double[] load;
    private double minLoad;
    private static StubLBFilter emptyFilter = new StubLBFilter();

    public RoundRobin(ClusterStubData csd, Collection c) {
        this.csd = csd;
        this.len = c.size();
        this.sd = new StubData[this.len];
        this.load = new double[this.len];
        Iterator it = c.iterator();
        int i = 0;
        while (i < this.len) {
            StubData s;
            this.sd[i] = s = (StubData)it.next();
            ++i;
        }
        int i2 = 0;
        while (i2 < SecureRandom.getInt(this.len)) {
            this.load[i2] = this.sd[i2].getLoadIncr();
            ++i2;
        }
    }

    private synchronized void ensureCapacity(int minCapacity) {
        int old = this.sd.length;
        if (old >= minCapacity) {
            return;
        }
        int l = old * 3 / 2 + 1;
        if (l < minCapacity) {
            l = minCapacity;
        }
        StubData[] nsd = new StubData[l];
        double[] nload = new double[l];
        System.arraycopy(this.sd, 0, nsd, 0, old);
        System.arraycopy(this.load, 0, nload, 0, old);
        this.sd = nsd;
        this.load = nload;
    }

    synchronized void add(StubData sd) {
        this.ensureCapacity(this.len + 1);
        this.sd[this.len] = sd;
        this.load[this.len] = this.minLoad;
        ++this.len;
    }

    synchronized void removeCallback(StubData s) {
        int i = 0;
        while (i < this.len) {
            if (this.sd[i] == s) {
                --this.len;
                this.sd[i] = this.sd[this.len];
                this.sd[this.len] = null;
                this.load[i] = this.load[this.len];
                return;
            }
            ++i;
        }
    }

    public synchronized StubData get() throws NoMoreStubException {
        return this.get(emptyFilter);
    }

    public synchronized StubData get(StubLBFilter f) throws NoMoreStubException {
        double min = Double.MAX_VALUE;
        double minOk = Double.MAX_VALUE;
        int index = -1;
        int i = 0;
        while (i < this.len) {
            double l = this.load[i];
            if (l < minOk) {
                if (!f.contains(this.sd[i])) {
                    minOk = l;
                    index = i;
                }
                if (l < min) {
                    min = l;
                }
            }
            ++i;
        }
        if (index < 0) {
            throw new NoMoreStubException();
        }
        if (min >= 100.0) {
            int i2 = 0;
            while (i2 < this.len) {
                int n = i2++;
                this.load[n] = this.load[n] - min;
            }
            min = 0.0;
        }
        StubData s = this.sd[index];
        int n = index;
        this.load[n] = this.load[n] + s.getLoadIncr();
        return s;
    }

    public void remove(StubData s) {
        this.csd.removeStubData(s);
    }
}

