/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import com.sun.mail.util.LineInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UUDecoderStream
extends FilterInputStream {
    private String name;
    private int mode;
    private byte[] buffer;
    private int bufsize;
    private int index;
    private boolean gotPrefix = false;
    private LineInputStream lin;

    public UUDecoderStream(InputStream inputStream) {
        super(inputStream);
        this.lin = new LineInputStream(inputStream);
        this.buffer = new byte[45];
    }

    public int read() throws IOException {
        if (this.index >= this.bufsize) {
            this.readPrefix();
            if (!this.decode()) {
                return -1;
            }
            this.index = 0;
        }
        return this.buffer[this.index++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read();
            if (n4 == -1) {
                if (n3 != 0) break;
                n3 = -1;
                break;
            }
            byArray[n + n3] = (byte)n4;
            ++n3;
        }
        return n3;
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        return this.in.available() * 3 / 4 + (this.bufsize - this.index);
    }

    public String getName() throws IOException {
        this.readPrefix();
        return this.name;
    }

    public int getMode() throws IOException {
        this.readPrefix();
        return this.mode;
    }

    private void readPrefix() throws IOException {
        String string;
        if (this.gotPrefix) {
            return;
        }
        do {
            if ((string = this.lin.readLine()) != null) continue;
            throw new IOException("UUDecoder error: No Begin");
        } while (!string.regionMatches(true, 0, "begin", 0, 5));
        try {
            this.mode = Integer.parseInt(string.substring(6, 9));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("UUDecoder error: " + numberFormatException.toString());
        }
        this.name = string.substring(10);
        this.gotPrefix = true;
    }

    private boolean decode() throws IOException {
        String string;
        this.bufsize = 0;
        do {
            if ((string = this.lin.readLine()) == null) {
                throw new IOException("Missing End");
            }
            if (!string.regionMatches(true, 0, "end", 0, 3)) continue;
            return false;
        } while (string.length() == 0);
        int n = string.charAt(0);
        if (n < 32) {
            throw new IOException("Buffer format error");
        }
        if ((n = n - 32 & 0x3F) == 0) {
            string = this.lin.readLine();
            if (string == null || !string.regionMatches(true, 0, "end", 0, 3)) {
                throw new IOException("Missing End");
            }
            return false;
        }
        int n2 = (n * 8 + 5) / 6;
        if (string.length() < n2 + 1) {
            throw new IOException("Short buffer error");
        }
        int n3 = 1;
        while (this.bufsize < n) {
            byte by = (byte)(string.charAt(n3++) - 32 & 0x3F);
            byte by2 = (byte)(string.charAt(n3++) - 32 & 0x3F);
            this.buffer[this.bufsize++] = (byte)(by << 2 & 0xFC | by2 >>> 4 & 3);
            if (this.bufsize < n) {
                by = by2;
                by2 = (byte)(string.charAt(n3++) - 32 & 0x3F);
                this.buffer[this.bufsize++] = (byte)(by << 4 & 0xF0 | by2 >>> 2 & 0xF);
            }
            if (this.bufsize >= n) continue;
            by = by2;
            by2 = (byte)(string.charAt(n3++) - 32 & 0x3F);
            this.buffer[this.bufsize++] = (byte)(by << 6 & 0xC0 | by2 & 0x3F);
        }
        return true;
    }
}

