/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.nio.ByteBuffer;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.rmi.PortableRemoteObject;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.objectweb.howl.log.xa.XACommittingTx;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.HeuristicCommit;
import org.objectweb.jotm.Resource;
import org.objectweb.jotm.SLog;
import org.objectweb.jotm.StatusHelper;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionImpl;
import org.objectweb.jotm.TransactionRecoveryImpl;
import org.objectweb.jotm.Xid;
import org.objectweb.jotm.XidImpl;

public class SubCoordinator
extends PortableRemoteObject
implements Resource {
    private TransactionImpl tx = null;
    private Vector synchroList = new Vector();
    private Vector resourceList = new Vector();
    private Vector javaxxidList = new Vector();
    private TransactionManager tm;
    private Xid xid = null;
    private SLog log = null;
    private int status = 0;
    private boolean beforeCompletionDone = false;

    SubCoordinator(TransactionImpl tx, Xid xid) throws RemoteException {
        TraceTm.jta.debug((Object)("tx=" + tx + ",  xid=" + xid));
        this.tx = tx;
        this.xid = xid;
        this.tm = Current.getTransactionManager();
        Current.getCurrent().incrementBeginCounter();
    }

    public int prepare() throws RemoteException {
        block10: {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
            }
            try {
                this.tx.doDetach(0x4000000);
            }
            catch (SystemException e) {
                if (!TraceTm.jta.isDebugEnabled()) break block10;
                String error = "Error when detaching XAResource:" + (Object)((Object)e) + "--" + e.getMessage();
                TraceTm.jta.debug((Object)error);
            }
        }
        switch (this.status) {
            case 1: {
                this.doBeforeCompletion(false);
                this.doRollback();
                return 1;
            }
            case 3: {
                return 0;
            }
        }
        this.doBeforeCompletion(true);
        if (this.status == 1) {
            TraceTm.jotm.info((Object)"Rollback during beforeCompletion in SubCoordinator.prepare");
            this.doRollback();
            return 1;
        }
        int ret = this.doPrepare();
        if (ret == 2) {
            this.doAfterCompletion();
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("vote = " + ret));
        }
        return ret;
    }

    public void rollback() throws RemoteException {
        block8: {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
            }
            try {
                this.tx.doDetach(0x4000000);
            }
            catch (SystemException e) {
                if (!TraceTm.jta.isDebugEnabled()) break block8;
                String error = "Error when detaching XAResource:" + (Object)((Object)e) + "--" + e.getMessage();
                TraceTm.jta.debug((Object)error);
            }
        }
        switch (this.status) {
            case 0: 
            case 1: 
            case 9: {
                TraceTm.jotm.debug((Object)"transaction rolling back");
                break;
            }
            case 2: {
                TraceTm.jotm.debug((Object)"should not rollback a prepared transaction");
                break;
            }
            case 4: {
                TraceTm.jotm.debug((Object)"already rolledback");
                return;
            }
            default: {
                TraceTm.jotm.error((Object)("rollback: bad status: " + StatusHelper.getStatusName(this.status)));
                return;
            }
        }
        this.doBeforeCompletion(false);
        this.doRollback();
    }

    public void commit() throws RemoteException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
        }
        switch (this.status) {
            case 2: {
                break;
            }
            default: {
                TraceTm.jotm.error((Object)("commit: bad status: " + StatusHelper.getStatusName(this.status)));
                return;
            }
        }
        this.doCommit();
    }

    public void commit_one_phase() throws RemoteException {
        block16: {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
            }
            try {
                this.tx.doDetach(0x4000000);
            }
            catch (SystemException e) {
                if (!TraceTm.jta.isDebugEnabled()) break block16;
                String error = "Error when detaching XAResource:" + (Object)((Object)e) + "--" + e.getMessage();
                TraceTm.jta.debug((Object)error);
            }
        }
        switch (this.status) {
            case 4: {
                throw new TransactionRolledbackException();
            }
            case 1: {
                this.doBeforeCompletion(false);
                this.doRollback();
                throw new TransactionRolledbackException();
            }
            case 3: {
                return;
            }
        }
        this.doBeforeCompletion(true);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
        }
        if (this.status == 1) {
            TraceTm.jotm.info((Object)"Rollback during beforeCompletion in SubCoordinator.commit_one_phase");
            this.doRollback();
            throw new TransactionRolledbackException();
        }
        if (this.resourceList.size() == 1) {
            this.doOnePhaseCommit();
            return;
        }
        int vote = this.doPrepare();
        switch (vote) {
            case 0: {
                this.doCommit();
                break;
            }
            case 2: {
                this.doAfterCompletion();
                break;
            }
            case 1: {
                this.doRollback();
                throw new TransactionRolledbackException();
            }
        }
    }

    public void forget() throws RemoteException {
        TraceTm.jta.debug((Object)"SubCoordinator.forget()");
        this.doForget();
    }

    public void addSynchronization(Synchronization synchro) throws RollbackException, IllegalStateException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("synchro=" + synchro));
            TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
        }
        boolean markedRollback = false;
        switch (this.status) {
            case 1: 
            case 4: {
                markedRollback = true;
                break;
            }
            case 0: {
                break;
            }
            default: {
                String errorMsg = "addSynchronization: bad status = " + StatusHelper.getStatusName(this.status);
                TraceTm.jotm.error((Object)errorMsg);
                throw new IllegalStateException(errorMsg);
            }
        }
        this.synchroList.addElement(synchro);
        if (markedRollback) {
            TraceTm.jta.debug((Object)"SubCoordinator.addSynchronization: transaction rollback only");
            throw new RollbackException();
        }
    }

    public synchronized boolean addResource(XAResource xares) throws IllegalStateException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("xares=" + xares));
            TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
        }
        boolean markedRollback = false;
        switch (this.status) {
            case 1: {
                markedRollback = true;
                break;
            }
            case 0: {
                break;
            }
            default: {
                String errorMsg = "SubCoordinator.addResource: bad status= " + StatusHelper.getStatusName(this.status);
                TraceTm.jotm.error((Object)errorMsg);
                throw new IllegalStateException(errorMsg);
            }
        }
        boolean found = false;
        for (int i = 0; i < this.resourceList.size(); ++i) {
            XAResource res = (XAResource)this.resourceList.elementAt(i);
            try {
                if (!res.isSameRM(xares)) continue;
                found = true;
                break;
            }
            catch (XAException e) {
                String error = "Cannot send res.isSameRM:" + e + " (error code = " + e.errorCode + ") --" + e.getMessage();
                TraceTm.jotm.error((Object)("Exception on resource.isSameRM: " + error));
            }
        }
        if (!found) {
            TraceTm.jta.debug((Object)"new XAResource added to the list");
            this.resourceList.addElement(xares);
        }
        if (markedRollback) {
            TraceTm.jta.debug((Object)"SubCoordinator.addResource: transaction set rollback only");
        }
        return found;
    }

    public synchronized void addJavaXid(javax.transaction.xa.Xid javaxxid) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("addJavaXid javaxxid=" + javaxxid));
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"new JavaxXid added to the list");
        }
        this.javaxxidList.addElement(javaxxid);
    }

    public int getStatus() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
        }
        return this.status;
    }

    public javax.transaction.xa.Xid getJavaxXid(int xaresindex) {
        javax.transaction.xa.Xid myjavaxxid = (javax.transaction.xa.Xid)this.javaxxidList.elementAt(xaresindex);
        return myjavaxxid;
    }

    public void setRollbackOnly() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
        }
        switch (this.status) {
            case 0: 
            case 5: 
            case 7: {
                this.status = 1;
                break;
            }
            case 1: 
            case 9: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                TraceTm.jotm.error((Object)"Cannot set transaction as rollback only");
                TraceTm.jotm.error((Object)("Bad status=" + StatusHelper.getStatusName(this.status)));
            }
        }
    }

    private void doForget() throws RemoteException {
        TraceTm.jta.debug((Object)"SubCoordinator.doForget()");
        boolean exception = false;
        for (int i = 0; i < this.resourceList.size(); ++i) {
            XAResource xar = (XAResource)this.resourceList.elementAt(i);
            javax.transaction.xa.Xid myjavaxxid = (javax.transaction.xa.Xid)this.javaxxidList.elementAt(i);
            XidImpl xid = new XidImpl(this.xid, i);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("xid=" + xid));
                TraceTm.jta.debug((Object)("forgotten with resource= " + xar));
            }
            try {
                xar.forget(myjavaxxid);
                continue;
            }
            catch (XAException e) {
                String error = "Cannot send xar.forget:" + e + " (error code = " + e.errorCode + ") --" + e.getMessage();
                TraceTm.jotm.error((Object)("Got XAException from xar.forget: " + error));
                exception = true;
            }
        }
        if (exception) {
            throw new RemoteException("XAException on forget");
        }
        SubCoordinator.unexportObject((Remote)this);
    }

    private synchronized int doPrepare() throws RemoteException {
        TraceTm.jta.debug((Object)"SubCoordinator.doPrepare()");
        String jotmPrepareRecord = "PREPARE";
        int ret = 2;
        int errors = 0;
        if (this.resourceList.size() == 0) {
            Current.getCurrent().incrementCommitCounter();
            this.status = 3;
            return ret;
        }
        this.log = new SLog();
        this.status = 7;
        for (int i = 0; i < this.resourceList.size(); ++i) {
            String error;
            XAResource res = (XAResource)this.resourceList.elementAt(i);
            javax.transaction.xa.Xid myjavaxxid = (javax.transaction.xa.Xid)this.javaxxidList.elementAt(i);
            XidImpl xid = new XidImpl(this.xid, i);
            if (errors > 0) {
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)("xid=" + xid));
                    TraceTm.jta.debug((Object)("rolled back with resource= " + res));
                }
                try {
                    res.rollback(myjavaxxid);
                }
                catch (XAException e) {
                    error = "Cannot send res.rollback:" + e + " (error code = " + e.errorCode + ") --" + e.getMessage();
                    TraceTm.jotm.error((Object)("Got XAException from res.rollback: " + error));
                }
                continue;
            }
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("xid=" + xid));
                TraceTm.jta.debug((Object)("prepared with resource= " + res));
            }
            try {
                switch (res.prepare(myjavaxxid)) {
                    case 0: {
                        this.log.addResource(res, xid);
                        ret = 0;
                        break;
                    }
                }
                continue;
            }
            catch (XAException e) {
                error = "Cannot send res.prepare:" + e + " (error code = " + e.errorCode + ") --" + e.getMessage();
                TraceTm.jotm.error((Object)("Got XAException from res.prepare: " + error));
                ret = 1;
                ++errors;
            }
        }
        switch (ret) {
            case 2: {
                Current.getCurrent().incrementCommitCounter();
                this.status = 3;
                break;
            }
            case 0: {
                this.status = 2;
                break;
            }
            case 1: {
                this.status = 9;
            }
        }
        return ret;
    }

    private synchronized int doCommit() throws RemoteException {
        String howlerror;
        int reslength;
        XAResource res;
        int i;
        TraceTm.jta.debug((Object)"SubCoordinator.doCommit()");
        if (this.log == null) {
            TraceTm.jotm.error((Object)"doCommit: no log");
            return -1;
        }
        int errors = 0;
        int commitnb = 0;
        int heuristicnb = 0;
        List loggedResources = this.log.getLoggedResources();
        List loggedXids = this.log.getLoggedXids();
        XACommittingTx xaCommitTx = null;
        XACommittingTx xaCommitTxRewrite = null;
        byte[][] recoveryBuffer = new byte[loggedResources.size() + 1][];
        byte[] recoveryRecord1 = null;
        byte[] recoveryRecord2 = null;
        String rt1 = "RR1";
        String rt2 = "RR2";
        Xid txxid = this.tx.getXid();
        String stxxid = txxid.toString(true);
        int txxidlength = stxxid.length();
        String txdate = this.tx.getTxDate();
        int txdatelength = txdate.length();
        long rcdate = System.currentTimeMillis();
        recoveryRecord1 = new byte[15 + txxidlength + 4 + txdatelength + 4];
        ByteBuffer rr1 = ByteBuffer.wrap(recoveryRecord1);
        rr1.put(rt1.getBytes());
        rr1.putLong(rcdate);
        rr1.putInt(txxidlength);
        rr1.put(stxxid.getBytes());
        rr1.putInt(txdatelength);
        rr1.put(txdate.getBytes());
        rr1.putInt(loggedResources.size());
        recoveryBuffer[0] = rr1.array();
        byte[] jotmDone = new byte[11];
        byte[][] jotmDoneRecord = new byte[1][11];
        jotmDone = "RR3JOTMDONE".getBytes();
        if (Current.getDefaultRecovery()) {
            for (i = 0; i < loggedResources.size(); ++i) {
                res = (XAResource)loggedResources.get(i);
                Xid xid = (Xid)loggedXids.get(i);
                int rmindex = 99;
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug((Object)("recovery xid=" + xid));
                    TraceTm.recovery.debug((Object)("recovery resource= " + res));
                }
                reslength = res.toString().length();
                int resnamelength = res.getClass().getName().length();
                int xidlength = xid.toString(true).length();
                recoveryRecord2 = new byte[11 + reslength + 4 + resnamelength + 4 + xidlength + 4];
                ByteBuffer rr2 = ByteBuffer.wrap(recoveryRecord2);
                rr2.put(rt2.getBytes());
                rr2.putInt(rmindex);
                rr2.putInt(reslength);
                rr2.put(res.toString().getBytes());
                rr2.putInt(resnamelength);
                rr2.put(res.getClass().getName().getBytes());
                rr2.putInt(xidlength);
                rr2.put(xid.toString(true).getBytes());
                rr2.putInt(this.status);
                recoveryBuffer[i + 1] = rr2.array();
            }
        }
        if (Current.getDefaultRecovery()) {
            try {
                xaCommitTx = TransactionRecoveryImpl.getTransactionRecovery().howlCommitLog(recoveryBuffer);
            }
            catch (Exception e) {
                this.status = 4;
                howlerror = "Cannot howlCommitLog:" + e + " --" + e.getMessage();
                TraceTm.jotm.error((Object)("Got LogException from howlCommitLog: " + howlerror));
                xaCommitTx = null;
                this.doAfterCompletion();
                this.log.forgetLog();
                throw new TransactionRolledbackException();
            }
        }
        this.status = 8;
        for (i = 0; i < loggedResources.size(); ++i) {
            ByteBuffer rr2;
            block34: {
                res = (XAResource)loggedResources.get(i);
                javax.transaction.xa.Xid myjavaxxid = (javax.transaction.xa.Xid)this.javaxxidList.elementAt(i);
                Xid xid = (Xid)loggedXids.get(i);
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)("xid=" + xid));
                    TraceTm.jta.debug((Object)("attempting commit with resource= " + res));
                }
                reslength = res.toString().length();
                int xidlength = xid.toString(true).length();
                recoveryRecord2 = new byte[4 + reslength + 4 + xidlength + 4];
                rr2 = ByteBuffer.wrap(recoveryRecord2);
                if (Current.getDefaultRecovery()) {
                    rr2.putInt(reslength);
                    rr2.put(res.toString().getBytes());
                    rr2.putInt(xidlength);
                    rr2.put(xid.toString(true).getBytes());
                }
                try {
                    res.commit(myjavaxxid, false);
                    if (Current.getDefaultRecovery()) {
                        rr2.putInt(3);
                    }
                    ++commitnb;
                }
                catch (XAException e) {
                    switch (e.errorCode) {
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            System.out.println("Heuristic error= " + e.getMessage());
                            if (!Current.getDefaultRecovery()) break;
                            rr2.putInt(5);
                            break;
                        }
                        case -7: 
                        case -6: 
                        case -5: 
                        case -4: 
                        case -3: {
                            System.out.println("RM error= " + e.getMessage());
                            if (!Current.getDefaultRecovery()) break;
                            rr2.putInt(8);
                            break;
                        }
                        default: {
                            System.out.println("Default error= " + e.getMessage());
                            if (!Current.getDefaultRecovery()) break;
                            rr2.putInt(4);
                        }
                    }
                    if (Current.getDefaultRecovery()) {
                        recoveryBuffer[i + 1] = rr2.array();
                    }
                    String error = "Cannot send res.commit:" + e + " (error code = " + e.errorCode + ") --" + e.getMessage();
                    TraceTm.jotm.error((Object)("Got XAException from res.commit: " + error));
                    ++errors;
                    if (commitnb <= 0) break block34;
                    ++heuristicnb;
                }
            }
            if (!Current.getDefaultRecovery()) continue;
            recoveryBuffer[i + 1] = rr2.array();
        }
        if (errors == 0) {
            Current.getCurrent().incrementCommitCounter();
            this.status = 3;
            if (Current.getDefaultRecovery()) {
                try {
                    if (TraceTm.recovery.isDebugEnabled()) {
                        TraceTm.recovery.debug((Object)"Done howl log, all okay");
                    }
                    jotmDoneRecord[0] = jotmDone;
                    TransactionRecoveryImpl.getTransactionRecovery().howlDoneLog(jotmDoneRecord, xaCommitTx);
                }
                catch (Exception f) {
                    howlerror = "Cannot howlDoneLog:" + f + "--" + f.getMessage();
                    TraceTm.jotm.error((Object)("Got LogException from howlDoneLog: " + howlerror));
                }
            }
            this.doAfterCompletion();
            this.log.forgetLog();
            return 0;
        }
        if (heuristicnb == 0) {
            this.status = 4;
            if (Current.getDefaultRecovery()) {
                try {
                    jotmDoneRecord[0] = jotmDone;
                    TransactionRecoveryImpl.getTransactionRecovery().howlDoneLog(jotmDoneRecord, xaCommitTx);
                }
                catch (Exception f) {
                    howlerror = "Cannot howlDoneLog" + f + "--" + f.getMessage();
                    TraceTm.jotm.error((Object)("Got LogException from howlDoneLog: " + howlerror));
                }
            }
            this.doAfterCompletion();
            this.log.forgetLog();
            throw new TransactionRolledbackException();
        }
        if (heuristicnb != 0) {
            if (Current.getDefaultRecovery()) {
                try {
                    xaCommitTxRewrite = TransactionRecoveryImpl.getTransactionRecovery().howlCommitLog(recoveryBuffer);
                }
                catch (Exception e) {
                    this.status = 5;
                    howlerror = "Cannot howlCommitLog:" + e + " --" + e.getMessage();
                    TraceTm.jotm.error((Object)("Got LogException from howlCommitLog: " + howlerror));
                    xaCommitTx = null;
                }
                this.doAfterCompletion();
                this.log.forgetLog();
                throw new HeuristicCommit();
            }
            this.status = 5;
            if (Current.getDefaultRecovery()) {
                try {
                    jotmDoneRecord[0] = jotmDone;
                    TransactionRecoveryImpl.getTransactionRecovery().howlDoneLog(jotmDoneRecord, xaCommitTx);
                }
                catch (Exception f) {
                    howlerror = "Cannot howlDoneLog" + f + "--" + f.getMessage();
                    TraceTm.jotm.error((Object)("Got LogException from howlDoneLog: " + howlerror));
                }
            }
            this.doAfterCompletion();
            this.log.forgetLog();
            throw new HeuristicCommit();
        }
        this.status = 5;
        this.doAfterCompletion();
        return -1;
    }

    private synchronized void doOnePhaseCommit() throws RemoteException {
        TraceTm.jta.debug((Object)"SubCoordinator.doOnePhaseCommit()");
        this.status = 8;
        XAResource res = (XAResource)this.resourceList.elementAt(0);
        javax.transaction.xa.Xid myjavaxxid = (javax.transaction.xa.Xid)this.javaxxidList.elementAt(0);
        XidImpl xid = new XidImpl(this.xid, 0);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("xid=" + xid));
            TraceTm.jta.debug((Object)("committed with resource= " + res));
        }
        try {
            Current.getCurrent().incrementCommitCounter();
            res.commit(myjavaxxid, true);
            this.status = 3;
        }
        catch (XAException e) {
            this.status = 5;
            String error = "Cannot send res.commit:" + e + " (error code = " + e.errorCode + ") --" + e.getMessage();
            TraceTm.jotm.error((Object)("Got XAException from res.commit: " + error));
            if (e.errorCode == 100) {
                throw new TransactionRolledbackException("XAException:" + error);
            }
            throw new RemoteException("XAException:" + error);
        }
        finally {
            this.doAfterCompletion();
        }
    }

    private synchronized void doRollback() throws RemoteException {
        TraceTm.jta.debug((Object)"SubCoordinator.doRollback()");
        this.status = 4;
        boolean hcomm = false;
        for (int i = 0; i < this.resourceList.size(); ++i) {
            XAResource res = (XAResource)this.resourceList.elementAt(i);
            javax.transaction.xa.Xid myjavaxxid = (javax.transaction.xa.Xid)this.javaxxidList.elementAt(i);
            XidImpl xid = new XidImpl(this.xid, i);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("xid=" + xid));
                TraceTm.jta.debug((Object)("rolled back with resource= " + res));
            }
            try {
                res.rollback(myjavaxxid);
                continue;
            }
            catch (XAException e) {
                switch (e.errorCode) {
                    case 7: {
                        hcomm = true;
                    }
                }
                String error = "Cannot send res.rollback:" + e + " (error code = " + e.errorCode + ") --" + e.getMessage();
                TraceTm.jotm.error((Object)("Got XAException from res.rollback: " + error));
                throw new RemoteException("rollback: Unexpected XAException:" + e.errorCode);
            }
        }
        this.doAfterCompletion();
        Current.getCurrent().incrementRollbackCounter();
        if (hcomm) {
            throw new HeuristicCommit();
        }
    }

    private void doBeforeCompletion(boolean committing) {
        block32: {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("doBeforeCompletion committing= " + committing));
            }
            if (this.beforeCompletionDone) {
                return;
            }
            this.tx.unsetTimer();
            if (committing && this.synchroList.size() > 0) {
                String error;
                boolean resumed;
                boolean suspended;
                Transaction mytx;
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                mytx = null;
                                suspended = false;
                                resumed = false;
                                try {
                                    mytx = this.tm.getTransaction();
                                }
                                catch (SystemException e) {
                                    if (!TraceTm.jta.isDebugEnabled()) break block28;
                                    error = "Cannot get transaction:" + (Object)((Object)e) + "--" + e.getMessage();
                                    TraceTm.jta.debug((Object)error);
                                }
                            }
                            if (mytx != null && !mytx.equals(this.tx)) {
                                try {
                                    this.tm.suspend();
                                    suspended = true;
                                }
                                catch (SystemException e) {
                                    if (!TraceTm.jta.isDebugEnabled()) break block29;
                                    error = "Cannot suspend transaction:" + (Object)((Object)e) + "--" + e.getMessage();
                                    TraceTm.jta.debug((Object)error);
                                }
                            }
                        }
                        if (mytx == null || suspended) {
                            try {
                                this.tm.resume((Transaction)this.tx);
                                resumed = true;
                            }
                            catch (SystemException e) {
                                if (TraceTm.jta.isDebugEnabled()) {
                                    error = "Cannot resume transaction:" + (Object)((Object)e) + "--" + e.getMessage();
                                    TraceTm.jta.debug((Object)error);
                                }
                            }
                            catch (InvalidTransactionException e) {
                                if (TraceTm.jta.isDebugEnabled()) {
                                    error = "Cannot resume transaction:" + (Object)((Object)e) + "--" + e.getMessage();
                                    TraceTm.jta.debug((Object)error);
                                }
                            }
                            catch (IllegalStateException e) {
                                if (!TraceTm.jta.isDebugEnabled()) break block30;
                                error = "Cannot resume transaction:" + e + "--" + e.getMessage();
                                TraceTm.jta.debug((Object)error);
                            }
                        }
                    }
                    if (TraceTm.jta.isDebugEnabled()) {
                        TraceTm.jta.debug((Object)("sychronization list size= " + this.synchroList.size()));
                    }
                    for (int i = 0; i < this.synchroList.size(); ++i) {
                        Synchronization sync = (Synchronization)this.synchroList.elementAt(i);
                        if (TraceTm.jta.isDebugEnabled()) {
                            TraceTm.jta.debug((Object)("Synchronization sync= " + sync));
                        }
                        sync.beforeCompletion();
                    }
                    if (resumed) {
                        try {
                            this.tm.suspend();
                        }
                        catch (SystemException e) {
                            if (!TraceTm.jta.isDebugEnabled()) break block31;
                            error = "Cannot suspend transaction:" + (Object)((Object)e) + "--" + e.getMessage();
                            TraceTm.jta.debug((Object)error);
                        }
                    }
                }
                if (suspended) {
                    try {
                        this.tm.resume(mytx);
                        resumed = true;
                    }
                    catch (SystemException e) {
                        if (TraceTm.jta.isDebugEnabled()) {
                            error = "Cannot resume transaction:" + (Object)((Object)e) + "--" + e.getMessage();
                            TraceTm.jta.debug((Object)error);
                        }
                    }
                    catch (InvalidTransactionException e) {
                        if (TraceTm.jta.isDebugEnabled()) {
                            error = "Cannot resume transaction:" + (Object)((Object)e) + "--" + e.getMessage();
                            TraceTm.jta.debug((Object)error);
                        }
                    }
                    catch (IllegalStateException e) {
                        if (!TraceTm.jta.isDebugEnabled()) break block32;
                        error = "Cannot resume transaction:" + e + "--" + e.getMessage();
                        TraceTm.jta.debug((Object)error);
                    }
                }
            }
        }
        this.beforeCompletionDone = true;
    }

    private void doAfterCompletion() {
        TraceTm.jta.debug((Object)"doAfterCompletion()");
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("sychronization list size= " + this.synchroList.size()));
        }
        for (int i = 0; i < this.synchroList.size(); ++i) {
            Synchronization sync = (Synchronization)this.synchroList.elementAt(i);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("Synchronization sync= " + sync));
                TraceTm.jta.debug((Object)("sync.afterCompletion status= " + StatusHelper.getStatusName(this.status)));
            }
            sync.afterCompletion(this.status);
        }
        Current.getCurrent().forgetTx(this.tx.getXid());
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("SubCoordinator unexported [subcoord=" + this + "]"));
        }
        try {
            SubCoordinator.unexportObject((Remote)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getXaresIndex(XAResource xares) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("getXaresIndex xares= " + xares));
            TraceTm.jta.debug((Object)("resourceList.size= " + this.resourceList.size()));
        }
        int xaresIndex = -1;
        for (int i = 0; i < this.resourceList.size(); ++i) {
            XAResource res = (XAResource)this.resourceList.elementAt(i);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("res= " + res));
            }
            if (!new String(res.toString()).equals(new String(xares.toString()))) continue;
            xaresIndex = i;
            break;
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("xaresIndex= " + xaresIndex));
        }
        return xaresIndex;
    }
}

