/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpOutputStream;
import org.mortbay.log.LogFactory;
import org.mortbay.util.IO;
import org.mortbay.util.LogSupport;

class ServletWriter
extends PrintWriter {
    private static Log log = LogFactory.getLog(class$org$mortbay$jetty$servlet$ServletWriter == null ? (class$org$mortbay$jetty$servlet$ServletWriter = ServletWriter.class$("org.mortbay.jetty.servlet.ServletWriter")) : class$org$mortbay$jetty$servlet$ServletWriter);
    String encoding = null;
    OutputStream os = null;
    boolean written = false;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$ServletWriter;

    ServletWriter(OutputStream os) throws IOException {
        super(os instanceof HttpOutputStream ? ((HttpOutputStream)os).getWriter(null) : new OutputStreamWriter(os));
        this.os = os;
    }

    ServletWriter(OutputStream os, String encoding) throws IOException {
        super(os instanceof HttpOutputStream ? ((HttpOutputStream)os).getWriter(encoding) : new OutputStreamWriter(os, encoding));
        this.os = os;
        this.encoding = encoding;
    }

    public void disable() {
        this.out = IO.getNullWriter();
    }

    public void reset() {
        try {
            this.out = IO.getNullWriter();
            super.flush();
            this.out = new OutputStreamWriter(this.os, this.encoding);
            this.written = false;
        }
        catch (UnsupportedEncodingException e) {
            log.fatal((Object)e);
            System.exit(1);
        }
    }

    public boolean isWritten() {
        return this.written;
    }

    public void print(boolean p) {
        this.written = true;
        super.print(p);
    }

    public void print(char p) {
        this.written = true;
        super.print(p);
    }

    public void print(char[] p) {
        this.written = true;
        super.print(p);
    }

    public void print(double p) {
        this.written = true;
        super.print(p);
    }

    public void print(float p) {
        this.written = true;
        super.print(p);
    }

    public void print(int p) {
        this.written = true;
        super.print(p);
    }

    public void print(long p) {
        this.written = true;
        super.print(p);
    }

    public void print(Object p) {
        this.written = true;
        super.print(p);
    }

    public void print(String p) {
        this.written = true;
        super.print(p);
    }

    public void println() {
        this.written = true;
        super.println();
    }

    public void println(boolean p) {
        this.written = true;
        super.println(p);
    }

    public void println(char p) {
        this.written = true;
        super.println(p);
    }

    public void println(char[] p) {
        this.written = true;
        super.println(p);
    }

    public void println(double p) {
        this.written = true;
        super.println(p);
    }

    public void println(float p) {
        this.written = true;
        super.println(p);
    }

    public void println(int p) {
        this.written = true;
        super.println(p);
    }

    public void println(long p) {
        this.written = true;
        super.println(p);
    }

    public void println(Object p) {
        this.written = true;
        super.println(p);
    }

    public void println(String p) {
        this.written = true;
        super.println(p);
    }

    public void write(int c) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(c);
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
            this.setError();
        }
    }

    public void write(char[] cbuf, int off, int len) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(cbuf, off, len);
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
            this.setError();
        }
    }

    public void write(char[] cbuf) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(cbuf, 0, cbuf.length);
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
            this.setError();
        }
    }

    public void write(String s, int off, int len) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(s, off, len);
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
            this.setError();
        }
    }

    public void write(String s) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(s, 0, s.length());
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
            this.setError();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

