/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.spi;

import com.sun.jndi.rmi.registry.RemoteReference;
import java.io.Serializable;
import java.rmi.Remote;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.ObjectFactory;
import org.objectweb.carol.jndi.wrapping.JNDIReferenceWrapper;
import org.objectweb.carol.jndi.wrapping.JNDIRemoteResource;
import org.objectweb.carol.jndi.wrapping.JNDIResourceWrapper;
import org.objectweb.carol.util.configuration.CarolCurrentConfiguration;

public class IIOPContext
implements Context {
    private static Context iiopContext = null;
    private static HashMap hashMap = new HashMap();
    private static Hashtable wrapperHash = new Hashtable();

    private IIOPContext(Context iiopCtx) throws NamingException {
        iiopContext = iiopCtx;
    }

    public static Context getSingleInstance(Hashtable env) throws NamingException {
        Context ctx;
        String key = null;
        if (env != null) {
            key = (String)env.get("java.naming.provider.url");
        }
        if ((ctx = (Context)hashMap.get(key)) == null) {
            env.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
            ctx = new IIOPContext(new InitialContext(env));
            hashMap.put(key, ctx);
        }
        return ctx;
    }

    private Object unwrapObject(Object o, Name name) throws NamingException {
        try {
            if (o instanceof RemoteReference) {
                Reference objRef = ((RemoteReference)o).getReference();
                ObjectFactory objFact = (ObjectFactory)Class.forName(objRef.getFactoryClassName()).newInstance();
                return objFact.getObjectInstance(objRef, name, this, iiopContext.getEnvironment());
            }
            if (o instanceof JNDIRemoteResource) {
                return ((JNDIRemoteResource)o).getResource();
            }
            return o;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NamingException("" + e);
        }
    }

    private Object wrapObject(Object o, Name name, boolean replace) throws NamingException {
        try {
            if (!(o instanceof Remote) && o instanceof Referenceable) {
                JNDIReferenceWrapper irw = new JNDIReferenceWrapper(((Referenceable)o).getReference());
                CarolCurrentConfiguration.getCurrent().getCurrentPortableRemoteObject().exportObject((Remote)irw);
                Remote oldObj = wrapperHash.put(name, irw);
                if (oldObj != null) {
                    if (replace) {
                        CarolCurrentConfiguration.getCurrent().getCurrentPortableRemoteObject().unexportObject(oldObj);
                    } else {
                        CarolCurrentConfiguration.getCurrent().getCurrentPortableRemoteObject().unexportObject((Remote)irw);
                        wrapperHash.put(name, oldObj);
                        throw new NamingException("Object already bind");
                    }
                }
                return irw;
            }
            if (!(o instanceof Remote) && o instanceof Reference) {
                JNDIReferenceWrapper irw = new JNDIReferenceWrapper((Reference)o);
                CarolCurrentConfiguration.getCurrent().getCurrentPortableRemoteObject().exportObject((Remote)irw);
                Remote oldObj = wrapperHash.put(name, irw);
                if (oldObj != null) {
                    if (replace) {
                        CarolCurrentConfiguration.getCurrent().getCurrentPortableRemoteObject().unexportObject(oldObj);
                    } else {
                        CarolCurrentConfiguration.getCurrent().getCurrentPortableRemoteObject().unexportObject((Remote)irw);
                        wrapperHash.put(name, oldObj);
                        throw new NamingException("Object already bind");
                    }
                }
                return irw;
            }
            if (!(o instanceof Remote) && o instanceof Serializable) {
                JNDIResourceWrapper irw = new JNDIResourceWrapper((Serializable)o);
                CarolCurrentConfiguration.getCurrent().getCurrentPortableRemoteObject().exportObject((Remote)irw);
                Remote oldObj = wrapperHash.put(name, irw);
                if (oldObj != null) {
                    if (replace) {
                        CarolCurrentConfiguration.getCurrent().getCurrentPortableRemoteObject().unexportObject(oldObj);
                    } else {
                        CarolCurrentConfiguration.getCurrent().getCurrentPortableRemoteObject().unexportObject((Remote)irw);
                        wrapperHash.put(name, oldObj);
                        throw new NamingException("Object already bind");
                    }
                }
                return irw;
            }
            return o;
        }
        catch (Exception e) {
            throw new NamingException("" + e);
        }
    }

    public Object lookup(Name name) throws NamingException {
        return this.unwrapObject(iiopContext.lookup(name), name);
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    public void bind(Name name, Object obj) throws NamingException {
        iiopContext.bind(name, this.wrapObject(obj, name, false));
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(new CompositeName(name), obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        iiopContext.rebind(name, this.wrapObject(obj, name, true));
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new CompositeName(name), obj);
    }

    public void unbind(Name name) throws NamingException {
        try {
            iiopContext.unbind(name);
            if (wrapperHash.containsKey(name)) {
                CarolCurrentConfiguration.getCurrent().getCurrentPortableRemoteObject().unexportObject((Remote)wrapperHash.remove(name));
            }
        }
        catch (Exception e) {
            throw new NamingException("" + e);
        }
    }

    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        if (wrapperHash.containsKey(oldName)) {
            wrapperHash.put(newName, wrapperHash.remove(oldName));
        }
        iiopContext.rename(oldName, newName);
    }

    public void rename(String name, String newName) throws NamingException {
        this.rename(new CompositeName(name), new CompositeName(newName));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return iiopContext.list(name);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return iiopContext.listBindings(name);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        iiopContext.destroySubcontext(name);
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new CompositeName(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        return iiopContext.createSubcontext(name);
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new CompositeName(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        return iiopContext.lookupLink(name);
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(new CompositeName(name));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return iiopContext.getNameParser(name);
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(new CompositeName(name));
    }

    public String composeName(String name, String prefix) throws NamingException {
        return name;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        return (Name)name.clone();
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return iiopContext.addToEnvironment(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return iiopContext.removeFromEnvironment(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return iiopContext.getEnvironment();
    }

    public void close() throws NamingException {
    }

    public String getNameInNamespace() throws NamingException {
        return iiopContext.getNameInNamespace();
    }
}

