/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.util.perfs;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.rmi.server.RMIClassLoaderSpi;
import sun.rmi.server.MarshalOutputStream;

public class CarolJRMPPerformanceHelper {
    private static RMIClassLoaderSpi defRMISpi;

    public static String getMarshalBytes(Object obj) {
        try {
            String result = CarolJRMPPerformanceHelper.getClassString(obj.getClass()) + "<serialization>\n";
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            MarshalOutputStream p = new MarshalOutputStream(ostream);
            p.writeObject(obj);
            p.flush();
            byte[] b = ostream.toByteArray();
            int i = 0;
            while (i < b.length) {
                result = b[i] >= 0 && b[i] < 32 ? result + "<" + b[i] + ">" : result + (char)b[i];
                ++i;
            }
            result = result + "</serialization>\n";
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getMarshalSize(Object obj) {
        try {
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            MarshalOutputStream p = new MarshalOutputStream(ostream);
            p.writeObject(obj);
            p.flush();
            return ostream.size();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getClassString(Class cl) {
        ClassLoader loader = cl.getClassLoader();
        String result = "<class>\n";
        result = result + "<classloader>" + loader.getClass().getName() + "</classloader>\n";
        result = result + "<annotations>" + defRMISpi.getClassAnnotation(cl) + "</annotaions>\n";
        result = result + "</class>";
        return result;
    }

    public static String getClassAnnotation(Class cl) {
        ClassLoader loader = cl.getClassLoader();
        return defRMISpi.getClassAnnotation(cl);
    }

    static {
        try {
            Class<?> cl = Class.forName("java.rmi.server.RMIClassLoader");
            Method meth = cl.getMethod("getDefaultProviderInstance", new Class[0]);
            defRMISpi = (RMIClassLoaderSpi)meth.invoke(cl, new Object[0]);
        }
        catch (Exception e) {}
    }
}

