package jfractionlab.worksheets;

import java.io.File;
import java.util.ArrayList;

import jfractionlab.JFractionLab;

public class WSGSubtraction extends WorkSheetGenerator {
	
	private ArrayList<ExerciseSubtraction> al_exercises;
	
	public WSGSubtraction(File exerciseFile, File solutionFile) {
		super(lang.Messages.getString("minus_fractions"), WorkSheetGenerator.ONE_COLUMN); 
			al_exercises = new ArrayList<ExerciseSubtraction>();
			al_solutionLine = new ArrayList<String>();
			mkExercises(nb_of_exercises,10);
			generateText();
			writeFile(
					exerciseFile,
					al_exercisesText,
					true
			);
			writeFile(
					solutionFile,
					al_solutionsText,
					false
			);
	}//Constructor
	
	protected void mkExercises(int nb, int max){
		for (int i = 0; i<nb; i++){
			al_exercises.add(new ExerciseSubtraction(max));
		}//for
	}//mkFractions
	
	@Override
	protected String writeOneLine(boolean isExercise, int nb) {
		String strReturn = "";
		int n1 = al_exercises.get(nb).getN1();
		int d1 = al_exercises.get(nb).getD1();
		int n2 = al_exercises.get(nb).getN2();
		int d2 = al_exercises.get(nb).getD2();
		int lcd = al_exercises.get(nb).getLCD();

		if(isExercise){
			strReturn += String.valueOf(nb+1);
			strReturn += "&"; //-----------------------
			strReturn += "$\\frac{"+n1+"}{"+d1+"}";
			strReturn += " - ";
			strReturn += "\\frac{"+n2+"}{"+d2+"}$";
			strReturn += " =\\\\";
		}else{
			strReturn += String.valueOf(nb+1);
			strReturn += "&"; //-----------------------
			strReturn += "$\\frac{"+n1+"}{"+d1+"}";
			strReturn += " - ";
			strReturn += "\\frac{"+n2+"}{"+d2+"}$";
			strReturn += " = ";
			int f1 = lcd/d1;
			int f2 = lcd/d2;
			if(f1 > 1 || f2 > 1){
				if(f1 > 1){
					strReturn += "$\\frac{"+n1+"*"+f1+"}{"+d1+"*"+f1+"}";
				}else{
					strReturn += "$\\frac{"+n1+"}{"+d1+"}";
				}
				strReturn += " - ";
				if(f2 > 1){
					strReturn += "\\frac{"+n2+"*"+f2+"}{"+d2+"*"+f2+"}$";
				}else{
					strReturn += "\\frac{"+n2+"}{"+d2+"}$";
				}
				strReturn += " = ";
	
				strReturn += "$\\frac{"+(n1*f1)+"}{"+(d1*f1)+"}";
				strReturn += " - ";
				strReturn += "\\frac{"+(n2*f2)+"}{"+(d2*f2)+"}$";
				strReturn += " = ";
	
				strReturn += "$\\frac{"+(n1*f1)+" - "+(n2*f2)+"}{"+lcd+"}$ = ";
			}
			strReturn += writeResult((n1*f1), (n2*f2), lcd);
			//--------------------
			strReturn += "\\\\";
		}
		return strReturn;
	}
	
	private String writeResult(int n1, int n2, int lcd){
		String strReturn ="";
		String strBla = "";
		int n = n1-n2;
		int ggt = JFractionLab.greatestCommonDivisor(n, lcd);
		strReturn += "$\\frac{";
		strReturn += String.valueOf(n);
		strReturn += "}{";
		strReturn += String.valueOf(lcd);
		strReturn += "}$";
		strBla = strReturn;
		
		if(n < lcd){
			if(n != n/ggt){
				strBla = "$\\frac{";
				strBla += String.valueOf(n/ggt);
				strBla += "}{";
				strBla += String.valueOf(lcd/ggt);
				strBla += "}$";
				strReturn += " = "+strBla;
			}
		}else if (n > lcd){
			int n_reduced = n;
			int lcd_reduced = lcd;
			
			if(n != n/ggt){
				n_reduced = n/ggt;
				lcd_reduced = lcd/ggt;
				strBla = "$\\frac{";
				strBla += String.valueOf(n_reduced);
				strBla += "}{";
				strBla += String.valueOf(lcd_reduced);
				strBla += "}$";
				strReturn += " = "+strBla;
			}
			strBla = String.valueOf(n_reduced/lcd_reduced);
			strBla += "$\\frac{";
			strBla += String.valueOf(n_reduced%lcd_reduced);
			strBla += "}{";
			strBla += lcd_reduced;
			strBla += "}$";
			strReturn += " = "+strBla;
		}else if(n == lcd){
			strBla = "1";
			strReturn += " = "+strBla;
		}
		al_solutionLine.add(strBla);
		return strReturn;
	}
}