#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <jvmpi.h>
#include <translate.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <method.h>
#include <cls.h>
#include <mvector.h>

method* method_new (const char* method_name, char* method_signature, 
		    jint start_lineno, jint end_lineno,
		    jmethodID method_id, cls* owner) {
    char* buf;
    method* m;
    size_t l1, l2, l3;
    
    /* initialize each field to zero... */
    m = calloc (1, sizeof (*m));
    if (m == NULL)
	return NULL;
    l1 = strlen (method_name) + 1;
    l2 = strlen (method_signature) + 1;

    buf = calloc (1000, 1);
    translate_method (method_name, method_signature, buf);
    l3 = strlen (buf) + 1;
    
    m->method_name = malloc (l1);
    m->method_signature = malloc (l2);
    m->jmpname = malloc (l3);
    m->called_methods = mvector_new (5);
    if (m->method_name == NULL ||
	m->method_signature == NULL ||
	m->jmpname == NULL ||
	m->called_methods == NULL) {
	method_free (m);
	return NULL;
    }
    strncpy (m->method_name, method_name, l1);
    strncpy (m->method_signature, method_signature, l2);
    strncpy (m->jmpname, buf, l3);
    free (buf);
    m->start_lineno = start_lineno;
    m->end_lineno = end_lineno;
    m->method_id = method_id;
    m->owner = owner;
    return m;
}

void method_free (method* m) {
    if (m == NULL)
	return;
    free (m->method_name);
    m->method_name = NULL;
    free (m->method_signature);
    m->method_signature = NULL;
    free (m->jmpname);
    m->jmpname = NULL;
    mvector_free (m->called_methods);
    m->called_methods = NULL;
    free (m);
}

size_t method_jmphash_func (void* c, size_t len) {
    method* mp = (method*)c;
    return ((long)mp->method_id) % len;
}

int method_cmp_func (void* c1, void* c2) {
    method* m1 = (method*)c1;
    method* m2 = (method*)c2;;
    return m1->method_id != m2->method_id;
}

void method_print (method* m) {
    fprintf (stdout, "    %s (%s), %d -> %d, %p\n", 
	     m->method_name, m->method_signature,
	     m->start_lineno, m->end_lineno, 
	     m->method_id);    
}

inline void method_set_method_id (method* m, jmethodID method_id) {
    m->method_id = method_id;
}

inline jmethodID method_get_method_id (const method* m) {
    return m->method_id;
}

inline char* method_get_method_name (method* m) {
    return m->method_name;
}

inline char* method_get_method_signature (method* m) {
    return m->method_signature;
}

inline char* method_get_method_jmpname (method* m) {
    return m->jmpname;
}

inline jobjectID method_get_class_id (method* m) {
    return cls_get_class_id (m->owner);
}

inline long method_get_calls (method* m) {
    return m->calls;
}

inline long method_get_restore_calls (method* m) {
    return m->restore_calls;
}

inline methodtime* method_get_time_used (method* m) {
    return &m->time_used;
}

inline methodtime* method_get_restore_time (method* m) {
    return &m->restore_time;
}

inline cls* method_get_owner (method* m) {
    return m->owner;
}

inline void method_reset_count (method* m) {
    m->restore_calls += m->calls;
    m->calls = 0;
    m->restore_time.tv += m->time_used.tv;
    m->time_used.tv = 0;
    m->restore_time.tv_hold += m->time_used.tv_hold;
    m->time_used.tv_hold = 0;
    m->restore_objects += m->allocated_objects;
    m->allocated_objects = 0;
    m->restore_memory += m->allocated_memory;
    m->allocated_memory = 0;
    m->modified = 1;
}

inline void method_restore_count (method* m) {
    m->calls += m->restore_calls;
    m->restore_calls = 0;
    m->time_used.tv += m->restore_time.tv;
    m->restore_time.tv = 0;
    m->time_used.tv_hold += m->restore_time.tv_hold;
    m->restore_time.tv_hold = 0;
    m->allocated_objects += m->restore_objects;
    m->restore_objects = 0;
    m->allocated_memory += m->restore_memory;
    m->restore_memory = 0;
    m->modified = 1;
}

inline int method_check_modified (method* m) {
    return m->modified;
}

inline void method_set_modified (method* m, int flag) {
    m->modified = flag;
}

/** Returns the number of objects allocated by this method */
inline int method_get_allocated_objects (method* m) {
    return m->allocated_objects;
}

/** Returns the number of bytes used for allocating objects by this method */
inline jlong method_get_allocated_memory (method* m) {
    return m->allocated_memory;
}

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
